/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.resolver;

import io.github.kscripting.kscript.model.Content;
import io.github.kscripting.kscript.model.KotlinOpt;
import io.github.kscripting.kscript.model.PackageName;
import io.github.kscripting.kscript.model.Script;
import io.github.kscripting.kscript.model.ScriptNode;
import io.github.kscripting.kscript.model.ScriptingConfig;
import io.github.kscripting.kscript.model.Section;
import io.github.kscripting.kscript.parser.LineParser;
import io.github.kscripting.kscript.resolver.InputOutputResolver;
import io.github.kscripting.kscript.resolver.ResolutionContext;
import io.github.kscripting.kscript.resolver.ScriptResolver;
import io.github.kscripting.kscript.resolver.SectionResolver;
import io.github.kscripting.kscript.util.ScriptUtils;
import io.github.kscripting.kscript.util.UriUtils;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.OsPathExtKt;
import io.github.kscripting.shell.model.ScriptLocation;
import io.github.kscripting.shell.model.ScriptSource;
import io.github.kscripting.shell.model.ScriptType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/kscripting/kscript/resolver/ScriptResolver;", "", "inputOutputResolver", "Lio/github/kscripting/kscript/resolver/InputOutputResolver;", "sectionResolver", "Lio/github/kscripting/kscript/resolver/SectionResolver;", "scriptingConfig", "Lio/github/kscripting/kscript/model/ScriptingConfig;", "(Lio/github/kscripting/kscript/resolver/InputOutputResolver;Lio/github/kscripting/kscript/resolver/SectionResolver;Lio/github/kscripting/kscript/model/ScriptingConfig;)V", "scripletName", "", "createScript", "Lio/github/kscripting/kscript/model/Script;", "scriptLocation", "Lio/github/kscripting/shell/model/ScriptLocation;", "scriptText", "allowLocalReferences", "", "maxResolutionLevel", "", "resolve", "string", "preambles", "", "kscript"})
public final class ScriptResolver {
    @NotNull
    private final InputOutputResolver inputOutputResolver;
    @NotNull
    private final SectionResolver sectionResolver;
    @NotNull
    private final ScriptingConfig scriptingConfig;
    @NotNull
    private final String scripletName;

    public ScriptResolver(@NotNull InputOutputResolver inputOutputResolver, @NotNull SectionResolver sectionResolver, @NotNull ScriptingConfig scriptingConfig) {
        Intrinsics.checkNotNullParameter((Object)inputOutputResolver, (String)"inputOutputResolver");
        Intrinsics.checkNotNullParameter((Object)sectionResolver, (String)"sectionResolver");
        Intrinsics.checkNotNullParameter((Object)scriptingConfig, (String)"scriptingConfig");
        this.inputOutputResolver = inputOutputResolver;
        this.sectionResolver = sectionResolver;
        this.scriptingConfig = scriptingConfig;
        this.scripletName = "scriplet";
    }

    @NotNull
    public final Script resolve(@NotNull String string, @NotNull List<String> preambles, int maxResolutionLevel) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(preambles, (String)"preambles");
        if (Intrinsics.areEqual((Object)string, (Object)"-") || Intrinsics.areEqual((Object)string, (Object)"/dev/stdin")) {
            String scriptText2 = ScriptUtils.INSTANCE.prependPreambles(preambles, SequencesKt.joinToString$default((Sequence)SequencesKt.generateSequence((Function0)resolve.scriptText.1.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            ScriptType scriptType = ScriptUtils.INSTANCE.resolveScriptType(scriptText2);
            ScriptLocation scriptLocation = new ScriptLocation(0, ScriptSource.STD_INPUT, scriptType, null, this.inputOutputResolver.resolveCurrentDir(), this.scripletName);
            return this.createScript(scriptLocation, scriptText2, true, maxResolutionLevel);
        }
        if (UriUtils.INSTANCE.isUrl(string)) {
            Content content = this.inputOutputResolver.resolveContent(new URI(string));
            String scriptText3 = ScriptUtils.INSTANCE.prependPreambles(preambles, content.getText());
            ScriptLocation scriptLocation = new ScriptLocation(0, ScriptSource.HTTP, content.getScriptType(), content.getUri(), content.getContextUri(), content.getFileName());
            return this.createScript(scriptLocation, scriptText3, false, maxResolutionLevel);
        }
        OsPath filePath = this.inputOutputResolver.tryToCreateShellFilePath(string);
        if (filePath != null) {
            ScriptType scriptType = ScriptType.Companion.findByExtension(OsPathExtKt.getLeaf((OsPath)filePath));
            if (this.inputOutputResolver.isReadable(filePath)) {
                if (scriptType != null) {
                    Content content = this.inputOutputResolver.resolveContent(filePath);
                    String scriptText4 = ScriptUtils.INSTANCE.prependPreambles(preambles, content.getText());
                    ScriptLocation scriptLocation = new ScriptLocation(0, ScriptSource.FILE, content.getScriptType(), content.getUri(), content.getContextUri(), content.getFileName());
                    return this.createScript(scriptLocation, scriptText4, true, maxResolutionLevel);
                }
                Content content = this.inputOutputResolver.resolveContentUsingInputStream(filePath);
                String scriptText5 = ScriptUtils.INSTANCE.prependPreambles(preambles, content.getText());
                ScriptLocation scriptLocation = new ScriptLocation(0, ScriptSource.OTHER_FILE, content.getScriptType(), content.getUri(), content.getContextUri(), this.scripletName);
                return this.createScript(scriptLocation, scriptText5, true, maxResolutionLevel);
            }
            if (scriptType != null) {
                throw new IllegalStateException("Could not read script from '" + string + "'");
            }
        }
        String scriptText6 = ScriptUtils.INSTANCE.prependPreambles(preambles, string);
        ScriptType scriptType = ScriptUtils.INSTANCE.resolveScriptType(scriptText6);
        ScriptLocation scriptLocation = new ScriptLocation(0, ScriptSource.PARAMETER, scriptType, null, this.inputOutputResolver.resolveCurrentDir(), this.scripletName);
        return this.createScript(scriptLocation, scriptText6, true, maxResolutionLevel);
    }

    public static /* synthetic */ Script resolve$default(ScriptResolver scriptResolver, String string, List list, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return scriptResolver.resolve(string, list, n);
    }

    /*
     * WARNING - void declaration
     */
    private final Script createScript(ScriptLocation scriptLocation, String scriptText2, boolean allowLocalReferences, int maxResolutionLevel) {
        ResolutionContext resolutionContext = new ResolutionContext(null, 0, null, 0, null, null, null, null, null, null, null, null, null, 8191, null);
        List<Section> sections = this.sectionResolver.resolve(scriptLocation, scriptText2, allowLocalReferences, maxResolutionLevel, resolutionContext);
        ScriptNode scriptNode = new ScriptNode(scriptLocation, sections);
        resolutionContext.getScriptNodes().add(scriptNode);
        String string = resolutionContext.getPackageName-tccyTyo();
        if (string == null) {
            string = PackageName.constructor-impl("kscript.scriplet");
        }
        resolutionContext.setPackageName-EkfO8Pc(string);
        String code = ScriptUtils.INSTANCE.resolveCode-iT8HOD0(resolutionContext.getPackageName-tccyTyo(), resolutionContext.getImportNames(), scriptNode);
        if (!StringsKt.isBlank((CharSequence)this.scriptingConfig.getProvidedKotlinOpts())) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = LineParser.INSTANCE.extractValues(this.scriptingConfig.getProvidedKotlinOpts());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KotlinOpt.box-impl(KotlinOpt.constructor-impl((String)it)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = ((KotlinOpt)element$iv).unbox-impl();
                boolean bl = false;
                resolutionContext.getKotlinOpts().add(KotlinOpt.box-impl(it));
            }
        }
        String digest = ScriptUtils.INSTANCE.calculateHash(code, resolutionContext);
        String string3 = resolutionContext.getPackageName-tccyTyo();
        Intrinsics.checkNotNull((Object)string3);
        return new Script(scriptLocation, code, string3, resolutionContext.getEntryPoint-_L1MFNs(), resolutionContext.getImportNames(), resolutionContext.getIncludes(), resolutionContext.getDependencies(), resolutionContext.getRepositories(), resolutionContext.getKotlinOpts(), resolutionContext.getCompilerOpts(), resolutionContext.getDeprecatedItems(), resolutionContext.getScriptNodes(), scriptNode, digest, null);
    }
}

