/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.util;

import io.github.kscripting.kscript.util.Logger;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.OsPathExtKt;
import io.github.kscripting.shell.model.ScriptType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u000fJ\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006\u00a8\u0006\u0018"}, d2={"Lio/github/kscripting/kscript/util/FileUtils;", "", "()V", "createDirsIfNeeded", "", "path", "Lio/github/kscripting/shell/model/OsPath;", "createFile", "content", "", "createSymLink", "", "link", "target", "getArtifactsRecursively", "", "osPath", "supportedExtensions", "resolveUniqueFilePath", "basePath", "fileName", "scriptType", "Lio/github/kscripting/shell/model/ScriptType;", "symLinkOrCopy", "kscript"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @NotNull
    public final OsPath createFile(@NotNull OsPath path2, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.createDirsIfNeeded(path2);
        OsPathExtKt.writeText$default((OsPath)path2, (CharSequence)content, null, (OpenOption[])new OpenOption[0], (int)2, null);
        return path2;
    }

    @NotNull
    public final OsPath symLinkOrCopy(@NotNull OsPath link, @NotNull OsPath target) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.createDirsIfNeeded(link);
        boolean isSymlinked = this.createSymLink(link, target);
        if (!isSymlinked) {
            Logger.INSTANCE.warnMsg("Failed to create symbolic link to script. Copying instead...");
            OsPathExtKt.copyTo$default((OsPath)target, (OsPath)link, (boolean)false, (int)2, null);
        }
        return link;
    }

    public final void createDirsIfNeeded(@NotNull OsPath path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path dir = OsPathExtKt.getParent((OsPath)path2);
        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(dir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        }
    }

    public final boolean createSymLink(@NotNull OsPath link, @NotNull OsPath target) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        try {
            Files.createSymbolicLink(OsPathExtKt.toNativePath((OsPath)link), OsPathExtKt.toNativePath((OsPath)target), new FileAttribute[0]);
            bl = true;
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final OsPath resolveUniqueFilePath(@NotNull OsPath basePath, @NotNull String fileName, @NotNull ScriptType scriptType) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)scriptType, (String)"scriptType");
        String[] stringArray = new String[]{fileName + scriptType.getExtension()};
        OsPath path2 = basePath.resolve(stringArray);
        int counter = 1;
        while (OsPathExtKt.exists((OsPath)path2)) {
            String[] stringArray2 = new String[]{fileName + "_" + counter + scriptType.getExtension()};
            path2 = basePath.resolve(stringArray2);
            ++counter;
        }
        return path2;
    }

    @NotNull
    public final List<OsPath> getArtifactsRecursively(@NotNull OsPath osPath, @NotNull List<String> supportedExtensions) {
        Intrinsics.checkNotNullParameter((Object)osPath, (String)"osPath");
        Intrinsics.checkNotNullParameter(supportedExtensions, (String)"supportedExtensions");
        List artifacts = new ArrayList();
        File file = OsPathExtKt.toNativeFile((OsPath)osPath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"osPath.toNativeFile().absoluteFile");
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)file, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!it.isFile() || !supportedExtensions.contains(FilesKt.getExtension((File)it))) continue;
            artifacts.add(OsPathExtKt.toOsPath((File)it));
        }
        Iterable $this$sortedBy$iv = artifacts;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OsPath it = (OsPath)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.stringPath());
                it = (OsPath)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.stringPath())));
            }
        });
    }
}

