/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.util;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lio/github/kscripting/kscript/util/UriUtils;", "", "()V", "isRegularFile", "", "uri", "Ljava/net/URI;", "isUrl", "string", "", "resolveRedirects", "Ljava/net/URL;", "url", "kscript"})
public final class UriUtils {
    @NotNull
    public static final UriUtils INSTANCE = new UriUtils();

    private UriUtils() {
    }

    public final boolean isUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String normalizedString = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return StringsKt.startsWith$default((String)normalizedString, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)normalizedString, (String)"https://", (boolean)false, (int)2, null);
    }

    public final boolean isUrl(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return uri.getScheme().equals("http") || uri.getScheme().equals("https");
    }

    public final boolean isRegularFile(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.scheme");
        return StringsKt.startsWith$default((String)string, (String)"file", (boolean)false, (int)2, null);
    }

    @NotNull
    public final URL resolveRedirects(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection con = (HttpURLConnection)uRLConnection;
        con.setInstanceFollowRedirects(false);
        con.connect();
        if (con.getResponseCode() == 301 || con.getResponseCode() == 302) {
            URL redirectUrl = new URL(con.getHeaderField("Location"));
            return this.resolveRedirects(redirectUrl);
        }
        return url;
    }
}

