/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript;

import io.github.kscripting.kscript.BuildConfig;
import io.github.kscripting.kscript.KscriptHandler;
import io.github.kscripting.kscript.code.Templates;
import io.github.kscripting.kscript.creator.DebugInfoCreator;
import io.github.kscripting.kscript.model.Config;
import io.github.kscripting.kscript.model.ConfigBuilder;
import io.github.kscripting.kscript.resolver.CommandResolver;
import io.github.kscripting.kscript.util.Executor;
import io.github.kscripting.kscript.util.Logger;
import io.github.kscripting.kscript.util.OptionsUtils;
import io.github.kscripting.kscript.util.VersionChecker;
import io.github.kscripting.shell.model.OsType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "kscript"})
public final class KscriptKt {
    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            void $this$associateTo$iv$iv;
            Collection $this$toTypedArray$iv;
            OsType osType = OsType.Companion.findOrThrow(args[0]);
            Properties properties = System.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties()");
            Map<String, String> map = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
            Config config = new ConfigBuilder(osType, properties, map).build();
            List remainingArgs = ArraysKt.drop((Object[])args, (int)1);
            Iterable $this$dropWhile$iv = remainingArgs;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"-", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)it, (Object)"-")) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List userArgs = CollectionsKt.drop((Iterable)list$iv, (int)1);
            List kscriptArgs = CollectionsKt.take((Iterable)remainingArgs, (int)(remainingArgs.size() - userArgs.size()));
            CommandLineParser parser = (CommandLineParser)new DefaultParser();
            Options options = OptionsUtils.INSTANCE.createOptions();
            try {
                $this$toTypedArray$iv = kscriptArgs;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = parser.parse(options, thisCollection$iv.toArray(new String[0]));
            }
            catch (ParseException e) {
                Logger.INSTANCE.info(OptionsUtils.INSTANCE.createHelpText(config.getOsConfig().getSelfName(), options));
                throw new IllegalArgumentException(e.getMessage());
            }
            Collection parsedLine = $this$toTypedArray$iv;
            Option[] optionArray = parsedLine.getOptions();
            Intrinsics.checkNotNullExpressionValue((Object)optionArray, (String)"parsedLine.options");
            Object[] $this$associate$iv = optionArray;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
            Object[] objectArray = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (void element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Option it = (Option)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getLongOpt(), (Object)it.getValue());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map parsedOptions = MapsKt.toMutableMap((Map)destination$iv$iv);
            List list = parsedLine.getArgList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parsedLine.argList");
            if (!((Collection)list).isEmpty()) {
                parsedOptions.put("script", parsedLine.getArgList().get(0));
            }
            if (parsedOptions.isEmpty() || parsedOptions.containsKey("interactive") && !parsedOptions.containsKey("script")) {
                Logger.INSTANCE.info(OptionsUtils.INSTANCE.createHelpText(config.getOsConfig().getSelfName(), options));
                throw new IllegalArgumentException("KScript requires 'script' as an argument");
            }
            Logger.INSTANCE.setSilentMode(parsedOptions.containsKey("silent"));
            Logger.INSTANCE.setDevMode(parsedOptions.containsKey("development"));
            if (Logger.INSTANCE.getDevMode()) {
                Logger.INSTANCE.info(new DebugInfoCreator().create(config, kscriptArgs, userArgs));
            }
            Executor executor = new Executor(new CommandResolver(config.getOsConfig()));
            if (parsedOptions.containsKey("help") || parsedOptions.containsKey("version")) {
                String newVersion;
                VersionChecker versionChecker = new VersionChecker(executor);
                String string = newVersion = versionChecker.isThereANewKscriptVersion() ? versionChecker.getRemoteKscriptVersion() : "";
                if (parsedOptions.containsKey("help")) {
                    Logger.INSTANCE.info(((Object)StringsKt.trimEnd((CharSequence)OptionsUtils.INSTANCE.createHelpText(config.getOsConfig().getSelfName(), options))).toString());
                }
                Logger.INSTANCE.info(Templates.INSTANCE.createVersionInfo(BuildConfig.INSTANCE.getAPP_BUILD_TIME(), "4.2.3", newVersion, versionChecker.getLocalKotlinVersion(), versionChecker.getLocalJreVersion()));
                Logger.info$default(Logger.INSTANCE, null, 1, null);
                return;
            }
            new KscriptHandler(executor, config, parsedOptions).handle(userArgs);
        }
        catch (Exception e) {
            Logger.INSTANCE.errorMsg(e);
            Logger.info$default(Logger.INSTANCE, null, 1, null);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }
}

