/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.resolver;

import io.github.kscripting.kscript.creator.JarArtifact;
import io.github.kscripting.kscript.model.CompilerOpt;
import io.github.kscripting.kscript.model.KotlinOpt;
import io.github.kscripting.kscript.model.OsConfig;
import io.github.kscripting.kscript.resolver.CommandResolver;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.OsPathExtKt;
import io.github.kscripting.shell.model.OsType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00f8\u0001\u0000J\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\rJ;\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f\u00f8\u0001\u0000J\u0006\u0010\u001d\u001a\u00020\u0006J3\u0010\u001e\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f\u00f8\u0001\u0000J\u0016\u0010\u001f\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0019\u0010 \u001a\u00020\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0002\u00f8\u0001\u0000J\u0016\u0010!\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0019\u0010%\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000fH\u0002\u00f8\u0001\u0000J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\rH\u0002J\u0016\u0010(\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lio/github/kscripting/kscript/resolver/CommandResolver;", "", "osConfig", "Lio/github/kscripting/kscript/model/OsConfig;", "(Lio/github/kscripting/kscript/model/OsConfig;)V", "classPathSeparator", "", "filePathQuotationMark", "", "getOsConfig", "()Lio/github/kscripting/kscript/model/OsConfig;", "compileKotlin", "jar", "Lio/github/kscripting/shell/model/OsPath;", "dependencies", "", "filePaths", "compilerOpts", "Lio/github/kscripting/kscript/model/CompilerOpt;", "createPackage", "executeIdea", "projectPath", "executeKotlin", "jarArtifact", "Lio/github/kscripting/kscript/creator/JarArtifact;", "userArgs", "", "kotlinOpts", "Lio/github/kscripting/kscript/model/KotlinOpt;", "getKotlinJreVersion", "interactiveKotlinRepl", "resolveClasspath", "resolveCompilerOpts", "resolveFiles", "resolveJarFile", "resolveKotlinBinary", "binary", "resolveKotlinOpts", "resolveQuotedPath", "osPath", "resolveUserArgs", "kscript"})
public final class CommandResolver {
    @NotNull
    private final OsConfig osConfig;
    @NotNull
    private final String classPathSeparator;
    private final char filePathQuotationMark;

    public CommandResolver(@NotNull OsConfig osConfig) {
        Intrinsics.checkNotNullParameter((Object)osConfig, (String)"osConfig");
        this.osConfig = osConfig;
        this.classPathSeparator = this.osConfig.getOsType().isWindowsLike() || this.osConfig.getOsType().isPosixHostedOnWindows() ? ";" : ":";
        this.filePathQuotationMark = (char)(WhenMappings.$EnumSwitchMapping$0[this.osConfig.getOsType().ordinal()] == 1 ? 34 : 39);
    }

    @NotNull
    public final OsConfig getOsConfig() {
        return this.osConfig;
    }

    @NotNull
    public final String getKotlinJreVersion() {
        String kotlin = this.resolveKotlinBinary("kotlin");
        return kotlin + " -version";
    }

    @NotNull
    public final String compileKotlin(@NotNull OsPath jar2, @NotNull Set<OsPath> dependencies2, @NotNull Set<OsPath> filePaths, @NotNull Set<CompilerOpt> compilerOpts) {
        Intrinsics.checkNotNullParameter((Object)jar2, (String)"jar");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
        Intrinsics.checkNotNullParameter(compilerOpts, (String)"compilerOpts");
        String compilerOptsStr = this.resolveCompilerOpts(compilerOpts);
        String classpath2 = this.resolveClasspath(dependencies2);
        String jarFile = this.resolveJarFile(jar2);
        String files = this.resolveFiles(filePaths);
        String kotlinc = this.resolveKotlinBinary("kotlinc");
        return kotlinc + " " + compilerOptsStr + " " + classpath2 + " -d " + jarFile + " " + files;
    }

    @NotNull
    public final String executeKotlin(@NotNull JarArtifact jarArtifact, @NotNull Set<OsPath> dependencies2, @NotNull List<String> userArgs, @NotNull Set<KotlinOpt> kotlinOpts) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)jarArtifact, (String)"jarArtifact");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(userArgs, (String)"userArgs");
        Intrinsics.checkNotNullParameter(kotlinOpts, (String)"kotlinOpts");
        String kotlinOptsStr = this.resolveKotlinOpts(kotlinOpts);
        String userArgsStr = this.resolveUserArgs(userArgs);
        String[] stringArray = new String[]{"lib/kotlin-script-runtime.jar"};
        OsPath scriptRuntime = this.osConfig.getKotlinHomeDir().resolve(stringArray);
        Set $this$executeKotlin_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$executeKotlin_u24lambda_u240.addAll((Collection)dependencies2);
        $this$executeKotlin_u24lambda_u240.add(jarArtifact.getPath());
        $this$executeKotlin_u24lambda_u240.add(scriptRuntime);
        Set dependenciesSet = SetsKt.build((Set)set);
        String classpath2 = this.resolveClasspath(dependenciesSet);
        String kotlin = this.resolveKotlinBinary("kotlin");
        return kotlin + " " + kotlinOptsStr + " " + classpath2 + " " + jarArtifact.getExecClassName() + " " + userArgsStr;
    }

    @NotNull
    public final String interactiveKotlinRepl(@NotNull Set<OsPath> dependencies2, @NotNull Set<CompilerOpt> compilerOpts, @NotNull Set<KotlinOpt> kotlinOpts) {
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(compilerOpts, (String)"compilerOpts");
        Intrinsics.checkNotNullParameter(kotlinOpts, (String)"kotlinOpts");
        String compilerOptsStr = this.resolveCompilerOpts(compilerOpts);
        String kotlinOptsStr = this.resolveKotlinOpts(kotlinOpts);
        String classpath2 = this.resolveClasspath(dependencies2);
        String kotlinc = this.resolveKotlinBinary("kotlinc");
        return kotlinc + " " + compilerOptsStr + " " + kotlinOptsStr + " " + classpath2;
    }

    @NotNull
    public final String executeIdea(@NotNull OsPath projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.osConfig.getIntellijCommand() + " \"" + projectPath + "\" &";
    }

    @NotNull
    public final String createPackage() {
        return this.osConfig.getGradleCommand() + " makeScript";
    }

    private final String resolveKotlinOpts(Set<KotlinOpt> kotlinOpts) {
        return CollectionsKt.joinToString$default((Iterable)kotlinOpts, (CharSequence)" ", null, null, (int)0, null, (Function1)resolveKotlinOpts.1.INSTANCE, (int)30, null);
    }

    private final String resolveCompilerOpts(Set<CompilerOpt> compilerOpts) {
        return CollectionsKt.joinToString$default((Iterable)compilerOpts, (CharSequence)" ", null, null, (int)0, null, (Function1)resolveCompilerOpts.1.INSTANCE, (int)30, null);
    }

    private final String resolveJarFile(OsPath jar2) {
        return this.filePathQuotationMark + this.resolveQuotedPath(jar2) + this.filePathQuotationMark;
    }

    private final String resolveFiles(Set<OsPath> filePaths) {
        return CollectionsKt.joinToString$default((Iterable)filePaths, (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<OsPath, CharSequence>(this){
            final /* synthetic */ CommandResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull OsPath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CommandResolver.access$getFilePathQuotationMark$p(this.this$0) + CommandResolver.access$resolveQuotedPath(this.this$0, it) + CommandResolver.access$getFilePathQuotationMark$p(this.this$0);
            }
        }), (int)30, null);
    }

    private final String resolveUserArgs(List<String> userArgs) {
        return CollectionsKt.joinToString$default((Iterable)userArgs, (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ CommandResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CommandResolver.access$getFilePathQuotationMark$p(this.this$0) + StringsKt.replace$default((String)it, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + CommandResolver.access$getFilePathQuotationMark$p(this.this$0);
            }
        }), (int)30, null);
    }

    private final String resolveClasspath(Set<OsPath> dependencies2) {
        if (dependencies2.isEmpty()) {
            return "";
        }
        String classpath2 = this.filePathQuotationMark + CollectionsKt.joinToString$default((Iterable)dependencies2, (CharSequence)this.classPathSeparator, null, null, (int)0, null, (Function1)((Function1)new Function1<OsPath, CharSequence>(this){
            final /* synthetic */ CommandResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull OsPath it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CommandResolver.access$resolveQuotedPath(this.this$0, it);
            }
        }), (int)30, null) + this.filePathQuotationMark;
        return "-classpath " + classpath2;
    }

    private final String resolveQuotedPath(OsPath osPath) {
        return OsPathExtKt.toNativeOsPath((OsPath)osPath).stringPath();
    }

    private final String resolveKotlinBinary(String binary) {
        String[] stringArray = new String[]{"bin", this.osConfig.getOsType().isWindowsLike() ? binary + ".bat" : binary};
        String pathToKotlinc = this.osConfig.getKotlinHomeDir().resolve(stringArray).convert(this.osConfig.getOsType()).stringPath();
        String quotes = this.osConfig.getOsType() == OsType.WINDOWS ? Character.valueOf(this.filePathQuotationMark) : "";
        return quotes + pathToKotlinc + quotes;
    }

    public static final /* synthetic */ char access$getFilePathQuotationMark$p(CommandResolver $this) {
        return $this.filePathQuotationMark;
    }

    public static final /* synthetic */ String access$resolveQuotedPath(CommandResolver $this, OsPath osPath) {
        return $this.resolveQuotedPath(osPath);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OsType.values().length];
            try {
                nArray[OsType.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

