/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.resolver;

import io.github.kscripting.kscript.cache.Cache;
import io.github.kscripting.kscript.model.Content;
import io.github.kscripting.kscript.model.OsConfig;
import io.github.kscripting.kscript.resolver.InputOutputResolver;
import io.github.kscripting.kscript.util.ScriptUtils;
import io.github.kscripting.kscript.util.UriUtils;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.OsPathExtKt;
import io.github.kscripting.shell.model.OsType;
import io.github.kscripting.shell.model.ScriptType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/kscripting/kscript/resolver/InputOutputResolver;", "", "osConfig", "Lio/github/kscripting/kscript/model/OsConfig;", "cache", "Lio/github/kscripting/kscript/cache/Cache;", "(Lio/github/kscripting/kscript/model/OsConfig;Lio/github/kscripting/kscript/cache/Cache;)V", "isReadable", "", "osPath", "Lio/github/kscripting/shell/model/OsPath;", "resolveContent", "Lio/github/kscripting/kscript/model/Content;", "uri", "Ljava/net/URI;", "resolveContentUsingInputStream", "resolveCurrentDir", "resolveUri", "resolveUriRelativeToHomeDir", "path", "", "resolveUriRelativeToRoot", "tryToCreateShellFilePath", "kscript"})
public final class InputOutputResolver {
    @NotNull
    private final OsConfig osConfig;
    @NotNull
    private final Cache cache;

    public InputOutputResolver(@NotNull OsConfig osConfig, @NotNull Cache cache) {
        Intrinsics.checkNotNullParameter((Object)osConfig, (String)"osConfig");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.osConfig = osConfig;
        this.cache = cache;
    }

    @NotNull
    public final Content resolveContent(@NotNull OsPath osPath) {
        Intrinsics.checkNotNullParameter((Object)osPath, (String)"osPath");
        URI uri = this.resolveUri(osPath);
        String content = PathsKt.readText$default((Path)OsPathExtKt.toNativePath((OsPath)osPath), null, (int)1, null);
        Pair<String, ScriptType> pair = ScriptUtils.INSTANCE.extractScriptFileDetails(uri);
        String fileName = (String)pair.component1();
        ScriptType scriptType = (ScriptType)pair.component2();
        URI contextUri = uri.resolve(".");
        ScriptType scriptType2 = scriptType;
        if (scriptType2 == null) {
            scriptType2 = ScriptUtils.INSTANCE.resolveScriptType(content);
        }
        Intrinsics.checkNotNullExpressionValue((Object)contextUri, (String)"contextUri");
        return new Content(content, scriptType2, fileName, uri, contextUri, osPath);
    }

    @NotNull
    public final Content resolveContent(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (!UriUtils.INSTANCE.isUrl(uri)) {
            return this.resolveContent(OsPath.Companion.createOrThrow(OsType.Companion.getNative(), ((Object)Paths.get(uri)).toString(), new String[0]));
        }
        return this.cache.getOrCreateUriItem(uri, (Function2<? super URI, ? super OsPath, Content>)((Function2)resolveContent.1.INSTANCE));
    }

    @NotNull
    public final Content resolveContentUsingInputStream(@NotNull OsPath osPath) {
        Intrinsics.checkNotNullParameter((Object)osPath, (String)"osPath");
        URI resolvedUri = this.resolveUri(osPath);
        URI contextUri = resolvedUri.resolve(".");
        InputStream inputStream = new FileInputStream(OsPathExtKt.toNativeOsPath((OsPath)osPath).stringPath());
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        String content = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        ScriptType scriptType = ScriptUtils.INSTANCE.resolveScriptType(content);
        String string = (String)CollectionsKt.last((List)osPath.getPathParts());
        Intrinsics.checkNotNullExpressionValue((Object)contextUri, (String)"contextUri");
        return new Content(content, scriptType, string, resolvedUri, contextUri, osPath);
    }

    @NotNull
    public final URI resolveUriRelativeToRoot(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        OsType osType = OsType.Companion.getNative();
        Path path3 = new File(".").toPath().toAbsolutePath().getRoot();
        Intrinsics.checkNotNull((Object)path3);
        Path path4 = path3.resolve(path2);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"File(\".\").toPath().toAbs\u2026th().root!!.resolve(path)");
        return this.resolveUri(OsPath.Companion.createOrThrow(osType, ((Object)path4).toString(), new String[0]));
    }

    @NotNull
    public final URI resolveUriRelativeToHomeDir(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{path2};
        URI uRI = new File(this.osConfig.getUserHomeDir().resolve(stringArray).stringPath()).toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"File(osConfig.userHomeDi\u2026th).stringPath()).toURI()");
        return uRI;
    }

    @NotNull
    public final URI resolveCurrentDir() {
        URI uRI = new File(".").toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"File(\".\").toURI()");
        return uRI;
    }

    @Nullable
    public final OsPath tryToCreateShellFilePath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        OsType type = WhenMappings.$EnumSwitchMapping$0[this.osConfig.getOsType().ordinal()] == 1 ? OsType.WINDOWS : this.osConfig.getOsType();
        return OsPath.Companion.create(type, path2, new String[0]);
    }

    public final boolean isReadable(@NotNull OsPath osPath) {
        Intrinsics.checkNotNullParameter((Object)osPath, (String)"osPath");
        return new File(OsPathExtKt.toNativeOsPath((OsPath)osPath).stringPath()).canRead();
    }

    private final URI resolveUri(OsPath osPath) {
        URI uRI = new File(OsPathExtKt.toNativeOsPath((OsPath)osPath).stringPath()).toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"File(osPath.toNativeOsPath().stringPath()).toURI()");
        return uRI;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OsType.values().length];
            try {
                nArray[OsType.MSYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

