/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.util;

import io.github.kscripting.kscript.creator.JarArtifact;
import io.github.kscripting.kscript.model.CompilerOpt;
import io.github.kscripting.kscript.model.KotlinOpt;
import io.github.kscripting.kscript.resolver.CommandResolver;
import io.github.kscripting.kscript.util.Logger;
import io.github.kscripting.kscript.util.ShellUtils;
import io.github.kscripting.shell.ShellExecutor;
import io.github.kscripting.shell.model.GobbledProcessResult;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.OsType;
import io.github.kscripting.shell.model.ProcessResult;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J;\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00f8\u0001\u0000J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ;\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n\u00f8\u0001\u0000J\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ;\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n\u00f8\u0001\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lio/github/kscripting/kscript/util/Executor;", "", "commandResolver", "Lio/github/kscripting/kscript/resolver/CommandResolver;", "(Lio/github/kscripting/kscript/resolver/CommandResolver;)V", "compileKotlin", "", "jar", "Lio/github/kscripting/shell/model/OsPath;", "dependencies", "", "filePaths", "compilerOpts", "Lio/github/kscripting/kscript/model/CompilerOpt;", "createPackage", "projectPath", "executeKotlin", "jarArtifact", "Lio/github/kscripting/kscript/creator/JarArtifact;", "userArgs", "", "", "kotlinOpts", "Lio/github/kscripting/kscript/model/KotlinOpt;", "retrieveLocalKotlinAndJreVersion", "runGradleInIdeaProject", "runInteractiveRepl", "kscript"})
public final class Executor {
    @NotNull
    private final CommandResolver commandResolver;

    public Executor(@NotNull CommandResolver commandResolver) {
        Intrinsics.checkNotNullParameter((Object)commandResolver, (String)"commandResolver");
        this.commandResolver = commandResolver;
    }

    @NotNull
    public final String retrieveLocalKotlinAndJreVersion() {
        String command = this.commandResolver.getKotlinJreVersion();
        return ShellExecutor.evalAndGobble$default((ShellExecutor)ShellExecutor.INSTANCE, (OsType)this.commandResolver.getOsConfig().getOsType(), (String)command, null, (Function1)((Function1)new Function1<Map<String, String>, Unit>((Object)ShellUtils.INSTANCE){

            public final void invoke(@NotNull Map<String, String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((ShellUtils)this.receiver).environmentAdjuster(p0);
            }
        }), (int)0, (boolean)false, null, null, (int)240, null).getStdout();
    }

    public final void compileKotlin(@NotNull OsPath jar2, @NotNull Set<OsPath> dependencies2, @NotNull Set<OsPath> filePaths, @NotNull Set<CompilerOpt> compilerOpts) {
        Intrinsics.checkNotNullParameter((Object)jar2, (String)"jar");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
        Intrinsics.checkNotNullParameter(compilerOpts, (String)"compilerOpts");
        String command = this.commandResolver.compileKotlin(jar2, dependencies2, filePaths, compilerOpts);
        Logger.INSTANCE.devMsg("JAR compile command: " + command);
        GobbledProcessResult processResult2 = ShellExecutor.evalAndGobble$default((ShellExecutor)ShellExecutor.INSTANCE, (OsType)this.commandResolver.getOsConfig().getOsType(), (String)command, null, (Function1)((Function1)new Function1<Map<String, String>, Unit>((Object)ShellUtils.INSTANCE){

            public final void invoke(@NotNull Map<String, String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((ShellUtils)this.receiver).environmentAdjuster(p0);
            }
        }), (int)30, (boolean)false, null, null, (int)228, null);
        Logger.INSTANCE.devMsg("Script compilation result:\n" + processResult2);
        if (processResult2.getExitCode() != 0) {
            throw new IllegalStateException("Compilation of scriplet failed:\n" + processResult2);
        }
    }

    public final void executeKotlin(@NotNull JarArtifact jarArtifact, @NotNull Set<OsPath> dependencies2, @NotNull List<String> userArgs, @NotNull Set<KotlinOpt> kotlinOpts) {
        Intrinsics.checkNotNullParameter((Object)jarArtifact, (String)"jarArtifact");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(userArgs, (String)"userArgs");
        Intrinsics.checkNotNullParameter(kotlinOpts, (String)"kotlinOpts");
        String command = this.commandResolver.executeKotlin(jarArtifact, dependencies2, userArgs, kotlinOpts);
        Logger.INSTANCE.devMsg("Kotlin execute command: " + command);
        ProcessResult processResult2 = ShellExecutor.eval$default((ShellExecutor)ShellExecutor.INSTANCE, (OsType)this.commandResolver.getOsConfig().getOsType(), (String)command, null, (Function1)((Function1)new Function1<Map<String, String>, Unit>((Object)ShellUtils.INSTANCE){

            public final void invoke(@NotNull Map<String, String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((ShellUtils)this.receiver).environmentAdjuster(p0);
            }
        }), (int)Integer.MAX_VALUE, (boolean)true, null, null, (int)196, null);
        Logger.INSTANCE.devMsg("Script execution result:\n" + processResult2);
        if (processResult2.getExitCode() != 0) {
            throw new IllegalStateException("Execution of scriplet failed:\n" + processResult2);
        }
    }

    public final void runInteractiveRepl(@NotNull JarArtifact jarArtifact, @NotNull Set<OsPath> dependencies2, @NotNull Set<CompilerOpt> compilerOpts, @NotNull Set<KotlinOpt> kotlinOpts) {
        Intrinsics.checkNotNullParameter((Object)jarArtifact, (String)"jarArtifact");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        Intrinsics.checkNotNullParameter(compilerOpts, (String)"compilerOpts");
        Intrinsics.checkNotNullParameter(kotlinOpts, (String)"kotlinOpts");
        Logger.INSTANCE.infoMsg("Creating REPL");
        String command = this.commandResolver.interactiveKotlinRepl(SetsKt.plus(dependencies2, (Iterable)SetsKt.setOf((Object)jarArtifact.getPath())), compilerOpts, kotlinOpts);
        Logger.INSTANCE.devMsg("REPL Kotlin command: " + command);
        ProcessResult processResult2 = ShellExecutor.eval$default((ShellExecutor)ShellExecutor.INSTANCE, (OsType)this.commandResolver.getOsConfig().getOsType(), (String)command, null, (Function1)((Function1)new Function1<Map<String, String>, Unit>((Object)ShellUtils.INSTANCE){

            public final void invoke(@NotNull Map<String, String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((ShellUtils)this.receiver).environmentAdjuster(p0);
            }
        }), (int)Integer.MAX_VALUE, (boolean)true, null, null, (int)196, null);
        Logger.INSTANCE.devMsg("Repl execution result:\n" + processResult2);
    }

    public final void runGradleInIdeaProject(@NotNull OsPath projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (ShellUtils.isInPath$default(ShellUtils.INSTANCE, this.commandResolver.getOsConfig().getOsType(), this.commandResolver.getOsConfig().getGradleCommand(), null, 4, null)) {
            ShellExecutor.evalAndGobble$default((ShellExecutor)ShellExecutor.INSTANCE, (OsType)this.commandResolver.getOsConfig().getOsType(), (String)"gradle wrapper", (OsPath)projectPath, null, (int)0, (boolean)false, null, null, (int)248, null);
        } else {
            Logger.INSTANCE.warnMsg("Could not find '" + this.commandResolver.getOsConfig().getGradleCommand() + "' in your PATH. You must set the command used to launch your intellij as 'KSCRIPT_COMMAND_GRADLE' env property");
        }
        if (ShellUtils.isInPath$default(ShellUtils.INSTANCE, this.commandResolver.getOsConfig().getOsType(), this.commandResolver.getOsConfig().getIntellijCommand(), null, 4, null)) {
            String command = this.commandResolver.executeIdea(projectPath);
            Logger.INSTANCE.devMsg("Idea execute command: " + command);
            GobbledProcessResult processResult2 = ShellExecutor.evalAndGobble$default((ShellExecutor)ShellExecutor.INSTANCE, (OsType)this.commandResolver.getOsConfig().getOsType(), (String)command, null, null, (int)0, (boolean)false, null, null, (int)252, null);
            Logger.INSTANCE.devMsg("Script execution result:\n" + processResult2);
            if (processResult2.getExitCode() != 0) {
                throw new IllegalStateException("Execution of idea command failed:\n" + processResult2);
            }
        } else {
            Logger.INSTANCE.warnMsg("Could not find '" + this.commandResolver.getOsConfig().getIntellijCommand() + "' in your PATH. You should set the command used to launch your intellij as 'KSCRIPT_COMMAND_IDEA' env property");
        }
    }

    public final void createPackage(@NotNull OsPath projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (!ShellUtils.isInPath$default(ShellUtils.INSTANCE, this.commandResolver.getOsConfig().getOsType(), this.commandResolver.getOsConfig().getGradleCommand(), null, 4, null)) {
            throw new IllegalStateException("Gradle is required to package scripts.");
        }
        String command = this.commandResolver.createPackage();
        Logger.INSTANCE.devMsg("Create package command: " + command);
        GobbledProcessResult result = ShellExecutor.evalAndGobble$default((ShellExecutor)ShellExecutor.INSTANCE, (OsType)this.commandResolver.getOsConfig().getOsType(), (String)command, (OsPath)projectPath, null, (int)0, (boolean)false, null, null, (int)248, null);
        if (result.getExitCode() != 0) {
            throw new IllegalStateException("Packaging for path: '" + projectPath + "' failed:" + result);
        }
    }
}

