/*
 * Decompiled with CFR 0.152.
 */
package io.github.lambig.funcifextension.proposition;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Proposition
extends Supplier<Boolean> {
    public boolean test();

    public static Proposition and(Proposition ... propositions) {
        if (propositions.length == 0) {
            throw new IllegalArgumentException("At least 1 proposition needed");
        }
        return () -> Arrays.stream(propositions).allMatch(Proposition::test);
    }

    public static Proposition or(Proposition ... propositions) {
        if (propositions.length == 0) {
            throw new IllegalArgumentException("At least 1 proposition needed");
        }
        return () -> Arrays.stream(propositions).anyMatch(Proposition::test);
    }

    public static <E> PropositionBuilderFromPredicate<E> predicate(Predicate<E> predicate) {
        return subject -> () -> predicate.test(subject);
    }

    public static <E> PropositionBuilderFromSubject<E> subject(E subject) {
        return predicate -> () -> predicate.test(subject);
    }

    @Override
    default public Boolean get() {
        return this.test();
    }

    default public <E> Predicate<E> toPredicate() {
        return anything -> this.test();
    }

    default public Proposition and(Proposition next) {
        return Proposition.and(this, next);
    }

    default public Proposition or(Proposition next) {
        return Proposition.or(this, next);
    }

    public static interface PropositionBuilderFromSubject<S>
    extends Function<Predicate<S>, Proposition> {
        public Proposition satisfies(Predicate<S> var1);

        @Override
        default public Proposition apply(Predicate<S> s) {
            return this.satisfies(s);
        }
    }

    public static interface PropositionBuilderFromPredicate<S>
    extends Function<S, Proposition> {
        public Proposition satisfiedBy(S var1);

        @Override
        default public Proposition apply(S s) {
            return this.satisfiedBy(s);
        }
    }
}

