/*
 * Decompiled with CFR 0.152.
 */
package io.github.lambig.patterns;

import io.github.lambig.tuplite._2.Tuple2;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class Patterns<K, V>
implements Function<K, V> {
    private final List<Tuple2<Predicate<K>, Function<K, V>>> mappings;

    public Patterns(List<Tuple2<Predicate<K>, Function<K, V>>> patterns) {
        this.mappings = patterns;
    }

    @SafeVarargs
    public static <S, O> Patterns<S, O> patterns(Tuple2<Predicate<S>, Function<S, O>> ... patterns) {
        return Patterns.patterns(Stream.of(patterns).collect(Collectors.toList()));
    }

    public static <S, O> Patterns<S, O> patterns(List<Tuple2<Predicate<S>, Function<S, O>>> patterns) {
        return new Patterns(patterns);
    }

    @NonNull
    public V get(K key) {
        Tuple2 pattern = this.mappings.stream().filter(entry -> ((Predicate)entry._1()).test(key)).findFirst().orElseThrow(() -> new NoSuchPatternException("for key: " + key + ". To allow this pattern to return nullable value, consider using Patterns#getOptionally."));
        return (V)Optional.ofNullable(((Function)pattern._2()).apply(key)).orElseThrow(() -> new NullPointerException("Pattern computed null result. To allow this pattern to return nullable value, consider using Patterns#getOptionally."));
    }

    @NonNull
    public Optional<V> getOptionally(K key) {
        return this.mappings.stream().filter(entry -> ((Predicate)entry._1()).test(key)).findFirst().map(Tuple2._2mapWith((ignored, then) -> then.apply(key)));
    }

    public Function<K, Optional<V>> optional() {
        return this::getOptionally;
    }

    @Override
    public V apply(K k) {
        return this.get(k);
    }

    public static <S, O> Function<S, O> then(O value) {
        return anything -> value;
    }

    public static <S, O> Function<S, O> thenSupply(Supplier<? extends O> supplier) {
        return anything -> supplier.get();
    }

    public static <S, O> Function<S, O> thenApply(Function<? super S, ? extends O> function) {
        return function::apply;
    }

    public static <S, O> Tuple2<Predicate<S>, Function<S, O>> when(Predicate<? super S> when, Function<? super S, ? extends O> thenApply) {
        return Tuple2.tuple(when::test, thenApply::apply);
    }

    public static <S> Predicate<S> equalsTo(S target) {
        return s -> Objects.equals(s, target);
    }

    public static <S, O> Tuple2<Predicate<S>, Function<S, O>> orElse(Function<? super S, ? extends O> thenApply) {
        return Tuple2.tuple(anything -> true, thenApply::apply);
    }

    public static <S, O> Tuple2<Predicate<S>, Function<S, O>> orElseThrow(Function<? super S, RuntimeException> thenApply) {
        return Tuple2.tuple(anything -> true, input -> {
            throw (RuntimeException)thenApply.apply((Object)input);
        });
    }

    public static <S, T extends S, O> Tuple2<Predicate<S>, Function<S, O>> whenMatch(Class<T> clazz, Function<? super T, ? extends O> thenApply) {
        return Tuple2.tuple(clazz::isInstance, instance -> thenApply.apply((Object)clazz.cast(instance)));
    }

    public static <S, T extends S, O> Tuple2<Predicate<S>, Function<S, O>> whenMatch(Class<T> clazz, Predicate<? super T> when, Function<? super T, ? extends O> thenApply) {
        return Tuple2.tuple(key -> clazz.isInstance(key) && when.test((Object)clazz.cast(key)), instance -> thenApply.apply((Object)clazz.cast(instance)));
    }

    public static class NoSuchPatternException
    extends RuntimeException {
        public NoSuchPatternException() {
            this(null, null);
        }

        public NoSuchPatternException(String message) {
            this(message, null);
        }

        public NoSuchPatternException(Throwable cause) {
            this(cause != null ? cause.getMessage() : null, cause);
        }

        public NoSuchPatternException(String message, Throwable cause) {
            super(message);
            if (cause != null) {
                super.initCause(cause);
            }
        }
    }
}

