/*
 * Decompiled with CFR 0.152.
 */
package io.github.lambig.union;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.NonNull;

public interface Union<L, R> {
    public static <L, R, O> Function<Union<L, R>, O> toJoinedWith(@NonNull Function<? super L, ? extends O> leftResolver, @NonNull Function<? super R, ? extends O> rightResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        return union -> union.asJoined(leftResolver, rightResolver);
    }

    public static <L, R, O> Function<Union<L, R>, O> toJoinedWith(@NonNull BiFunction<? super L, ? super R, ? extends O> biResolver) {
        Objects.requireNonNull(biResolver, "biResolver is marked non-null but is null");
        return union -> union.asJoined(biResolver);
    }

    public static <L, R, O> Function<Union<L, R>, Optional<O>> toJoinedOptionalWith(@NonNull Function<? super L, ? extends O> leftResolver, @NonNull Function<? super R, ? extends O> rightResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        return union -> union.asJoinedOptional(leftResolver, rightResolver);
    }

    public static <L, R, O> Function<Union<L, R>, Optional<O>> toJoinedOptionalWith(@NonNull BiFunction<? super L, ? super R, ? extends O> biResolver) {
        Objects.requireNonNull(biResolver, "biResolver is marked non-null but is null");
        return union -> union.asJoinedOptional(biResolver);
    }

    public static <L, R> Consumer<Union<L, R>> acceptWith(@NonNull Consumer<? super L> leftResolver, @NonNull Consumer<? super R> rightResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        return union -> union.accept(leftResolver, rightResolver);
    }

    public static <L, R> Consumer<Union<L, R>> acceptWith(@NonNull BiConsumer<? super L, ? super R> biResolver) {
        Objects.requireNonNull(biResolver, "biResolver is marked non-null but is null");
        return union -> union.accept(biResolver);
    }

    public static <L, R> Consumer<Union<L, R>> acceptLeftWith(@NonNull Consumer<? super L> leftResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        return union -> union.acceptLeft(leftResolver);
    }

    public static <L, R> Consumer<Union<L, R>> acceptRightWith(@NonNull Consumer<? super R> rightResolver) {
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        return union -> union.acceptRight(rightResolver);
    }

    public static <L, R> UnaryOperator<Union<L, R>> peekWith(@NonNull Consumer<? super L> leftResolver, @NonNull Consumer<? super R> rightResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        return union -> union.peek(leftResolver, rightResolver);
    }

    public static <L, R> UnaryOperator<Union<L, R>> peekWith(@NonNull BiConsumer<? super L, ? super R> biResolver) {
        Objects.requireNonNull(biResolver, "biResolver is marked non-null but is null");
        return union -> union.peek(biResolver);
    }

    public static <L, R> UnaryOperator<Union<L, R>> peekLeftWith(@NonNull Consumer<? super L> leftResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        return union -> union.peekLeft(leftResolver);
    }

    public static <L, R> UnaryOperator<Union<L, R>> peekRightWith(@NonNull Consumer<? super R> rightResolver) {
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        return union -> union.peekRight(rightResolver);
    }

    public L left();

    public R right();

    default public Optional<L> leftOptional() {
        return this.hasLeft() ? Optional.of(this.left()) : Optional.empty();
    }

    default public Optional<R> rightOptional() {
        return this.hasRight() ? Optional.of(this.right()) : Optional.empty();
    }

    public boolean hasLeft();

    public boolean hasRight();

    public <O> O asJoined(@NonNull Function<? super L, ? extends O> var1, @NonNull Function<? super R, ? extends O> var2);

    public <O> O asJoined(@NonNull BiFunction<? super L, ? super R, ? extends O> var1);

    default public <O> Optional<O> asJoinedOptional(@NonNull Function<? super L, ? extends O> leftResolver, @NonNull Function<? super R, ? extends O> rightResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        return Optional.ofNullable(this.asJoined(leftResolver, rightResolver));
    }

    default public <O> Optional<O> asJoinedOptional(@NonNull BiFunction<? super L, ? super R, ? extends O> biResolver) {
        Objects.requireNonNull(biResolver, "biResolver is marked non-null but is null");
        return Optional.ofNullable(this.asJoined(biResolver));
    }

    public void accept(@NonNull Consumer<? super L> var1, @NonNull Consumer<? super R> var2);

    public void accept(@NonNull BiConsumer<? super L, ? super R> var1);

    public void acceptLeft(@NonNull Consumer<? super L> var1);

    public void acceptRight(@NonNull Consumer<? super R> var1);

    default public Union<L, R> peek(@NonNull Consumer<? super L> leftResolver, @NonNull Consumer<? super R> rightResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        this.accept(leftResolver, rightResolver);
        return this;
    }

    default public Union<L, R> peek(@NonNull BiConsumer<? super L, ? super R> biResolver) {
        Objects.requireNonNull(biResolver, "biResolver is marked non-null but is null");
        this.accept(biResolver);
        return this;
    }

    default public Union<L, R> peekLeft(@NonNull Consumer<? super L> leftResolver) {
        Objects.requireNonNull(leftResolver, "leftResolver is marked non-null but is null");
        this.acceptLeft(leftResolver);
        return this;
    }

    default public Union<L, R> peekRight(@NonNull Consumer<? super R> rightResolver) {
        Objects.requireNonNull(rightResolver, "rightResolver is marked non-null but is null");
        this.acceptRight(rightResolver);
        return this;
    }
}

