/*
 * Decompiled with CFR 0.152.
 */
package io.github.lambig.patterns;

import io.github.lambig.patterns.NoSuchPatternException;
import io.github.lambig.tuplite._2.Tuple2;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class ConsumingPatterns<K>
implements Consumer<K> {
    private final List<Tuple2<Predicate<K>, Consumer<K>>> mappings;

    private ConsumingPatterns(@NonNull List<Tuple2<Predicate<K>, Consumer<K>>> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        this.mappings = patterns;
    }

    @SafeVarargs
    public static <S> ConsumingPatterns<S> of(Tuple2<Predicate<S>, Consumer<S>> ... patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        return ConsumingPatterns.consumingPatterns(patterns);
    }

    public static <S> ConsumingPatterns<S> of(@NonNull List<Tuple2<Predicate<S>, Consumer<S>>> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        return ConsumingPatterns.consumingPatterns(patterns);
    }

    @SafeVarargs
    public static <S> ConsumingPatterns<S> consumingPatterns(Tuple2<Predicate<S>, Consumer<S>> ... patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        return ConsumingPatterns.consumingPatterns(Stream.of(patterns).collect(Collectors.toList()));
    }

    public static <S> ConsumingPatterns<S> consumingPatterns(@NonNull List<Tuple2<Predicate<S>, Consumer<S>>> patterns) {
        if (patterns == null) {
            throw new NullPointerException("patterns is marked non-null but is null");
        }
        return new ConsumingPatterns(patterns);
    }

    @NonNull
    public void handle(K key) {
        this.getConsumer(key).orElseThrow(() -> new NoSuchPatternException("for key: " + key + ". To allow this pattern to accept value that match no defined pattern, consider setting default consumer.")).accept(key);
    }

    @NonNull
    private Optional<Consumer<K>> getConsumer(K key) {
        return this.mappings.stream().filter(entry -> ((Predicate)entry._1()).test(key)).map(Tuple2::_2).findFirst();
    }

    public Consumer<K> orElseDo(@NonNull Consumer<K> defaultConsumer) {
        if (defaultConsumer == null) {
            throw new NullPointerException("defaultConsumer is marked non-null but is null");
        }
        return k -> this.getConsumer(k).orElse(defaultConsumer).accept(k);
    }

    public Consumer<K> orElseThrow(@NonNull Supplier<RuntimeException> exceptionSupplier) {
        if (exceptionSupplier == null) {
            throw new NullPointerException("exceptionSupplier is marked non-null but is null");
        }
        return k -> this.getConsumer(k).orElseThrow(exceptionSupplier).accept(k);
    }

    @Override
    public void accept(K k) {
        this.handle(k);
    }

    public static <S> Consumer<S> thenAcceptWith(@NonNull Consumer<? super S> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return consumer::accept;
    }

    public static <S> Tuple2<Predicate<S>, Consumer<S>> when(@NonNull Predicate<? super S> when, @NonNull Consumer<? super S> consumer) {
        if (when == null) {
            throw new NullPointerException("when is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return Tuple2.tuple(when::test, consumer::accept);
    }

    public static <S> Predicate<S> equalsTo(@NonNull S target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return s -> Objects.equals(s, target);
    }

    public static <S> Tuple2<Predicate<S>, Consumer<S>> orElse(@NonNull Consumer<? super S> thenAcceptWith) {
        if (thenAcceptWith == null) {
            throw new NullPointerException("thenAcceptWith is marked non-null but is null");
        }
        return Tuple2.tuple(anything -> true, thenAcceptWith::accept);
    }

    public static <S> Tuple2<Predicate<S>, Consumer<S>> orElseThrow(@NonNull @NonNull Function<? super S, @NonNull RuntimeException> thenAcceptWith) {
        if (thenAcceptWith == null) {
            throw new NullPointerException("thenAcceptWith is marked non-null but is null");
        }
        return Tuple2.tuple(anything -> true, input -> {
            throw (RuntimeException)thenAcceptWith.apply((Object)input);
        });
    }

    public static <S, T extends S> Tuple2<Predicate<S>, Consumer<S>> whenMatch(@NonNull Class<T> clazz, @NonNull Consumer<? super T> thenAcceptWith) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (thenAcceptWith == null) {
            throw new NullPointerException("thenAcceptWith is marked non-null but is null");
        }
        return Tuple2.tuple(clazz::isInstance, instance -> thenAcceptWith.accept((Object)clazz.cast(instance)));
    }

    public static <S, T extends S> Tuple2<Predicate<S>, Consumer<S>> whenMatch(@NonNull Class<T> clazz, Predicate<? super T> when, @NonNull Consumer<? super T> thenAcceptWith) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (thenAcceptWith == null) {
            throw new NullPointerException("thenAcceptWith is marked non-null but is null");
        }
        return Tuple2.tuple(key -> clazz.isInstance(key) && when.test((Object)clazz.cast(key)), instance -> thenAcceptWith.accept((Object)clazz.cast(instance)));
    }
}

