/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.Parser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = Components.Companion.Serializer::class)
@JsonDeserialize(using = Components.Companion.Deserializer::class)
data class Components(
    val _schemas: Field<Map<String, ReferenceOrInstance<Schema>?>?> = Field.unset(),
    val _responses: Field<Map<String, ReferenceOrInstance<Response>?>?> = Field.unset(),
    val _parameters: Field<Map<String, ReferenceOrInstance<Parameter>?>?> = Field.unset(),
    val _examples: Field<Map<String, ReferenceOrInstance<Example>?>?> = Field.unset(),
    val _requestBodies: Field<Map<String, ReferenceOrInstance<RequestBody>?>?> = Field.unset(),
    val _headers: Field<Map<String, ReferenceOrInstance<Header>?>?> = Field.unset(),
    val _securitySchemes: Field<Map<String, ReferenceOrInstance<SecurityScheme>?>?> = Field.unset(),
    val _links: Field<Map<String, ReferenceOrInstance<Link>?>?> = Field.unset(),
    val _callbacks: Field<Map<String, ReferenceOrInstance<Callback>?>?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
) : Entity {

    ///////////////////////
    //
    // schemas
    //
    ///////////////////////

    // hint:3A7F9B2E
    val schemas: Map<String, ReferenceOrInstance<Schema>?>?
        get() = _schemas.orNull

    // hint:F0C48D71
    fun setSchemasField(schemas: Field<Map<String, ReferenceOrInstance<Schema>?>?>): Components {
        return copy(_schemas = schemas)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSchemasField(updater: (Field<Map<String, ReferenceOrInstance<Schema>?>?>) -> Field<Map<String, ReferenceOrInstance<Schema>?>?>): Components {
        return setSchemasField(updater(_schemas))
    }

    // hint:B1D730FC
    fun updateSchemas(updater: (Map<String, ReferenceOrInstance<Schema>?>?) -> Map<String, ReferenceOrInstance<Schema>?>?): Components {
        return updateSchemasField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSchemasField(schemasFieldToMerge: Field<Map<String, ReferenceOrInstance<Schema>?>?>): Components {
        return mergeSchemas(schemasFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSchemas(schemasToMerge: Map<String, ReferenceOrInstance<Schema>?>?): Components {
        return if (schemasToMerge == null) {
            this
        } else {
            val oldSchemas = _schemas.orNull
            if (oldSchemas == null) {
                setSchemasField(Field(schemasToMerge))
            } else {
                // hint:70A3D8B6
                setSchemas(de.lancom.openapi.parser.util.mergeMap(oldSchemas, schemasToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setSchemas(schemas: Map<String, ReferenceOrInstance<Schema>?>?): Components {
        return setSchemasField(Field(schemas))
    }

    // hint:D465F782
    fun unsetSchemas(): Components {
        return setSchemasField(Field.unset())
    }

    // hint:5C81D396
    fun addSchemas(schemas: Map<String, ReferenceOrInstance<Schema>?>?): Components {
        return mergeSchemas(schemas)
    }

    // hint:1A6B37F8
    fun addSchemas(vararg schemas: Pair<String, ReferenceOrInstance<Schema>?>): Components {
        return addSchemas(schemas.toMap())
    }

    // hint:9D0E4CA5
    fun addSchema(key: String, value: ReferenceOrInstance<Schema>?): Components {
        return addSchemas(key to value)
    }

    // hint:B8F25E73
    fun addSchema(pair: Pair<String, ReferenceOrInstance<Schema>?>): Components {
        return addSchemas(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addSchema(key: String, value: Schema): Components {
        return addSchemas(key to Instance(value))
    }

    ///////////////////////
    //
    // responses
    //
    ///////////////////////

    // hint:3A7F9B2E
    val responses: Map<String, ReferenceOrInstance<Response>?>?
        get() = _responses.orNull

    // hint:F0C48D71
    fun setResponsesField(responses: Field<Map<String, ReferenceOrInstance<Response>?>?>): Components {
        return copy(_responses = responses)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateResponsesField(updater: (Field<Map<String, ReferenceOrInstance<Response>?>?>) -> Field<Map<String, ReferenceOrInstance<Response>?>?>): Components {
        return setResponsesField(updater(_responses))
    }

    // hint:B1D730FC
    fun updateResponses(updater: (Map<String, ReferenceOrInstance<Response>?>?) -> Map<String, ReferenceOrInstance<Response>?>?): Components {
        return updateResponsesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeResponsesField(responsesFieldToMerge: Field<Map<String, ReferenceOrInstance<Response>?>?>): Components {
        return mergeResponses(responsesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeResponses(responsesToMerge: Map<String, ReferenceOrInstance<Response>?>?): Components {
        return if (responsesToMerge == null) {
            this
        } else {
            val oldResponses = _responses.orNull
            if (oldResponses == null) {
                setResponsesField(Field(responsesToMerge))
            } else {
                // hint:70A3D8B6
                setResponses(de.lancom.openapi.parser.util.mergeMap(oldResponses, responsesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setResponses(responses: Map<String, ReferenceOrInstance<Response>?>?): Components {
        return setResponsesField(Field(responses))
    }

    // hint:D465F782
    fun unsetResponses(): Components {
        return setResponsesField(Field.unset())
    }

    // hint:5C81D396
    fun addResponses(responses: Map<String, ReferenceOrInstance<Response>?>?): Components {
        return mergeResponses(responses)
    }

    // hint:1A6B37F8
    fun addResponses(vararg responses: Pair<String, ReferenceOrInstance<Response>?>): Components {
        return addResponses(responses.toMap())
    }

    // hint:9D0E4CA5
    fun addResponse(key: String, value: ReferenceOrInstance<Response>?): Components {
        return addResponses(key to value)
    }

    // hint:B8F25E73
    fun addResponse(pair: Pair<String, ReferenceOrInstance<Response>?>): Components {
        return addResponses(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addResponse(key: String, value: Response): Components {
        return addResponses(key to Instance(value))
    }

    ///////////////////////
    //
    // parameters
    //
    ///////////////////////

    // hint:3A7F9B2E
    val parameters: Map<String, ReferenceOrInstance<Parameter>?>?
        get() = _parameters.orNull

    // hint:F0C48D71
    fun setParametersField(parameters: Field<Map<String, ReferenceOrInstance<Parameter>?>?>): Components {
        return copy(_parameters = parameters)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateParametersField(updater: (Field<Map<String, ReferenceOrInstance<Parameter>?>?>) -> Field<Map<String, ReferenceOrInstance<Parameter>?>?>): Components {
        return setParametersField(updater(_parameters))
    }

    // hint:B1D730FC
    fun updateParameters(updater: (Map<String, ReferenceOrInstance<Parameter>?>?) -> Map<String, ReferenceOrInstance<Parameter>?>?): Components {
        return updateParametersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeParametersField(parametersFieldToMerge: Field<Map<String, ReferenceOrInstance<Parameter>?>?>): Components {
        return mergeParameters(parametersFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeParameters(parametersToMerge: Map<String, ReferenceOrInstance<Parameter>?>?): Components {
        return if (parametersToMerge == null) {
            this
        } else {
            val oldParameters = _parameters.orNull
            if (oldParameters == null) {
                setParametersField(Field(parametersToMerge))
            } else {
                // hint:70A3D8B6
                setParameters(de.lancom.openapi.parser.util.mergeMap(oldParameters, parametersToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setParameters(parameters: Map<String, ReferenceOrInstance<Parameter>?>?): Components {
        return setParametersField(Field(parameters))
    }

    // hint:D465F782
    fun unsetParameters(): Components {
        return setParametersField(Field.unset())
    }

    // hint:5C81D396
    fun addParameters(parameters: Map<String, ReferenceOrInstance<Parameter>?>?): Components {
        return mergeParameters(parameters)
    }

    // hint:1A6B37F8
    fun addParameters(vararg parameters: Pair<String, ReferenceOrInstance<Parameter>?>): Components {
        return addParameters(parameters.toMap())
    }

    // hint:9D0E4CA5
    fun addParameter(key: String, value: ReferenceOrInstance<Parameter>?): Components {
        return addParameters(key to value)
    }

    // hint:B8F25E73
    fun addParameter(pair: Pair<String, ReferenceOrInstance<Parameter>?>): Components {
        return addParameters(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addParameter(key: String, value: Parameter): Components {
        return addParameters(key to Instance(value))
    }

    ///////////////////////
    //
    // examples
    //
    ///////////////////////

    // hint:3A7F9B2E
    val examples: Map<String, ReferenceOrInstance<Example>?>?
        get() = _examples.orNull

    // hint:F0C48D71
    fun setExamplesField(examples: Field<Map<String, ReferenceOrInstance<Example>?>?>): Components {
        return copy(_examples = examples)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExamplesField(updater: (Field<Map<String, ReferenceOrInstance<Example>?>?>) -> Field<Map<String, ReferenceOrInstance<Example>?>?>): Components {
        return setExamplesField(updater(_examples))
    }

    // hint:B1D730FC
    fun updateExamples(updater: (Map<String, ReferenceOrInstance<Example>?>?) -> Map<String, ReferenceOrInstance<Example>?>?): Components {
        return updateExamplesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExamplesField(examplesFieldToMerge: Field<Map<String, ReferenceOrInstance<Example>?>?>): Components {
        return mergeExamples(examplesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExamples(examplesToMerge: Map<String, ReferenceOrInstance<Example>?>?): Components {
        return if (examplesToMerge == null) {
            this
        } else {
            val oldExamples = _examples.orNull
            if (oldExamples == null) {
                setExamplesField(Field(examplesToMerge))
            } else {
                // hint:70A3D8B6
                setExamples(de.lancom.openapi.parser.util.mergeMap(oldExamples, examplesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): Components {
        return setExamplesField(Field(examples))
    }

    // hint:D465F782
    fun unsetExamples(): Components {
        return setExamplesField(Field.unset())
    }

    // hint:5C81D396
    fun addExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): Components {
        return mergeExamples(examples)
    }

    // hint:1A6B37F8
    fun addExamples(vararg examples: Pair<String, ReferenceOrInstance<Example>?>): Components {
        return addExamples(examples.toMap())
    }

    // hint:9D0E4CA5
    fun addExample(key: String, value: ReferenceOrInstance<Example>?): Components {
        return addExamples(key to value)
    }

    // hint:B8F25E73
    fun addExample(pair: Pair<String, ReferenceOrInstance<Example>?>): Components {
        return addExamples(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addExample(key: String, value: Example): Components {
        return addExamples(key to Instance(value))
    }

    ///////////////////////
    //
    // requestBodies
    //
    ///////////////////////

    // hint:3A7F9B2E
    val requestBodies: Map<String, ReferenceOrInstance<RequestBody>?>?
        get() = _requestBodies.orNull

    // hint:F0C48D71
    fun setRequestBodiesField(requestBodies: Field<Map<String, ReferenceOrInstance<RequestBody>?>?>): Components {
        return copy(_requestBodies = requestBodies)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateRequestBodiesField(updater: (Field<Map<String, ReferenceOrInstance<RequestBody>?>?>) -> Field<Map<String, ReferenceOrInstance<RequestBody>?>?>): Components {
        return setRequestBodiesField(updater(_requestBodies))
    }

    // hint:B1D730FC
    fun updateRequestBodies(updater: (Map<String, ReferenceOrInstance<RequestBody>?>?) -> Map<String, ReferenceOrInstance<RequestBody>?>?): Components {
        return updateRequestBodiesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeRequestBodiesField(requestBodiesFieldToMerge: Field<Map<String, ReferenceOrInstance<RequestBody>?>?>): Components {
        return mergeRequestBodies(requestBodiesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeRequestBodies(requestBodiesToMerge: Map<String, ReferenceOrInstance<RequestBody>?>?): Components {
        return if (requestBodiesToMerge == null) {
            this
        } else {
            val oldRequestBodies = _requestBodies.orNull
            if (oldRequestBodies == null) {
                setRequestBodiesField(Field(requestBodiesToMerge))
            } else {
                // hint:70A3D8B6
                setRequestBodies(de.lancom.openapi.parser.util.mergeMap(oldRequestBodies, requestBodiesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setRequestBodies(requestBodies: Map<String, ReferenceOrInstance<RequestBody>?>?): Components {
        return setRequestBodiesField(Field(requestBodies))
    }

    // hint:D465F782
    fun unsetRequestBodies(): Components {
        return setRequestBodiesField(Field.unset())
    }

    // hint:5C81D396
    fun addRequestBodies(requestBodies: Map<String, ReferenceOrInstance<RequestBody>?>?): Components {
        return mergeRequestBodies(requestBodies)
    }

    // hint:1A6B37F8
    fun addRequestBodies(vararg requestBodies: Pair<String, ReferenceOrInstance<RequestBody>?>): Components {
        return addRequestBodies(requestBodies.toMap())
    }

    // hint:9D0E4CA5
    fun addRequestBody(key: String, value: ReferenceOrInstance<RequestBody>?): Components {
        return addRequestBodies(key to value)
    }

    // hint:B8F25E73
    fun addRequestBody(pair: Pair<String, ReferenceOrInstance<RequestBody>?>): Components {
        return addRequestBodies(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addRequestBody(key: String, value: RequestBody): Components {
        return addRequestBodies(key to Instance(value))
    }

    ///////////////////////
    //
    // headers
    //
    ///////////////////////

    // hint:3A7F9B2E
    val headers: Map<String, ReferenceOrInstance<Header>?>?
        get() = _headers.orNull

    // hint:F0C48D71
    fun setHeadersField(headers: Field<Map<String, ReferenceOrInstance<Header>?>?>): Components {
        return copy(_headers = headers)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateHeadersField(updater: (Field<Map<String, ReferenceOrInstance<Header>?>?>) -> Field<Map<String, ReferenceOrInstance<Header>?>?>): Components {
        return setHeadersField(updater(_headers))
    }

    // hint:B1D730FC
    fun updateHeaders(updater: (Map<String, ReferenceOrInstance<Header>?>?) -> Map<String, ReferenceOrInstance<Header>?>?): Components {
        return updateHeadersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeHeadersField(headersFieldToMerge: Field<Map<String, ReferenceOrInstance<Header>?>?>): Components {
        return mergeHeaders(headersFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeHeaders(headersToMerge: Map<String, ReferenceOrInstance<Header>?>?): Components {
        return if (headersToMerge == null) {
            this
        } else {
            val oldHeaders = _headers.orNull
            if (oldHeaders == null) {
                setHeadersField(Field(headersToMerge))
            } else {
                // hint:70A3D8B6
                setHeaders(de.lancom.openapi.parser.util.mergeMap(oldHeaders, headersToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setHeaders(headers: Map<String, ReferenceOrInstance<Header>?>?): Components {
        return setHeadersField(Field(headers))
    }

    // hint:D465F782
    fun unsetHeaders(): Components {
        return setHeadersField(Field.unset())
    }

    // hint:5C81D396
    fun addHeaders(headers: Map<String, ReferenceOrInstance<Header>?>?): Components {
        return mergeHeaders(headers)
    }

    // hint:1A6B37F8
    fun addHeaders(vararg headers: Pair<String, ReferenceOrInstance<Header>?>): Components {
        return addHeaders(headers.toMap())
    }

    // hint:9D0E4CA5
    fun addHeader(key: String, value: ReferenceOrInstance<Header>?): Components {
        return addHeaders(key to value)
    }

    // hint:B8F25E73
    fun addHeader(pair: Pair<String, ReferenceOrInstance<Header>?>): Components {
        return addHeaders(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addHeader(key: String, value: Header): Components {
        return addHeaders(key to Instance(value))
    }

    ///////////////////////
    //
    // securitySchemes
    //
    ///////////////////////

    // hint:3A7F9B2E
    val securitySchemes: Map<String, ReferenceOrInstance<SecurityScheme>?>?
        get() = _securitySchemes.orNull

    // hint:F0C48D71
    fun setSecuritySchemesField(securitySchemes: Field<Map<String, ReferenceOrInstance<SecurityScheme>?>?>): Components {
        return copy(_securitySchemes = securitySchemes)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSecuritySchemesField(updater: (Field<Map<String, ReferenceOrInstance<SecurityScheme>?>?>) -> Field<Map<String, ReferenceOrInstance<SecurityScheme>?>?>): Components {
        return setSecuritySchemesField(updater(_securitySchemes))
    }

    // hint:B1D730FC
    fun updateSecuritySchemes(updater: (Map<String, ReferenceOrInstance<SecurityScheme>?>?) -> Map<String, ReferenceOrInstance<SecurityScheme>?>?): Components {
        return updateSecuritySchemesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSecuritySchemesField(securitySchemesFieldToMerge: Field<Map<String, ReferenceOrInstance<SecurityScheme>?>?>): Components {
        return mergeSecuritySchemes(securitySchemesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSecuritySchemes(securitySchemesToMerge: Map<String, ReferenceOrInstance<SecurityScheme>?>?): Components {
        return if (securitySchemesToMerge == null) {
            this
        } else {
            val oldSecuritySchemes = _securitySchemes.orNull
            if (oldSecuritySchemes == null) {
                setSecuritySchemesField(Field(securitySchemesToMerge))
            } else {
                // hint:70A3D8B6
                setSecuritySchemes(de.lancom.openapi.parser.util.mergeMap(oldSecuritySchemes, securitySchemesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setSecuritySchemes(securitySchemes: Map<String, ReferenceOrInstance<SecurityScheme>?>?): Components {
        return setSecuritySchemesField(Field(securitySchemes))
    }

    // hint:D465F782
    fun unsetSecuritySchemes(): Components {
        return setSecuritySchemesField(Field.unset())
    }

    // hint:5C81D396
    fun addSecuritySchemes(securitySchemes: Map<String, ReferenceOrInstance<SecurityScheme>?>?): Components {
        return mergeSecuritySchemes(securitySchemes)
    }

    // hint:1A6B37F8
    fun addSecuritySchemes(vararg securitySchemes: Pair<String, ReferenceOrInstance<SecurityScheme>?>): Components {
        return addSecuritySchemes(securitySchemes.toMap())
    }

    // hint:9D0E4CA5
    fun addSecurityScheme(key: String, value: ReferenceOrInstance<SecurityScheme>?): Components {
        return addSecuritySchemes(key to value)
    }

    // hint:B8F25E73
    fun addSecurityScheme(pair: Pair<String, ReferenceOrInstance<SecurityScheme>?>): Components {
        return addSecuritySchemes(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addSecurityScheme(key: String, value: SecurityScheme): Components {
        return addSecuritySchemes(key to Instance(value))
    }

    ///////////////////////
    //
    // links
    //
    ///////////////////////

    // hint:3A7F9B2E
    val links: Map<String, ReferenceOrInstance<Link>?>?
        get() = _links.orNull

    // hint:F0C48D71
    fun setLinksField(links: Field<Map<String, ReferenceOrInstance<Link>?>?>): Components {
        return copy(_links = links)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateLinksField(updater: (Field<Map<String, ReferenceOrInstance<Link>?>?>) -> Field<Map<String, ReferenceOrInstance<Link>?>?>): Components {
        return setLinksField(updater(_links))
    }

    // hint:B1D730FC
    fun updateLinks(updater: (Map<String, ReferenceOrInstance<Link>?>?) -> Map<String, ReferenceOrInstance<Link>?>?): Components {
        return updateLinksField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeLinksField(linksFieldToMerge: Field<Map<String, ReferenceOrInstance<Link>?>?>): Components {
        return mergeLinks(linksFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeLinks(linksToMerge: Map<String, ReferenceOrInstance<Link>?>?): Components {
        return if (linksToMerge == null) {
            this
        } else {
            val oldLinks = _links.orNull
            if (oldLinks == null) {
                setLinksField(Field(linksToMerge))
            } else {
                // hint:70A3D8B6
                setLinks(de.lancom.openapi.parser.util.mergeMap(oldLinks, linksToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setLinks(links: Map<String, ReferenceOrInstance<Link>?>?): Components {
        return setLinksField(Field(links))
    }

    // hint:D465F782
    fun unsetLinks(): Components {
        return setLinksField(Field.unset())
    }

    // hint:5C81D396
    fun addLinks(links: Map<String, ReferenceOrInstance<Link>?>?): Components {
        return mergeLinks(links)
    }

    // hint:1A6B37F8
    fun addLinks(vararg links: Pair<String, ReferenceOrInstance<Link>?>): Components {
        return addLinks(links.toMap())
    }

    // hint:9D0E4CA5
    fun addLink(key: String, value: ReferenceOrInstance<Link>?): Components {
        return addLinks(key to value)
    }

    // hint:B8F25E73
    fun addLink(pair: Pair<String, ReferenceOrInstance<Link>?>): Components {
        return addLinks(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addLink(key: String, value: Link): Components {
        return addLinks(key to Instance(value))
    }

    ///////////////////////
    //
    // callbacks
    //
    ///////////////////////

    // hint:3A7F9B2E
    val callbacks: Map<String, ReferenceOrInstance<Callback>?>?
        get() = _callbacks.orNull

    // hint:F0C48D71
    fun setCallbacksField(callbacks: Field<Map<String, ReferenceOrInstance<Callback>?>?>): Components {
        return copy(_callbacks = callbacks)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateCallbacksField(updater: (Field<Map<String, ReferenceOrInstance<Callback>?>?>) -> Field<Map<String, ReferenceOrInstance<Callback>?>?>): Components {
        return setCallbacksField(updater(_callbacks))
    }

    // hint:B1D730FC
    fun updateCallbacks(updater: (Map<String, ReferenceOrInstance<Callback>?>?) -> Map<String, ReferenceOrInstance<Callback>?>?): Components {
        return updateCallbacksField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeCallbacksField(callbacksFieldToMerge: Field<Map<String, ReferenceOrInstance<Callback>?>?>): Components {
        return mergeCallbacks(callbacksFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeCallbacks(callbacksToMerge: Map<String, ReferenceOrInstance<Callback>?>?): Components {
        return if (callbacksToMerge == null) {
            this
        } else {
            val oldCallbacks = _callbacks.orNull
            if (oldCallbacks == null) {
                setCallbacksField(Field(callbacksToMerge))
            } else {
                // hint:70A3D8B6
                setCallbacks(de.lancom.openapi.parser.util.mergeMap(oldCallbacks, callbacksToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setCallbacks(callbacks: Map<String, ReferenceOrInstance<Callback>?>?): Components {
        return setCallbacksField(Field(callbacks))
    }

    // hint:D465F782
    fun unsetCallbacks(): Components {
        return setCallbacksField(Field.unset())
    }

    // hint:5C81D396
    fun addCallbacks(callbacks: Map<String, ReferenceOrInstance<Callback>?>?): Components {
        return mergeCallbacks(callbacks)
    }

    // hint:1A6B37F8
    fun addCallbacks(vararg callbacks: Pair<String, ReferenceOrInstance<Callback>?>): Components {
        return addCallbacks(callbacks.toMap())
    }

    // hint:9D0E4CA5
    fun addCallback(key: String, value: ReferenceOrInstance<Callback>?): Components {
        return addCallbacks(key to value)
    }

    // hint:B8F25E73
    fun addCallback(pair: Pair<String, ReferenceOrInstance<Callback>?>): Components {
        return addCallbacks(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addCallback(key: String, value: Callback): Components {
        return addCallbacks(key to Instance(value))
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): Components {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): Components {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): Components {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): Components {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): Components {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): Components {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): Components {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): Components {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): Components {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): Components {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): Components {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "schemas" to _schemas,
                "responses" to _responses,
                "parameters" to _parameters,
                "examples" to _examples,
                "requestBodies" to _requestBodies,
                "headers" to _headers,
                "securitySchemes" to _securitySchemes,
                "links" to _links,
                "callbacks" to _callbacks,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_schemas.isDefined) Fields.schemas else null,
                if (_responses.isDefined) Fields.responses else null,
                if (_parameters.isDefined) Fields.parameters else null,
                if (_examples.isDefined) Fields.examples else null,
                if (_requestBodies.isDefined) Fields.requestBodies else null,
                if (_headers.isDefined) Fields.headers else null,
                if (_securitySchemes.isDefined) Fields.securitySchemes else null,
                if (_links.isDefined) Fields.links else null,
                if (_callbacks.isDefined) Fields.callbacks else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): Components {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): Components {
        return when (other) {
            null ->
                this

            is Components ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: Components): Components {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: Components?): Components {
        if (other == null) return this
        return this
            .mergeSchemasField(other._schemas)
            .mergeResponsesField(other._responses)
            .mergeParametersField(other._parameters)
            .mergeExamplesField(other._examples)
            .mergeRequestBodiesField(other._requestBodies)
            .mergeHeadersField(other._headers)
            .mergeSecuritySchemesField(other._securitySchemes)
            .mergeLinksField(other._links)
            .mergeCallbacksField(other._callbacks)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    companion object : Parser<Components> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val schemas = Fields("schemas")
                val responses = Fields("responses")
                val parameters = Fields("parameters")
                val examples = Fields("examples")
                val requestBodies = Fields("requestBodies")
                val headers = Fields("headers")
                val securitySchemes = Fields("securitySchemes")
                val links = Fields("links")
                val callbacks = Fields("callbacks")
                val all: Set<Fields> = setOf(
                    schemas,
                    responses,
                    parameters,
                    examples,
                    requestBodies,
                    headers,
                    securitySchemes,
                    links,
                    callbacks,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<Components>(Components::class.java, Components)
        class Deserializer : EntityDeserializer<Components>(Components::class.java, Components)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): Components {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): Components {
            return Components(
                _schemas = wrapper["schemas"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Schema::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _responses = wrapper["responses"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Response::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _parameters = wrapper["parameters"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Parameter::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _examples = wrapper["examples"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Example::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _requestBodies = wrapper["requestBodies"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(RequestBody::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _headers = wrapper["headers"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Header::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _securitySchemes = wrapper["securitySchemes"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(SecurityScheme::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _links = wrapper["links"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Link::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _callbacks = wrapper["callbacks"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Callback::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
