/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.Parser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = Encoding.Companion.Serializer::class)
@JsonDeserialize(using = Encoding.Companion.Deserializer::class)
data class Encoding(
    val _contentType: Field<String?> = Field.unset(),
    val _headers: Field<Map<String, ReferenceOrInstance<Header>?>?> = Field.unset(),
    val _style: Field<Style?> = Field.unset(),
    val _explode: Field<Boolean?> = Field.unset(),
    val _allowReserved: Field<Boolean> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
) : Entity {

    ///////////////////////
    //
    // contentType
    //
    ///////////////////////

    // hint:3A7F9B2E
    val contentType: String?
        get() = _contentType.orNull

    // hint:F0C48D71
    fun setContentTypeField(contentType: Field<String?>): Encoding {
        return copy(_contentType = contentType)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateContentTypeField(updater: (Field<String?>) -> Field<String?>): Encoding {
        return setContentTypeField(updater(_contentType))
    }

    // hint:B1D730FC
    fun updateContentType(updater: (String?) -> String?): Encoding {
        return updateContentTypeField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeContentTypeField(contentTypeFieldToMerge: Field<String?>): Encoding {
        return mergeContentType(contentTypeFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeContentType(contentTypeToMerge: String?): Encoding {
        return if (contentTypeToMerge == null) {
            this
        } else {
            val oldContentType = _contentType.orNull
            if (oldContentType == null) {
                setContentTypeField(Field(contentTypeToMerge))
            } else {
                // hint:2F684DAC
                setContentType(contentTypeToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setContentType(contentType: String?): Encoding {
        return setContentTypeField(Field(contentType))
    }

    // hint:D465F782
    fun unsetContentType(): Encoding {
        return setContentTypeField(Field.unset())
    }

    // hint:47C9A0F6
    fun addContentType(contentType: String): Encoding {
        if (this.contentType != null) {
            throw IllegalStateException("Field contentType of Entity Encoding is already set to '${this.contentType}', refused to add new value '$contentType'")
        }
        return setContentType(contentType)
    }

    ///////////////////////
    //
    // headers
    //
    ///////////////////////

    // hint:3A7F9B2E
    val headers: Map<String, ReferenceOrInstance<Header>?>?
        get() = _headers.orNull

    // hint:F0C48D71
    fun setHeadersField(headers: Field<Map<String, ReferenceOrInstance<Header>?>?>): Encoding {
        return copy(_headers = headers)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateHeadersField(updater: (Field<Map<String, ReferenceOrInstance<Header>?>?>) -> Field<Map<String, ReferenceOrInstance<Header>?>?>): Encoding {
        return setHeadersField(updater(_headers))
    }

    // hint:B1D730FC
    fun updateHeaders(updater: (Map<String, ReferenceOrInstance<Header>?>?) -> Map<String, ReferenceOrInstance<Header>?>?): Encoding {
        return updateHeadersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeHeadersField(headersFieldToMerge: Field<Map<String, ReferenceOrInstance<Header>?>?>): Encoding {
        return mergeHeaders(headersFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeHeaders(headersToMerge: Map<String, ReferenceOrInstance<Header>?>?): Encoding {
        return if (headersToMerge == null) {
            this
        } else {
            val oldHeaders = _headers.orNull
            if (oldHeaders == null) {
                setHeadersField(Field(headersToMerge))
            } else {
                // hint:70A3D8B6
                setHeaders(de.lancom.openapi.parser.util.mergeMap(oldHeaders, headersToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setHeaders(headers: Map<String, ReferenceOrInstance<Header>?>?): Encoding {
        return setHeadersField(Field(headers))
    }

    // hint:D465F782
    fun unsetHeaders(): Encoding {
        return setHeadersField(Field.unset())
    }

    // hint:5C81D396
    fun addHeaders(headers: Map<String, ReferenceOrInstance<Header>?>?): Encoding {
        return mergeHeaders(headers)
    }

    // hint:1A6B37F8
    fun addHeaders(vararg headers: Pair<String, ReferenceOrInstance<Header>?>): Encoding {
        return addHeaders(headers.toMap())
    }

    // hint:9D0E4CA5
    fun addHeader(key: String, value: ReferenceOrInstance<Header>?): Encoding {
        return addHeaders(key to value)
    }

    // hint:B8F25E73
    fun addHeader(pair: Pair<String, ReferenceOrInstance<Header>?>): Encoding {
        return addHeaders(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addHeader(key: String, value: Header): Encoding {
        return addHeaders(key to Instance(value))
    }

    ///////////////////////
    //
    // style
    //
    ///////////////////////

    // hint:3A7F9B2E
    val style: Style?
        get() = _style.orNull

    // hint:F0C48D71
    fun setStyleField(style: Field<Style?>): Encoding {
        return copy(_style = style)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateStyleField(updater: (Field<Style?>) -> Field<Style?>): Encoding {
        return setStyleField(updater(_style))
    }

    // hint:B1D730FC
    fun updateStyle(updater: (Style?) -> Style?): Encoding {
        return updateStyleField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeStyleField(styleFieldToMerge: Field<Style?>): Encoding {
        return mergeStyle(styleFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeStyle(styleToMerge: Style?): Encoding {
        return if (styleToMerge == null) {
            this
        } else {
            val oldStyle = _style.orNull
            if (oldStyle == null) {
                setStyleField(Field(styleToMerge))
            } else {
                // hint:2F684DAC
                setStyle(styleToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setStyle(style: Style?): Encoding {
        return setStyleField(Field(style))
    }

    // hint:D465F782
    fun unsetStyle(): Encoding {
        return setStyleField(Field.unset())
    }

    // hint:47C9A0F6
    fun addStyle(style: Style): Encoding {
        if (this.style != null) {
            throw IllegalStateException("Field style of Entity Encoding is already set to '${this.style}', refused to add new value '$style'")
        }
        return setStyle(style)
    }

    // hint:E3AF607D
    fun setStyleForm(): Encoding {
        return setStyle(Style.Form)
    }

    // hint:3D98E6A5
    fun addStyleForm(): Encoding {
        return addStyle(Style.Form)
    }

    // hint:E3AF607D
    fun setStyleSpaceDelimited(): Encoding {
        return setStyle(Style.SpaceDelimited)
    }

    // hint:3D98E6A5
    fun addStyleSpaceDelimited(): Encoding {
        return addStyle(Style.SpaceDelimited)
    }

    // hint:E3AF607D
    fun setStylePipeDelimited(): Encoding {
        return setStyle(Style.PipeDelimited)
    }

    // hint:3D98E6A5
    fun addStylePipeDelimited(): Encoding {
        return addStyle(Style.PipeDelimited)
    }

    // hint:E3AF607D
    fun setStyleDeepObject(): Encoding {
        return setStyle(Style.DeepObject)
    }

    // hint:3D98E6A5
    fun addStyleDeepObject(): Encoding {
        return addStyle(Style.DeepObject)
    }

    ///////////////////////
    //
    // explode
    //
    ///////////////////////

    // hint:3A7F9B2E
    val explode: Boolean?
        get() = _explode.orNull

    // hint:F0C48D71
    fun setExplodeField(explode: Field<Boolean?>): Encoding {
        return copy(_explode = explode)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExplodeField(updater: (Field<Boolean?>) -> Field<Boolean?>): Encoding {
        return setExplodeField(updater(_explode))
    }

    // hint:B1D730FC
    fun updateExplode(updater: (Boolean?) -> Boolean?): Encoding {
        return updateExplodeField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExplodeField(explodeFieldToMerge: Field<Boolean?>): Encoding {
        return mergeExplode(explodeFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExplode(explodeToMerge: Boolean?): Encoding {
        return if (explodeToMerge == null) {
            this
        } else {
            val oldExplode = _explode.orNull
            if (oldExplode == null) {
                setExplodeField(Field(explodeToMerge))
            } else {
                // hint:2F684DAC
                setExplode(explodeToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setExplode(explode: Boolean?): Encoding {
        return setExplodeField(Field(explode))
    }

    // hint:D465F782
    fun unsetExplode(): Encoding {
        return setExplodeField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExplode(explode: Boolean): Encoding {
        if (this.explode != null) {
            throw IllegalStateException("Field explode of Entity Encoding is already set to '${this.explode}', refused to add new value '$explode'")
        }
        return setExplode(explode)
    }

    ///////////////////////
    //
    // allowReserved
    //
    ///////////////////////

    // hint:3A7F9B2E
    val allowReserved: Boolean
        get() = _allowReserved.orNull ?: false

    // hint:F0C48D71
    fun setAllowReservedField(allowReserved: Field<Boolean>): Encoding {
        return copy(_allowReserved = allowReserved)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateAllowReservedField(updater: (Field<Boolean>) -> Field<Boolean>): Encoding {
        return setAllowReservedField(updater(_allowReserved))
    }

    // hint:B1D730FC
    fun updateAllowReserved(updater: (Boolean) -> Boolean): Encoding {
        return updateAllowReservedField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeAllowReservedField(allowReservedFieldToMerge: Field<Boolean>): Encoding {
        return mergeAllowReserved(allowReservedFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeAllowReserved(allowReservedToMerge: Boolean?): Encoding {
        return if (allowReservedToMerge == null) {
            this
        } else {
            val oldAllowReserved = _allowReserved.orNull
            if (oldAllowReserved == null) {
                setAllowReservedField(Field(allowReservedToMerge))
            } else {
                // hint:2F684DAC
                setAllowReserved(allowReservedToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setAllowReserved(allowReserved: Boolean): Encoding {
        return setAllowReservedField(Field(allowReserved))
    }

    // hint:D465F782
    fun unsetAllowReserved(): Encoding {
        return setAllowReservedField(Field.unset())
    }

    // hint:47C9A0F6
    fun addAllowReserved(allowReserved: Boolean = true): Encoding {
        return setAllowReserved(allowReserved)
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): Encoding {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): Encoding {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): Encoding {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): Encoding {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): Encoding {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): Encoding {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): Encoding {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): Encoding {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): Encoding {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): Encoding {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): Encoding {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "contentType" to _contentType,
                "headers" to _headers,
                "style" to _style,
                "explode" to _explode,
                "allowReserved" to _allowReserved,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_contentType.isDefined) Fields.contentType else null,
                if (_headers.isDefined) Fields.headers else null,
                if (_style.isDefined) Fields.style else null,
                if (_explode.isDefined) Fields.explode else null,
                if (_allowReserved.isDefined) Fields.allowReserved else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): Encoding {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): Encoding {
        return when (other) {
            null ->
                this

            is Encoding ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: Encoding): Encoding {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: Encoding?): Encoding {
        if (other == null) return this
        return this
            .mergeContentTypeField(other._contentType)
            .mergeHeadersField(other._headers)
            .mergeStyleField(other._style)
            .mergeExplodeField(other._explode)
            .mergeAllowReservedField(other._allowReserved)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    companion object : Parser<Encoding> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val contentType = Fields("contentType")
                val headers = Fields("headers")
                val style = Fields("style")
                val explode = Fields("explode")
                val allowReserved = Fields("allowReserved")
                val all: Set<Fields> = setOf(
                    contentType,
                    headers,
                    style,
                    explode,
                    allowReserved,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<Encoding>(Encoding::class.java, Encoding)
        class Deserializer : EntityDeserializer<Encoding>(Encoding::class.java, Encoding)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): Encoding {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): Encoding {
            return Encoding(
                _contentType = wrapper["contentType"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _headers = wrapper["headers"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Header::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _style = wrapper["style"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getEnum(Style::fromString)
                        }
                    }
                },
                _explode = wrapper["explode"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _allowReserved = wrapper["allowReserved"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
