/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.ReferenceParser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Referenceable

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = Example.Companion.Serializer::class)
@JsonDeserialize(using = Example.Companion.Deserializer::class)
data class Example(
    val _summary: Field<String?> = Field.unset(),
    val _description: Field<String?> = Field.unset(),
    val _value: Field<ExampleJson?> = Field.unset(),
    val _externalValue: Field<String?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
    override val __referenceName: String? = null,
) : Referenceable {

    ///////////////////////
    //
    // summary
    //
    ///////////////////////

    // hint:3A7F9B2E
    val summary: String?
        get() = _summary.orNull

    // hint:F0C48D71
    fun setSummaryField(summary: Field<String?>): Example {
        return copy(_summary = summary)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSummaryField(updater: (Field<String?>) -> Field<String?>): Example {
        return setSummaryField(updater(_summary))
    }

    // hint:B1D730FC
    fun updateSummary(updater: (String?) -> String?): Example {
        return updateSummaryField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSummaryField(summaryFieldToMerge: Field<String?>): Example {
        return mergeSummary(summaryFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSummary(summaryToMerge: String?): Example {
        return if (summaryToMerge == null) {
            this
        } else {
            val oldSummary = _summary.orNull
            if (oldSummary == null) {
                setSummaryField(Field(summaryToMerge))
            } else {
                // hint:2F684DAC
                setSummary(summaryToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setSummary(summary: String?): Example {
        return setSummaryField(Field(summary))
    }

    // hint:D465F782
    fun unsetSummary(): Example {
        return setSummaryField(Field.unset())
    }

    // hint:47C9A0F6
    fun addSummary(summary: String): Example {
        if (this.summary != null) {
            throw IllegalStateException("Field summary of Entity Example is already set to '${this.summary}', refused to add new value '$summary'")
        }
        return setSummary(summary)
    }

    ///////////////////////
    //
    // description
    //
    ///////////////////////

    // hint:3A7F9B2E
    val description: String?
        get() = _description.orNull

    // hint:F0C48D71
    fun setDescriptionField(description: Field<String?>): Example {
        return copy(_description = description)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDescriptionField(updater: (Field<String?>) -> Field<String?>): Example {
        return setDescriptionField(updater(_description))
    }

    // hint:B1D730FC
    fun updateDescription(updater: (String?) -> String?): Example {
        return updateDescriptionField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDescriptionField(descriptionFieldToMerge: Field<String?>): Example {
        return mergeDescription(descriptionFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDescription(descriptionToMerge: String?): Example {
        return if (descriptionToMerge == null) {
            this
        } else {
            val oldDescription = _description.orNull
            if (oldDescription == null) {
                setDescriptionField(Field(descriptionToMerge))
            } else {
                // hint:2F684DAC
                setDescription(descriptionToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDescription(description: String?): Example {
        return setDescriptionField(Field(description))
    }

    // hint:D465F782
    fun unsetDescription(): Example {
        return setDescriptionField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDescription(description: String): Example {
        if (this.description != null) {
            throw IllegalStateException("Field description of Entity Example is already set to '${this.description}', refused to add new value '$description'")
        }
        return setDescription(description)
    }

    ///////////////////////
    //
    // value
    //
    ///////////////////////

    // hint:3A7F9B2E
    val value: ExampleJson?
        get() = _value.orNull

    // hint:F0C48D71
    fun setValueField(value: Field<ExampleJson?>): Example {
        return copy(_value = value)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateValueField(updater: (Field<ExampleJson?>) -> Field<ExampleJson?>): Example {
        return setValueField(updater(_value))
    }

    // hint:B1D730FC
    fun updateValue(updater: (ExampleJson?) -> ExampleJson?): Example {
        return updateValueField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeValueField(valueFieldToMerge: Field<ExampleJson?>): Example {
        return mergeValue(valueFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeValue(valueToMerge: ExampleJson?): Example {
        return if (valueToMerge == null) {
            this
        } else {
            val oldValue = _value.orNull
            if (oldValue == null) {
                setValueField(Field(valueToMerge))
            } else {
                // hint:E91B4F65
                setValue(oldValue.mergeEntity(valueToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setValue(value: ExampleJson?): Example {
        return setValueField(Field(value))
    }

    // hint:D465F782
    fun unsetValue(): Example {
        return setValueField(Field.unset())
    }

    // hint:47C9A0F6
    fun addValue(value: ExampleJson): Example {
        if (this.value != null) {
            throw IllegalStateException("Field value of Entity Example is already set to '${this.value}', refused to add new value '$value'")
        }
        return setValue(value)
    }

    ///////////////////////
    //
    // externalValue
    //
    ///////////////////////

    // hint:3A7F9B2E
    val externalValue: String?
        get() = _externalValue.orNull

    // hint:F0C48D71
    fun setExternalValueField(externalValue: Field<String?>): Example {
        return copy(_externalValue = externalValue)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExternalValueField(updater: (Field<String?>) -> Field<String?>): Example {
        return setExternalValueField(updater(_externalValue))
    }

    // hint:B1D730FC
    fun updateExternalValue(updater: (String?) -> String?): Example {
        return updateExternalValueField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExternalValueField(externalValueFieldToMerge: Field<String?>): Example {
        return mergeExternalValue(externalValueFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExternalValue(externalValueToMerge: String?): Example {
        return if (externalValueToMerge == null) {
            this
        } else {
            val oldExternalValue = _externalValue.orNull
            if (oldExternalValue == null) {
                setExternalValueField(Field(externalValueToMerge))
            } else {
                // hint:2F684DAC
                setExternalValue(externalValueToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setExternalValue(externalValue: String?): Example {
        return setExternalValueField(Field(externalValue))
    }

    // hint:D465F782
    fun unsetExternalValue(): Example {
        return setExternalValueField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExternalValue(externalValue: String): Example {
        if (this.externalValue != null) {
            throw IllegalStateException("Field externalValue of Entity Example is already set to '${this.externalValue}', refused to add new value '$externalValue'")
        }
        return setExternalValue(externalValue)
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): Example {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): Example {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): Example {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): Example {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): Example {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): Example {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): Example {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): Example {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): Example {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): Example {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): Example {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "summary" to _summary,
                "description" to _description,
                "value" to _value,
                "externalValue" to _externalValue,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_summary.isDefined) Fields.summary else null,
                if (_description.isDefined) Fields.description else null,
                if (_value.isDefined) Fields.value else null,
                if (_externalValue.isDefined) Fields.externalValue else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): Example {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): Example {
        return when (other) {
            null ->
                this

            is Example ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: Example): Example {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: Example?): Example {
        if (other == null) return this
        return this
            .mergeSummaryField(other._summary)
            .mergeDescriptionField(other._description)
            .mergeValueField(other._value)
            .mergeExternalValueField(other._externalValue)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    // hint:21B416A6
    override fun getReferencePath(): String? {
        return if (__referenceName == null) {
            null
        } else {
            "#/components/examples/$__referenceName"
        }
    }

    fun setReferenceName(name: String): Example {
        return copy(__referenceName = name)
    }

    companion object : ReferenceParser<Example> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val summary = Fields("summary")
                val description = Fields("description")
                val value = Fields("value")
                val externalValue = Fields("externalValue")
                val all: Set<Fields> = setOf(
                    summary,
                    description,
                    value,
                    externalValue,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<Example>(Example::class.java, Example)
        class Deserializer : EntityDeserializer<Example>(Example::class.java, Example)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): Example {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): Example {
            return Example(
                _summary = wrapper["summary"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _description = wrapper["description"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _value = wrapper["value"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(ExampleJson::parseEntityOpt)
                        }
                    }
                },
                _externalValue = wrapper["externalValue"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
