/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.ReferenceParser
import de.lancom.openapi.parser.jackson.Wrapper

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = HTTPSecurityScheme.Companion.Serializer::class)
@JsonDeserialize(using = HTTPSecurityScheme.Companion.Deserializer::class)
data class HTTPSecurityScheme(
    val _scheme: Field<String?> = Field.unset(),
    val _bearerFormat: Field<String?> = Field.unset(),
    val _description: Field<String?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
    override val __referenceName: String? = null,
) : SecurityScheme {

    ///////////////////////
    //
    // scheme
    //
    ///////////////////////

    // hint:3A7F9B2E
    val scheme: String?
        get() = _scheme.orNull

    // hint:F0C48D71
    fun setSchemeField(scheme: Field<String?>): HTTPSecurityScheme {
        return copy(_scheme = scheme)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSchemeField(updater: (Field<String?>) -> Field<String?>): HTTPSecurityScheme {
        return setSchemeField(updater(_scheme))
    }

    // hint:B1D730FC
    fun updateScheme(updater: (String?) -> String?): HTTPSecurityScheme {
        return updateSchemeField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSchemeField(schemeFieldToMerge: Field<String?>): HTTPSecurityScheme {
        return mergeScheme(schemeFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeScheme(schemeToMerge: String?): HTTPSecurityScheme {
        return if (schemeToMerge == null) {
            this
        } else {
            val oldScheme = _scheme.orNull
            if (oldScheme == null) {
                setSchemeField(Field(schemeToMerge))
            } else {
                // hint:2F684DAC
                setScheme(schemeToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setScheme(scheme: String?): HTTPSecurityScheme {
        return setSchemeField(Field(scheme))
    }

    // hint:D465F782
    fun unsetScheme(): HTTPSecurityScheme {
        return setSchemeField(Field.unset())
    }

    // hint:47C9A0F6
    fun addScheme(scheme: String): HTTPSecurityScheme {
        if (this.scheme != null) {
            throw IllegalStateException("Field scheme of Entity HTTPSecurityScheme is already set to '${this.scheme}', refused to add new value '$scheme'")
        }
        return setScheme(scheme)
    }

    ///////////////////////
    //
    // bearerFormat
    //
    ///////////////////////

    // hint:3A7F9B2E
    val bearerFormat: String?
        get() = _bearerFormat.orNull

    // hint:F0C48D71
    fun setBearerFormatField(bearerFormat: Field<String?>): HTTPSecurityScheme {
        return copy(_bearerFormat = bearerFormat)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateBearerFormatField(updater: (Field<String?>) -> Field<String?>): HTTPSecurityScheme {
        return setBearerFormatField(updater(_bearerFormat))
    }

    // hint:B1D730FC
    fun updateBearerFormat(updater: (String?) -> String?): HTTPSecurityScheme {
        return updateBearerFormatField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeBearerFormatField(bearerFormatFieldToMerge: Field<String?>): HTTPSecurityScheme {
        return mergeBearerFormat(bearerFormatFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeBearerFormat(bearerFormatToMerge: String?): HTTPSecurityScheme {
        return if (bearerFormatToMerge == null) {
            this
        } else {
            val oldBearerFormat = _bearerFormat.orNull
            if (oldBearerFormat == null) {
                setBearerFormatField(Field(bearerFormatToMerge))
            } else {
                // hint:2F684DAC
                setBearerFormat(bearerFormatToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setBearerFormat(bearerFormat: String?): HTTPSecurityScheme {
        return setBearerFormatField(Field(bearerFormat))
    }

    // hint:D465F782
    fun unsetBearerFormat(): HTTPSecurityScheme {
        return setBearerFormatField(Field.unset())
    }

    // hint:47C9A0F6
    fun addBearerFormat(bearerFormat: String): HTTPSecurityScheme {
        if (this.bearerFormat != null) {
            throw IllegalStateException("Field bearerFormat of Entity HTTPSecurityScheme is already set to '${this.bearerFormat}', refused to add new value '$bearerFormat'")
        }
        return setBearerFormat(bearerFormat)
    }

    ///////////////////////
    //
    // description
    //
    ///////////////////////

    // hint:3A7F9B2E
    val description: String?
        get() = _description.orNull

    // hint:F0C48D71
    fun setDescriptionField(description: Field<String?>): HTTPSecurityScheme {
        return copy(_description = description)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDescriptionField(updater: (Field<String?>) -> Field<String?>): HTTPSecurityScheme {
        return setDescriptionField(updater(_description))
    }

    // hint:B1D730FC
    fun updateDescription(updater: (String?) -> String?): HTTPSecurityScheme {
        return updateDescriptionField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDescriptionField(descriptionFieldToMerge: Field<String?>): HTTPSecurityScheme {
        return mergeDescription(descriptionFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDescription(descriptionToMerge: String?): HTTPSecurityScheme {
        return if (descriptionToMerge == null) {
            this
        } else {
            val oldDescription = _description.orNull
            if (oldDescription == null) {
                setDescriptionField(Field(descriptionToMerge))
            } else {
                // hint:2F684DAC
                setDescription(descriptionToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDescription(description: String?): HTTPSecurityScheme {
        return setDescriptionField(Field(description))
    }

    // hint:D465F782
    fun unsetDescription(): HTTPSecurityScheme {
        return setDescriptionField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDescription(description: String): HTTPSecurityScheme {
        if (this.description != null) {
            throw IllegalStateException("Field description of Entity HTTPSecurityScheme is already set to '${this.description}', refused to add new value '$description'")
        }
        return setDescription(description)
    }

    // hint:C89A3E1F
    override val type: SecuritySchemeType = SecuritySchemeType.http

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): HTTPSecurityScheme {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): HTTPSecurityScheme {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): HTTPSecurityScheme {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): HTTPSecurityScheme {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): HTTPSecurityScheme {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): HTTPSecurityScheme {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): HTTPSecurityScheme {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): HTTPSecurityScheme {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): HTTPSecurityScheme {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): HTTPSecurityScheme {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): HTTPSecurityScheme {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "scheme" to _scheme,
                "bearerFormat" to _bearerFormat,
                "description" to _description,
                "type" to Field(type),
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_scheme.isDefined) Fields.scheme else null,
                if (_bearerFormat.isDefined) Fields.bearerFormat else null,
                if (_description.isDefined) Fields.description else null,
                Fields.type,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): HTTPSecurityScheme {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): HTTPSecurityScheme {
        return when (other) {
            null ->
                this

            is HTTPSecurityScheme ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: HTTPSecurityScheme): HTTPSecurityScheme {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: SecurityScheme?): HTTPSecurityScheme {
        if (other == null) return this
        if (other !is HTTPSecurityScheme) TODO()
        return this
            .mergeSchemeField(other._scheme)
            .mergeBearerFormatField(other._bearerFormat)
            .mergeDescriptionField(other._description)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    // hint:21B416A6
    override fun getReferencePath(): String? {
        return if (__referenceName == null) {
            null
        } else {
            "#/components/securitySchemes/$__referenceName"
        }
    }

    fun setReferenceName(name: String): HTTPSecurityScheme {
        return copy(__referenceName = name)
    }

    companion object : ReferenceParser<SecurityScheme> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val scheme = Fields("scheme")
                val bearerFormat = Fields("bearerFormat")
                val description = Fields("description")
                val type = Fields("type")
                val all: Set<Fields> = setOf(
                    scheme,
                    bearerFormat,
                    description,
                    type,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<SecurityScheme>(SecurityScheme::class.java, HTTPSecurityScheme)
        class Deserializer : EntityDeserializer<SecurityScheme>(SecurityScheme::class.java, HTTPSecurityScheme)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): SecurityScheme {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): HTTPSecurityScheme {
            return HTTPSecurityScheme(
                _scheme = wrapper["scheme"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _bearerFormat = wrapper["bearerFormat"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _description = wrapper["description"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
