/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.ReferenceParser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance
import de.lancom.openapi.parser.ref.Referenceable

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = Header.Companion.Serializer::class)
@JsonDeserialize(using = Header.Companion.Deserializer::class)
data class Header(
    val _description: Field<String?> = Field.unset(),
    val _required: Field<Boolean> = Field.unset(),
    val _deprecated: Field<Boolean> = Field.unset(),
    val _allowEmptyValue: Field<Boolean> = Field.unset(),
    val _style: Field<HeaderStyle> = Field.unset(),
    val _explode: Field<Boolean?> = Field.unset(),
    val _allowReserved: Field<Boolean> = Field.unset(),
    val _schema: Field<ReferenceOrInstance<Schema>?> = Field.unset(),
    val _content: Field<Map<String, MediaType?>?> = Field.unset(),
    val _example: Field<ExampleJson?> = Field.unset(),
    val _examples: Field<Map<String, ReferenceOrInstance<Example>?>?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
    override val __referenceName: String? = null,
) : Referenceable {

    ///////////////////////
    //
    // description
    //
    ///////////////////////

    // hint:3A7F9B2E
    val description: String?
        get() = _description.orNull

    // hint:F0C48D71
    fun setDescriptionField(description: Field<String?>): Header {
        return copy(_description = description)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDescriptionField(updater: (Field<String?>) -> Field<String?>): Header {
        return setDescriptionField(updater(_description))
    }

    // hint:B1D730FC
    fun updateDescription(updater: (String?) -> String?): Header {
        return updateDescriptionField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDescriptionField(descriptionFieldToMerge: Field<String?>): Header {
        return mergeDescription(descriptionFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDescription(descriptionToMerge: String?): Header {
        return if (descriptionToMerge == null) {
            this
        } else {
            val oldDescription = _description.orNull
            if (oldDescription == null) {
                setDescriptionField(Field(descriptionToMerge))
            } else {
                // hint:2F684DAC
                setDescription(descriptionToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDescription(description: String?): Header {
        return setDescriptionField(Field(description))
    }

    // hint:D465F782
    fun unsetDescription(): Header {
        return setDescriptionField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDescription(description: String): Header {
        if (this.description != null) {
            throw IllegalStateException("Field description of Entity Header is already set to '${this.description}', refused to add new value '$description'")
        }
        return setDescription(description)
    }

    ///////////////////////
    //
    // required
    //
    ///////////////////////

    // hint:3A7F9B2E
    val required: Boolean
        get() = _required.orNull ?: false

    // hint:F0C48D71
    fun setRequiredField(required: Field<Boolean>): Header {
        return copy(_required = required)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateRequiredField(updater: (Field<Boolean>) -> Field<Boolean>): Header {
        return setRequiredField(updater(_required))
    }

    // hint:B1D730FC
    fun updateRequired(updater: (Boolean) -> Boolean): Header {
        return updateRequiredField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeRequiredField(requiredFieldToMerge: Field<Boolean>): Header {
        return mergeRequired(requiredFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeRequired(requiredToMerge: Boolean?): Header {
        return if (requiredToMerge == null) {
            this
        } else {
            val oldRequired = _required.orNull
            if (oldRequired == null) {
                setRequiredField(Field(requiredToMerge))
            } else {
                // hint:2F684DAC
                setRequired(requiredToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setRequired(required: Boolean): Header {
        return setRequiredField(Field(required))
    }

    // hint:D465F782
    fun unsetRequired(): Header {
        return setRequiredField(Field.unset())
    }

    // hint:47C9A0F6
    fun addRequired(required: Boolean = true): Header {
        return setRequired(required)
    }

    ///////////////////////
    //
    // deprecated
    //
    ///////////////////////

    // hint:3A7F9B2E
    val deprecated: Boolean
        get() = _deprecated.orNull ?: false

    // hint:F0C48D71
    fun setDeprecatedField(deprecated: Field<Boolean>): Header {
        return copy(_deprecated = deprecated)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDeprecatedField(updater: (Field<Boolean>) -> Field<Boolean>): Header {
        return setDeprecatedField(updater(_deprecated))
    }

    // hint:B1D730FC
    fun updateDeprecated(updater: (Boolean) -> Boolean): Header {
        return updateDeprecatedField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDeprecatedField(deprecatedFieldToMerge: Field<Boolean>): Header {
        return mergeDeprecated(deprecatedFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDeprecated(deprecatedToMerge: Boolean?): Header {
        return if (deprecatedToMerge == null) {
            this
        } else {
            val oldDeprecated = _deprecated.orNull
            if (oldDeprecated == null) {
                setDeprecatedField(Field(deprecatedToMerge))
            } else {
                // hint:2F684DAC
                setDeprecated(deprecatedToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDeprecated(deprecated: Boolean): Header {
        return setDeprecatedField(Field(deprecated))
    }

    // hint:D465F782
    fun unsetDeprecated(): Header {
        return setDeprecatedField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDeprecated(deprecated: Boolean = true): Header {
        return setDeprecated(deprecated)
    }

    ///////////////////////
    //
    // allowEmptyValue
    //
    ///////////////////////

    // hint:3A7F9B2E
    val allowEmptyValue: Boolean
        get() = _allowEmptyValue.orNull ?: false

    // hint:F0C48D71
    fun setAllowEmptyValueField(allowEmptyValue: Field<Boolean>): Header {
        return copy(_allowEmptyValue = allowEmptyValue)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateAllowEmptyValueField(updater: (Field<Boolean>) -> Field<Boolean>): Header {
        return setAllowEmptyValueField(updater(_allowEmptyValue))
    }

    // hint:B1D730FC
    fun updateAllowEmptyValue(updater: (Boolean) -> Boolean): Header {
        return updateAllowEmptyValueField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeAllowEmptyValueField(allowEmptyValueFieldToMerge: Field<Boolean>): Header {
        return mergeAllowEmptyValue(allowEmptyValueFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeAllowEmptyValue(allowEmptyValueToMerge: Boolean?): Header {
        return if (allowEmptyValueToMerge == null) {
            this
        } else {
            val oldAllowEmptyValue = _allowEmptyValue.orNull
            if (oldAllowEmptyValue == null) {
                setAllowEmptyValueField(Field(allowEmptyValueToMerge))
            } else {
                // hint:2F684DAC
                setAllowEmptyValue(allowEmptyValueToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setAllowEmptyValue(allowEmptyValue: Boolean): Header {
        return setAllowEmptyValueField(Field(allowEmptyValue))
    }

    // hint:D465F782
    fun unsetAllowEmptyValue(): Header {
        return setAllowEmptyValueField(Field.unset())
    }

    // hint:47C9A0F6
    fun addAllowEmptyValue(allowEmptyValue: Boolean = true): Header {
        return setAllowEmptyValue(allowEmptyValue)
    }

    ///////////////////////
    //
    // style
    //
    ///////////////////////

    // hint:3A7F9B2E
    val style: HeaderStyle
        get() = _style.orNull ?: HeaderStyle.Simple

    // hint:F0C48D71
    fun setStyleField(style: Field<HeaderStyle>): Header {
        return copy(_style = style)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateStyleField(updater: (Field<HeaderStyle>) -> Field<HeaderStyle>): Header {
        return setStyleField(updater(_style))
    }

    // hint:B1D730FC
    fun updateStyle(updater: (HeaderStyle) -> HeaderStyle): Header {
        return updateStyleField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeStyleField(styleFieldToMerge: Field<HeaderStyle>): Header {
        return mergeStyle(styleFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeStyle(styleToMerge: HeaderStyle?): Header {
        return if (styleToMerge == null) {
            this
        } else {
            val oldStyle = _style.orNull
            if (oldStyle == null) {
                setStyleField(Field(styleToMerge))
            } else {
                // hint:2F684DAC
                setStyle(styleToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setStyle(style: HeaderStyle): Header {
        return setStyleField(Field(style))
    }

    // hint:D465F782
    fun unsetStyle(): Header {
        return setStyleField(Field.unset())
    }

    // hint:47C9A0F6
    fun addStyle(style: HeaderStyle): Header {
        return setStyle(style)
    }

    // hint:E3AF607D
    fun setStyleSimple(): Header {
        return setStyle(HeaderStyle.Simple)
    }

    // hint:3D98E6A5
    fun addStyleSimple(): Header {
        return addStyle(HeaderStyle.Simple)
    }

    ///////////////////////
    //
    // explode
    //
    ///////////////////////

    // hint:3A7F9B2E
    val explode: Boolean?
        get() = _explode.orNull

    // hint:F0C48D71
    fun setExplodeField(explode: Field<Boolean?>): Header {
        return copy(_explode = explode)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExplodeField(updater: (Field<Boolean?>) -> Field<Boolean?>): Header {
        return setExplodeField(updater(_explode))
    }

    // hint:B1D730FC
    fun updateExplode(updater: (Boolean?) -> Boolean?): Header {
        return updateExplodeField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExplodeField(explodeFieldToMerge: Field<Boolean?>): Header {
        return mergeExplode(explodeFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExplode(explodeToMerge: Boolean?): Header {
        return if (explodeToMerge == null) {
            this
        } else {
            val oldExplode = _explode.orNull
            if (oldExplode == null) {
                setExplodeField(Field(explodeToMerge))
            } else {
                // hint:2F684DAC
                setExplode(explodeToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setExplode(explode: Boolean?): Header {
        return setExplodeField(Field(explode))
    }

    // hint:D465F782
    fun unsetExplode(): Header {
        return setExplodeField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExplode(explode: Boolean): Header {
        if (this.explode != null) {
            throw IllegalStateException("Field explode of Entity Header is already set to '${this.explode}', refused to add new value '$explode'")
        }
        return setExplode(explode)
    }

    ///////////////////////
    //
    // allowReserved
    //
    ///////////////////////

    // hint:3A7F9B2E
    val allowReserved: Boolean
        get() = _allowReserved.orNull ?: false

    // hint:F0C48D71
    fun setAllowReservedField(allowReserved: Field<Boolean>): Header {
        return copy(_allowReserved = allowReserved)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateAllowReservedField(updater: (Field<Boolean>) -> Field<Boolean>): Header {
        return setAllowReservedField(updater(_allowReserved))
    }

    // hint:B1D730FC
    fun updateAllowReserved(updater: (Boolean) -> Boolean): Header {
        return updateAllowReservedField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeAllowReservedField(allowReservedFieldToMerge: Field<Boolean>): Header {
        return mergeAllowReserved(allowReservedFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeAllowReserved(allowReservedToMerge: Boolean?): Header {
        return if (allowReservedToMerge == null) {
            this
        } else {
            val oldAllowReserved = _allowReserved.orNull
            if (oldAllowReserved == null) {
                setAllowReservedField(Field(allowReservedToMerge))
            } else {
                // hint:2F684DAC
                setAllowReserved(allowReservedToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setAllowReserved(allowReserved: Boolean): Header {
        return setAllowReservedField(Field(allowReserved))
    }

    // hint:D465F782
    fun unsetAllowReserved(): Header {
        return setAllowReservedField(Field.unset())
    }

    // hint:47C9A0F6
    fun addAllowReserved(allowReserved: Boolean = true): Header {
        return setAllowReserved(allowReserved)
    }

    ///////////////////////
    //
    // schema
    //
    ///////////////////////

    // hint:3A7F9B2E
    val schema: ReferenceOrInstance<Schema>?
        get() = _schema.orNull

    // hint:F0C48D71
    fun setSchemaField(schema: Field<ReferenceOrInstance<Schema>?>): Header {
        return copy(_schema = schema)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSchemaField(updater: (Field<ReferenceOrInstance<Schema>?>) -> Field<ReferenceOrInstance<Schema>?>): Header {
        return setSchemaField(updater(_schema))
    }

    // hint:B1D730FC
    fun updateSchema(updater: (ReferenceOrInstance<Schema>?) -> ReferenceOrInstance<Schema>?): Header {
        return updateSchemaField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSchemaField(schemaFieldToMerge: Field<ReferenceOrInstance<Schema>?>): Header {
        return mergeSchema(schemaFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSchema(schemaToMerge: ReferenceOrInstance<Schema>?): Header {
        return if (schemaToMerge == null) {
            this
        } else {
            val oldSchema = _schema.orNull
            if (oldSchema == null) {
                setSchemaField(Field(schemaToMerge))
            } else {
                // hint:2F684DAC
                setSchema(schemaToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setSchema(schema: ReferenceOrInstance<Schema>?): Header {
        return setSchemaField(Field(schema))
    }

    // hint:D465F782
    fun unsetSchema(): Header {
        return setSchemaField(Field.unset())
    }

    // hint:F8E61D9B
    fun addSchema(schema: Schema): Header {
        return addSchema(Instance(schema))
    }

    // hint:47C9A0F6
    fun addSchema(schema: ReferenceOrInstance<Schema>): Header {
        if (this.schema != null) {
            throw IllegalStateException("Field schema of Entity Header is already set to '${this.schema}', refused to add new value '$schema'")
        }
        return setSchema(schema)
    }

    ///////////////////////
    //
    // content
    //
    ///////////////////////

    // hint:3A7F9B2E
    val content: Map<String, MediaType?>?
        get() = _content.orNull

    // hint:F0C48D71
    fun setContentField(content: Field<Map<String, MediaType?>?>): Header {
        return copy(_content = content)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateContentField(updater: (Field<Map<String, MediaType?>?>) -> Field<Map<String, MediaType?>?>): Header {
        return setContentField(updater(_content))
    }

    // hint:B1D730FC
    fun updateContent(updater: (Map<String, MediaType?>?) -> Map<String, MediaType?>?): Header {
        return updateContentField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeContentField(contentFieldToMerge: Field<Map<String, MediaType?>?>): Header {
        return mergeContent(contentFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeContent(contentToMerge: Map<String, MediaType?>?): Header {
        return if (contentToMerge == null) {
            this
        } else {
            val oldContent = _content.orNull
            if (oldContent == null) {
                setContentField(Field(contentToMerge))
            } else {
                // hint:70A3D8B6
                setContent(de.lancom.openapi.parser.util.mergeMap(oldContent, contentToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setContent(content: Map<String, MediaType?>?): Header {
        return setContentField(Field(content))
    }

    // hint:D465F782
    fun unsetContent(): Header {
        return setContentField(Field.unset())
    }

    // hint:5C81D396
    fun addContent(content: Map<String, MediaType?>?): Header {
        return mergeContent(content)
    }

    // hint:1A6B37F8
    fun addContent(vararg content: Pair<String, MediaType?>): Header {
        return addContent(content.toMap())
    }

    // hint:9D0E4CA5
    fun addContent(key: String, value: MediaType?): Header {
        return addContent(key to value)
    }

    // hint:B8F25E73
    fun addContent(pair: Pair<String, MediaType?>): Header {
        return addContent(mapOf(pair))
    }

    ///////////////////////
    //
    // example
    //
    ///////////////////////

    // hint:3A7F9B2E
    val example: ExampleJson?
        get() = _example.orNull

    // hint:F0C48D71
    fun setExampleField(example: Field<ExampleJson?>): Header {
        return copy(_example = example)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExampleField(updater: (Field<ExampleJson?>) -> Field<ExampleJson?>): Header {
        return setExampleField(updater(_example))
    }

    // hint:B1D730FC
    fun updateExample(updater: (ExampleJson?) -> ExampleJson?): Header {
        return updateExampleField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExampleField(exampleFieldToMerge: Field<ExampleJson?>): Header {
        return mergeExample(exampleFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExample(exampleToMerge: ExampleJson?): Header {
        return if (exampleToMerge == null) {
            this
        } else {
            val oldExample = _example.orNull
            if (oldExample == null) {
                setExampleField(Field(exampleToMerge))
            } else {
                // hint:E91B4F65
                setExample(oldExample.mergeEntity(exampleToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExample(example: ExampleJson?): Header {
        return setExampleField(Field(example))
    }

    // hint:D465F782
    fun unsetExample(): Header {
        return setExampleField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExample(example: ExampleJson): Header {
        if (this.example != null) {
            throw IllegalStateException("Field example of Entity Header is already set to '${this.example}', refused to add new value '$example'")
        }
        return setExample(example)
    }

    ///////////////////////
    //
    // examples
    //
    ///////////////////////

    // hint:3A7F9B2E
    val examples: Map<String, ReferenceOrInstance<Example>?>?
        get() = _examples.orNull

    // hint:F0C48D71
    fun setExamplesField(examples: Field<Map<String, ReferenceOrInstance<Example>?>?>): Header {
        return copy(_examples = examples)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExamplesField(updater: (Field<Map<String, ReferenceOrInstance<Example>?>?>) -> Field<Map<String, ReferenceOrInstance<Example>?>?>): Header {
        return setExamplesField(updater(_examples))
    }

    // hint:B1D730FC
    fun updateExamples(updater: (Map<String, ReferenceOrInstance<Example>?>?) -> Map<String, ReferenceOrInstance<Example>?>?): Header {
        return updateExamplesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExamplesField(examplesFieldToMerge: Field<Map<String, ReferenceOrInstance<Example>?>?>): Header {
        return mergeExamples(examplesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExamples(examplesToMerge: Map<String, ReferenceOrInstance<Example>?>?): Header {
        return if (examplesToMerge == null) {
            this
        } else {
            val oldExamples = _examples.orNull
            if (oldExamples == null) {
                setExamplesField(Field(examplesToMerge))
            } else {
                // hint:70A3D8B6
                setExamples(de.lancom.openapi.parser.util.mergeMap(oldExamples, examplesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): Header {
        return setExamplesField(Field(examples))
    }

    // hint:D465F782
    fun unsetExamples(): Header {
        return setExamplesField(Field.unset())
    }

    // hint:5C81D396
    fun addExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): Header {
        return mergeExamples(examples)
    }

    // hint:1A6B37F8
    fun addExamples(vararg examples: Pair<String, ReferenceOrInstance<Example>?>): Header {
        return addExamples(examples.toMap())
    }

    // hint:9D0E4CA5
    fun addExample(key: String, value: ReferenceOrInstance<Example>?): Header {
        return addExamples(key to value)
    }

    // hint:B8F25E73
    fun addExample(pair: Pair<String, ReferenceOrInstance<Example>?>): Header {
        return addExamples(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addExample(key: String, value: Example): Header {
        return addExamples(key to Instance(value))
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): Header {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): Header {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): Header {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): Header {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): Header {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): Header {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): Header {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): Header {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): Header {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): Header {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): Header {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "description" to _description,
                "required" to _required,
                "deprecated" to _deprecated,
                "allowEmptyValue" to _allowEmptyValue,
                "style" to _style,
                "explode" to _explode,
                "allowReserved" to _allowReserved,
                "schema" to _schema,
                "content" to _content,
                "example" to _example,
                "examples" to _examples,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_description.isDefined) Fields.description else null,
                if (_required.isDefined) Fields.required else null,
                if (_deprecated.isDefined) Fields.deprecated else null,
                if (_allowEmptyValue.isDefined) Fields.allowEmptyValue else null,
                if (_style.isDefined) Fields.style else null,
                if (_explode.isDefined) Fields.explode else null,
                if (_allowReserved.isDefined) Fields.allowReserved else null,
                if (_schema.isDefined) Fields.schema else null,
                if (_content.isDefined) Fields.content else null,
                if (_example.isDefined) Fields.example else null,
                if (_examples.isDefined) Fields.examples else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): Header {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): Header {
        return when (other) {
            null ->
                this

            is Header ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: Header): Header {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: Header?): Header {
        if (other == null) return this
        return this
            .mergeDescriptionField(other._description)
            .mergeRequiredField(other._required)
            .mergeDeprecatedField(other._deprecated)
            .mergeAllowEmptyValueField(other._allowEmptyValue)
            .mergeStyleField(other._style)
            .mergeExplodeField(other._explode)
            .mergeAllowReservedField(other._allowReserved)
            .mergeSchemaField(other._schema)
            .mergeContentField(other._content)
            .mergeExampleField(other._example)
            .mergeExamplesField(other._examples)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    // hint:21B416A6
    override fun getReferencePath(): String? {
        return if (__referenceName == null) {
            null
        } else {
            "#/components/headers/$__referenceName"
        }
    }

    fun setReferenceName(name: String): Header {
        return copy(__referenceName = name)
    }

    companion object : ReferenceParser<Header> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val description = Fields("description")
                val required = Fields("required")
                val deprecated = Fields("deprecated")
                val allowEmptyValue = Fields("allowEmptyValue")
                val style = Fields("style")
                val explode = Fields("explode")
                val allowReserved = Fields("allowReserved")
                val schema = Fields("schema")
                val content = Fields("content")
                val example = Fields("example")
                val examples = Fields("examples")
                val all: Set<Fields> = setOf(
                    description,
                    required,
                    deprecated,
                    allowEmptyValue,
                    style,
                    explode,
                    allowReserved,
                    schema,
                    content,
                    example,
                    examples,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<Header>(Header::class.java, Header)
        class Deserializer : EntityDeserializer<Header>(Header::class.java, Header)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): Header {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): Header {
            return Header(
                _description = wrapper["description"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _required = wrapper["required"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _deprecated = wrapper["deprecated"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _allowEmptyValue = wrapper["allowEmptyValue"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _style = wrapper["style"].getSingle {
                    getSingle {
                        getSingle {
                            getEnum(HeaderStyle::fromString)
                        }
                    }
                },
                _explode = wrapper["explode"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _allowReserved = wrapper["allowReserved"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _schema = wrapper["schema"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Schema::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _content = wrapper["content"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(MediaType::parseEntityOpt)
                        }
                    }
                },
                _example = wrapper["example"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(ExampleJson::parseEntityOpt)
                        }
                    }
                },
                _examples = wrapper["examples"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Example::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
