/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.Parser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = MediaType.Companion.Serializer::class)
@JsonDeserialize(using = MediaType.Companion.Deserializer::class)
data class MediaType(
    val _schema: Field<ReferenceOrInstance<Schema>?> = Field.unset(),
    val _example: Field<ExampleJson?> = Field.unset(),
    val _examples: Field<Map<String, ReferenceOrInstance<Example>?>?> = Field.unset(),
    val _encoding: Field<Map<String, Encoding?>?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
) : Entity {

    ///////////////////////
    //
    // schema
    //
    ///////////////////////

    // hint:3A7F9B2E
    val schema: ReferenceOrInstance<Schema>?
        get() = _schema.orNull

    // hint:F0C48D71
    fun setSchemaField(schema: Field<ReferenceOrInstance<Schema>?>): MediaType {
        return copy(_schema = schema)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSchemaField(updater: (Field<ReferenceOrInstance<Schema>?>) -> Field<ReferenceOrInstance<Schema>?>): MediaType {
        return setSchemaField(updater(_schema))
    }

    // hint:B1D730FC
    fun updateSchema(updater: (ReferenceOrInstance<Schema>?) -> ReferenceOrInstance<Schema>?): MediaType {
        return updateSchemaField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSchemaField(schemaFieldToMerge: Field<ReferenceOrInstance<Schema>?>): MediaType {
        return mergeSchema(schemaFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSchema(schemaToMerge: ReferenceOrInstance<Schema>?): MediaType {
        return if (schemaToMerge == null) {
            this
        } else {
            val oldSchema = _schema.orNull
            if (oldSchema == null) {
                setSchemaField(Field(schemaToMerge))
            } else {
                // hint:2F684DAC
                setSchema(schemaToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setSchema(schema: ReferenceOrInstance<Schema>?): MediaType {
        return setSchemaField(Field(schema))
    }

    // hint:D465F782
    fun unsetSchema(): MediaType {
        return setSchemaField(Field.unset())
    }

    // hint:F8E61D9B
    fun addSchema(schema: Schema): MediaType {
        return addSchema(Instance(schema))
    }

    // hint:47C9A0F6
    fun addSchema(schema: ReferenceOrInstance<Schema>): MediaType {
        if (this.schema != null) {
            throw IllegalStateException("Field schema of Entity MediaType is already set to '${this.schema}', refused to add new value '$schema'")
        }
        return setSchema(schema)
    }

    ///////////////////////
    //
    // example
    //
    ///////////////////////

    // hint:3A7F9B2E
    val example: ExampleJson?
        get() = _example.orNull

    // hint:F0C48D71
    fun setExampleField(example: Field<ExampleJson?>): MediaType {
        return copy(_example = example)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExampleField(updater: (Field<ExampleJson?>) -> Field<ExampleJson?>): MediaType {
        return setExampleField(updater(_example))
    }

    // hint:B1D730FC
    fun updateExample(updater: (ExampleJson?) -> ExampleJson?): MediaType {
        return updateExampleField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExampleField(exampleFieldToMerge: Field<ExampleJson?>): MediaType {
        return mergeExample(exampleFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExample(exampleToMerge: ExampleJson?): MediaType {
        return if (exampleToMerge == null) {
            this
        } else {
            val oldExample = _example.orNull
            if (oldExample == null) {
                setExampleField(Field(exampleToMerge))
            } else {
                // hint:E91B4F65
                setExample(oldExample.mergeEntity(exampleToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExample(example: ExampleJson?): MediaType {
        return setExampleField(Field(example))
    }

    // hint:D465F782
    fun unsetExample(): MediaType {
        return setExampleField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExample(example: ExampleJson): MediaType {
        if (this.example != null) {
            throw IllegalStateException("Field example of Entity MediaType is already set to '${this.example}', refused to add new value '$example'")
        }
        return setExample(example)
    }

    ///////////////////////
    //
    // examples
    //
    ///////////////////////

    // hint:3A7F9B2E
    val examples: Map<String, ReferenceOrInstance<Example>?>?
        get() = _examples.orNull

    // hint:F0C48D71
    fun setExamplesField(examples: Field<Map<String, ReferenceOrInstance<Example>?>?>): MediaType {
        return copy(_examples = examples)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExamplesField(updater: (Field<Map<String, ReferenceOrInstance<Example>?>?>) -> Field<Map<String, ReferenceOrInstance<Example>?>?>): MediaType {
        return setExamplesField(updater(_examples))
    }

    // hint:B1D730FC
    fun updateExamples(updater: (Map<String, ReferenceOrInstance<Example>?>?) -> Map<String, ReferenceOrInstance<Example>?>?): MediaType {
        return updateExamplesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExamplesField(examplesFieldToMerge: Field<Map<String, ReferenceOrInstance<Example>?>?>): MediaType {
        return mergeExamples(examplesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExamples(examplesToMerge: Map<String, ReferenceOrInstance<Example>?>?): MediaType {
        return if (examplesToMerge == null) {
            this
        } else {
            val oldExamples = _examples.orNull
            if (oldExamples == null) {
                setExamplesField(Field(examplesToMerge))
            } else {
                // hint:70A3D8B6
                setExamples(de.lancom.openapi.parser.util.mergeMap(oldExamples, examplesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): MediaType {
        return setExamplesField(Field(examples))
    }

    // hint:D465F782
    fun unsetExamples(): MediaType {
        return setExamplesField(Field.unset())
    }

    // hint:5C81D396
    fun addExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): MediaType {
        return mergeExamples(examples)
    }

    // hint:1A6B37F8
    fun addExamples(vararg examples: Pair<String, ReferenceOrInstance<Example>?>): MediaType {
        return addExamples(examples.toMap())
    }

    // hint:9D0E4CA5
    fun addExample(key: String, value: ReferenceOrInstance<Example>?): MediaType {
        return addExamples(key to value)
    }

    // hint:B8F25E73
    fun addExample(pair: Pair<String, ReferenceOrInstance<Example>?>): MediaType {
        return addExamples(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addExample(key: String, value: Example): MediaType {
        return addExamples(key to Instance(value))
    }

    ///////////////////////
    //
    // encoding
    //
    ///////////////////////

    // hint:3A7F9B2E
    val encoding: Map<String, Encoding?>?
        get() = _encoding.orNull

    // hint:F0C48D71
    fun setEncodingField(encoding: Field<Map<String, Encoding?>?>): MediaType {
        return copy(_encoding = encoding)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateEncodingField(updater: (Field<Map<String, Encoding?>?>) -> Field<Map<String, Encoding?>?>): MediaType {
        return setEncodingField(updater(_encoding))
    }

    // hint:B1D730FC
    fun updateEncoding(updater: (Map<String, Encoding?>?) -> Map<String, Encoding?>?): MediaType {
        return updateEncodingField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeEncodingField(encodingFieldToMerge: Field<Map<String, Encoding?>?>): MediaType {
        return mergeEncoding(encodingFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeEncoding(encodingToMerge: Map<String, Encoding?>?): MediaType {
        return if (encodingToMerge == null) {
            this
        } else {
            val oldEncoding = _encoding.orNull
            if (oldEncoding == null) {
                setEncodingField(Field(encodingToMerge))
            } else {
                // hint:70A3D8B6
                setEncoding(de.lancom.openapi.parser.util.mergeMap(oldEncoding, encodingToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setEncoding(encoding: Map<String, Encoding?>?): MediaType {
        return setEncodingField(Field(encoding))
    }

    // hint:D465F782
    fun unsetEncoding(): MediaType {
        return setEncodingField(Field.unset())
    }

    // hint:5C81D396
    fun addEncoding(encoding: Map<String, Encoding?>?): MediaType {
        return mergeEncoding(encoding)
    }

    // hint:1A6B37F8
    fun addEncoding(vararg encoding: Pair<String, Encoding?>): MediaType {
        return addEncoding(encoding.toMap())
    }

    // hint:9D0E4CA5
    fun addEncoding(key: String, value: Encoding?): MediaType {
        return addEncoding(key to value)
    }

    // hint:B8F25E73
    fun addEncoding(pair: Pair<String, Encoding?>): MediaType {
        return addEncoding(mapOf(pair))
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): MediaType {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): MediaType {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): MediaType {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): MediaType {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): MediaType {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): MediaType {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): MediaType {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): MediaType {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): MediaType {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): MediaType {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): MediaType {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "schema" to _schema,
                "example" to _example,
                "examples" to _examples,
                "encoding" to _encoding,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_schema.isDefined) Fields.schema else null,
                if (_example.isDefined) Fields.example else null,
                if (_examples.isDefined) Fields.examples else null,
                if (_encoding.isDefined) Fields.encoding else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): MediaType {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): MediaType {
        return when (other) {
            null ->
                this

            is MediaType ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: MediaType): MediaType {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: MediaType?): MediaType {
        if (other == null) return this
        return this
            .mergeSchemaField(other._schema)
            .mergeExampleField(other._example)
            .mergeExamplesField(other._examples)
            .mergeEncodingField(other._encoding)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    companion object : Parser<MediaType> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val schema = Fields("schema")
                val example = Fields("example")
                val examples = Fields("examples")
                val encoding = Fields("encoding")
                val all: Set<Fields> = setOf(
                    schema,
                    example,
                    examples,
                    encoding,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<MediaType>(MediaType::class.java, MediaType)
        class Deserializer : EntityDeserializer<MediaType>(MediaType::class.java, MediaType)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): MediaType {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): MediaType {
            return MediaType(
                _schema = wrapper["schema"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Schema::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _example = wrapper["example"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(ExampleJson::parseEntityOpt)
                        }
                    }
                },
                _examples = wrapper["examples"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Example::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _encoding = wrapper["encoding"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Encoding::parseEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
