/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.Parser
import de.lancom.openapi.parser.jackson.Wrapper

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = OpenApi.Companion.Serializer::class)
@JsonDeserialize(using = OpenApi.Companion.Deserializer::class)
data class OpenApi(
    val _openapi: Field<String?> = Field.unset(),
    val _info: Field<Info?> = Field.unset(),
    val _externalDocs: Field<ExternalDocumentation?> = Field.unset(),
    val _servers: Field<List<Server?>?> = Field.unset(),
    val _security: Field<List<SecurityRequirement?>?> = Field.unset(),
    val _tags: Field<List<Tag?>?> = Field.unset(),
    val _paths: Field<Paths?> = Field.unset(),
    val _components: Field<Components?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
) : Entity {

    ///////////////////////
    //
    // openapi
    //
    ///////////////////////

    // hint:3A7F9B2E
    val openapi: String?
        get() = _openapi.orNull

    // hint:F0C48D71
    fun setOpenapiField(openapi: Field<String?>): OpenApi {
        return copy(_openapi = openapi)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateOpenapiField(updater: (Field<String?>) -> Field<String?>): OpenApi {
        return setOpenapiField(updater(_openapi))
    }

    // hint:B1D730FC
    fun updateOpenapi(updater: (String?) -> String?): OpenApi {
        return updateOpenapiField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeOpenapiField(openapiFieldToMerge: Field<String?>): OpenApi {
        return mergeOpenapi(openapiFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeOpenapi(openapiToMerge: String?): OpenApi {
        return if (openapiToMerge == null) {
            this
        } else {
            val oldOpenapi = _openapi.orNull
            if (oldOpenapi == null) {
                setOpenapiField(Field(openapiToMerge))
            } else {
                // hint:2F684DAC
                setOpenapi(openapiToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setOpenapi(openapi: String?): OpenApi {
        return setOpenapiField(Field(openapi))
    }

    // hint:D465F782
    fun unsetOpenapi(): OpenApi {
        return setOpenapiField(Field.unset())
    }

    // hint:47C9A0F6
    fun addOpenapi(openapi: String): OpenApi {
        if (this.openapi != null) {
            throw IllegalStateException("Field openapi of Entity OpenApi is already set to '${this.openapi}', refused to add new value '$openapi'")
        }
        return setOpenapi(openapi)
    }

    ///////////////////////
    //
    // info
    //
    ///////////////////////

    // hint:3A7F9B2E
    val info: Info?
        get() = _info.orNull

    // hint:F0C48D71
    fun setInfoField(info: Field<Info?>): OpenApi {
        return copy(_info = info)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateInfoField(updater: (Field<Info?>) -> Field<Info?>): OpenApi {
        return setInfoField(updater(_info))
    }

    // hint:B1D730FC
    fun updateInfo(updater: (Info?) -> Info?): OpenApi {
        return updateInfoField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeInfoField(infoFieldToMerge: Field<Info?>): OpenApi {
        return mergeInfo(infoFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeInfo(infoToMerge: Info?): OpenApi {
        return if (infoToMerge == null) {
            this
        } else {
            val oldInfo = _info.orNull
            if (oldInfo == null) {
                setInfoField(Field(infoToMerge))
            } else {
                // hint:E91B4F65
                setInfo(oldInfo.mergeEntity(infoToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setInfo(info: Info?): OpenApi {
        return setInfoField(Field(info))
    }

    // hint:D465F782
    fun unsetInfo(): OpenApi {
        return setInfoField(Field.unset())
    }

    // hint:47C9A0F6
    fun addInfo(info: Info): OpenApi {
        if (this.info != null) {
            throw IllegalStateException("Field info of Entity OpenApi is already set to '${this.info}', refused to add new value '$info'")
        }
        return setInfo(info)
    }

    ///////////////////////
    //
    // externalDocs
    //
    ///////////////////////

    // hint:3A7F9B2E
    val externalDocs: ExternalDocumentation?
        get() = _externalDocs.orNull

    // hint:F0C48D71
    fun setExternalDocsField(externalDocs: Field<ExternalDocumentation?>): OpenApi {
        return copy(_externalDocs = externalDocs)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExternalDocsField(updater: (Field<ExternalDocumentation?>) -> Field<ExternalDocumentation?>): OpenApi {
        return setExternalDocsField(updater(_externalDocs))
    }

    // hint:B1D730FC
    fun updateExternalDocs(updater: (ExternalDocumentation?) -> ExternalDocumentation?): OpenApi {
        return updateExternalDocsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExternalDocsField(externalDocsFieldToMerge: Field<ExternalDocumentation?>): OpenApi {
        return mergeExternalDocs(externalDocsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExternalDocs(externalDocsToMerge: ExternalDocumentation?): OpenApi {
        return if (externalDocsToMerge == null) {
            this
        } else {
            val oldExternalDocs = _externalDocs.orNull
            if (oldExternalDocs == null) {
                setExternalDocsField(Field(externalDocsToMerge))
            } else {
                // hint:E91B4F65
                setExternalDocs(oldExternalDocs.mergeEntity(externalDocsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExternalDocs(externalDocs: ExternalDocumentation?): OpenApi {
        return setExternalDocsField(Field(externalDocs))
    }

    // hint:D465F782
    fun unsetExternalDocs(): OpenApi {
        return setExternalDocsField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExternalDocs(externalDocs: ExternalDocumentation): OpenApi {
        if (this.externalDocs != null) {
            throw IllegalStateException("Field externalDocs of Entity OpenApi is already set to '${this.externalDocs}', refused to add new value '$externalDocs'")
        }
        return setExternalDocs(externalDocs)
    }

    ///////////////////////
    //
    // servers
    //
    ///////////////////////

    // hint:3A7F9B2E
    val servers: List<Server?>?
        get() = _servers.orNull

    // hint:F0C48D71
    fun setServersField(servers: Field<List<Server?>?>): OpenApi {
        return copy(_servers = servers)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateServersField(updater: (Field<List<Server?>?>) -> Field<List<Server?>?>): OpenApi {
        return setServersField(updater(_servers))
    }

    // hint:B1D730FC
    fun updateServers(updater: (List<Server?>?) -> List<Server?>?): OpenApi {
        return updateServersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeServersField(serversFieldToMerge: Field<List<Server?>?>): OpenApi {
        return mergeServers(serversFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeServers(serversToMerge: List<Server?>?): OpenApi {
        return if (serversToMerge == null) {
            this
        } else {
            val oldServers = _servers.orNull
            if (oldServers == null) {
                setServersField(Field(serversToMerge))
            } else {
                // hint:19DE5C87
                setServers((oldServers + serversToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setServers(servers: List<Server?>?): OpenApi {
        return setServersField(Field(servers))
    }

    // hint:D465F782
    fun unsetServers(): OpenApi {
        return setServersField(Field.unset())
    }

    // hint:3E9A8C01
    fun addServers(servers: List<Server?>?): OpenApi {
        return setServers((this.servers ?: emptyList()) + (servers ?: emptyList()))
    }

    // hint:F7420EB5
    fun addServers(vararg servers: Server): OpenApi {
        return addServers(servers.toList())
    }

    ///////////////////////
    //
    // security
    //
    ///////////////////////

    // hint:3A7F9B2E
    val security: List<SecurityRequirement?>?
        get() = _security.orNull

    // hint:F0C48D71
    fun setSecurityField(security: Field<List<SecurityRequirement?>?>): OpenApi {
        return copy(_security = security)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSecurityField(updater: (Field<List<SecurityRequirement?>?>) -> Field<List<SecurityRequirement?>?>): OpenApi {
        return setSecurityField(updater(_security))
    }

    // hint:B1D730FC
    fun updateSecurity(updater: (List<SecurityRequirement?>?) -> List<SecurityRequirement?>?): OpenApi {
        return updateSecurityField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSecurityField(securityFieldToMerge: Field<List<SecurityRequirement?>?>): OpenApi {
        return mergeSecurity(securityFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSecurity(securityToMerge: List<SecurityRequirement?>?): OpenApi {
        return if (securityToMerge == null) {
            this
        } else {
            val oldSecurity = _security.orNull
            if (oldSecurity == null) {
                setSecurityField(Field(securityToMerge))
            } else {
                // hint:19DE5C87
                setSecurity((oldSecurity + securityToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setSecurity(security: List<SecurityRequirement?>?): OpenApi {
        return setSecurityField(Field(security))
    }

    // hint:D465F782
    fun unsetSecurity(): OpenApi {
        return setSecurityField(Field.unset())
    }

    // hint:3E9A8C01
    fun addSecurity(security: List<SecurityRequirement?>?): OpenApi {
        return setSecurity((this.security ?: emptyList()) + (security ?: emptyList()))
    }

    // hint:F7420EB5
    fun addSecurity(vararg security: SecurityRequirement): OpenApi {
        return addSecurity(security.toList())
    }

    ///////////////////////
    //
    // tags
    //
    ///////////////////////

    // hint:3A7F9B2E
    val tags: List<Tag?>?
        get() = _tags.orNull

    // hint:F0C48D71
    fun setTagsField(tags: Field<List<Tag?>?>): OpenApi {
        return copy(_tags = tags)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateTagsField(updater: (Field<List<Tag?>?>) -> Field<List<Tag?>?>): OpenApi {
        return setTagsField(updater(_tags))
    }

    // hint:B1D730FC
    fun updateTags(updater: (List<Tag?>?) -> List<Tag?>?): OpenApi {
        return updateTagsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeTagsField(tagsFieldToMerge: Field<List<Tag?>?>): OpenApi {
        return mergeTags(tagsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeTags(tagsToMerge: List<Tag?>?): OpenApi {
        return if (tagsToMerge == null) {
            this
        } else {
            val oldTags = _tags.orNull
            if (oldTags == null) {
                setTagsField(Field(tagsToMerge))
            } else {
                // hint:19DE5C87
                setTags((oldTags + tagsToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setTags(tags: List<Tag?>?): OpenApi {
        return setTagsField(Field(tags))
    }

    // hint:D465F782
    fun unsetTags(): OpenApi {
        return setTagsField(Field.unset())
    }

    // hint:3E9A8C01
    fun addTags(tags: List<Tag?>?): OpenApi {
        return setTags((this.tags ?: emptyList()) + (tags ?: emptyList()))
    }

    // hint:F7420EB5
    fun addTags(vararg tags: Tag): OpenApi {
        return addTags(tags.toList())
    }

    ///////////////////////
    //
    // paths
    //
    ///////////////////////

    // hint:3A7F9B2E
    val paths: Paths?
        get() = _paths.orNull

    // hint:F0C48D71
    fun setPathsField(paths: Field<Paths?>): OpenApi {
        return copy(_paths = paths)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updatePathsField(updater: (Field<Paths?>) -> Field<Paths?>): OpenApi {
        return setPathsField(updater(_paths))
    }

    // hint:B1D730FC
    fun updatePaths(updater: (Paths?) -> Paths?): OpenApi {
        return updatePathsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergePathsField(pathsFieldToMerge: Field<Paths?>): OpenApi {
        return mergePaths(pathsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergePaths(pathsToMerge: Paths?): OpenApi {
        return if (pathsToMerge == null) {
            this
        } else {
            val oldPaths = _paths.orNull
            if (oldPaths == null) {
                setPathsField(Field(pathsToMerge))
            } else {
                // hint:E91B4F65
                setPaths(oldPaths.mergeEntity(pathsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setPaths(paths: Paths?): OpenApi {
        return setPathsField(Field(paths))
    }

    // hint:D465F782
    fun unsetPaths(): OpenApi {
        return setPathsField(Field.unset())
    }

    // hint:47C9A0F6
    fun addPaths(paths: Paths): OpenApi {
        if (this.paths != null) {
            throw IllegalStateException("Field paths of Entity OpenApi is already set to '${this.paths}', refused to add new value '$paths'")
        }
        return setPaths(paths)
    }

    ///////////////////////
    //
    // components
    //
    ///////////////////////

    // hint:3A7F9B2E
    val components: Components?
        get() = _components.orNull

    // hint:F0C48D71
    fun setComponentsField(components: Field<Components?>): OpenApi {
        return copy(_components = components)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateComponentsField(updater: (Field<Components?>) -> Field<Components?>): OpenApi {
        return setComponentsField(updater(_components))
    }

    // hint:B1D730FC
    fun updateComponents(updater: (Components?) -> Components?): OpenApi {
        return updateComponentsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeComponentsField(componentsFieldToMerge: Field<Components?>): OpenApi {
        return mergeComponents(componentsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeComponents(componentsToMerge: Components?): OpenApi {
        return if (componentsToMerge == null) {
            this
        } else {
            val oldComponents = _components.orNull
            if (oldComponents == null) {
                setComponentsField(Field(componentsToMerge))
            } else {
                // hint:E91B4F65
                setComponents(oldComponents.mergeEntity(componentsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setComponents(components: Components?): OpenApi {
        return setComponentsField(Field(components))
    }

    // hint:D465F782
    fun unsetComponents(): OpenApi {
        return setComponentsField(Field.unset())
    }

    // hint:47C9A0F6
    fun addComponents(components: Components): OpenApi {
        if (this.components != null) {
            throw IllegalStateException("Field components of Entity OpenApi is already set to '${this.components}', refused to add new value '$components'")
        }
        return setComponents(components)
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): OpenApi {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): OpenApi {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): OpenApi {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): OpenApi {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): OpenApi {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): OpenApi {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): OpenApi {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): OpenApi {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): OpenApi {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): OpenApi {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): OpenApi {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "openapi" to _openapi,
                "info" to _info,
                "externalDocs" to _externalDocs,
                "servers" to _servers,
                "security" to _security,
                "tags" to _tags,
                "paths" to _paths,
                "components" to _components,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_openapi.isDefined) Fields.openapi else null,
                if (_info.isDefined) Fields.info else null,
                if (_externalDocs.isDefined) Fields.externalDocs else null,
                if (_servers.isDefined) Fields.servers else null,
                if (_security.isDefined) Fields.security else null,
                if (_tags.isDefined) Fields.tags else null,
                if (_paths.isDefined) Fields.paths else null,
                if (_components.isDefined) Fields.components else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): OpenApi {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): OpenApi {
        return when (other) {
            null ->
                this

            is OpenApi ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: OpenApi): OpenApi {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: OpenApi?): OpenApi {
        if (other == null) return this
        return this
            .mergeOpenapiField(other._openapi)
            .mergeInfoField(other._info)
            .mergeExternalDocsField(other._externalDocs)
            .mergeServersField(other._servers)
            .mergeSecurityField(other._security)
            .mergeTagsField(other._tags)
            .mergePathsField(other._paths)
            .mergeComponentsField(other._components)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    companion object : Parser<OpenApi> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val openapi = Fields("openapi")
                val info = Fields("info")
                val externalDocs = Fields("externalDocs")
                val servers = Fields("servers")
                val security = Fields("security")
                val tags = Fields("tags")
                val paths = Fields("paths")
                val components = Fields("components")
                val all: Set<Fields> = setOf(
                    openapi,
                    info,
                    externalDocs,
                    servers,
                    security,
                    tags,
                    paths,
                    components,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<OpenApi>(OpenApi::class.java, OpenApi)
        class Deserializer : EntityDeserializer<OpenApi>(OpenApi::class.java, OpenApi)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): OpenApi {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): OpenApi {
            return OpenApi(
                _openapi = wrapper["openapi"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _info = wrapper["info"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Info::parseEntityOpt)
                        }
                    }
                },
                _externalDocs = wrapper["externalDocs"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(ExternalDocumentation::parseEntityOpt)
                        }
                    }
                },
                _servers = wrapper["servers"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(Server::parseEntityOpt)
                        }
                    }
                },
                _security = wrapper["security"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(SecurityRequirement::parseEntityOpt)
                        }
                    }
                },
                _tags = wrapper["tags"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(Tag::parseEntityOpt)
                        }
                    }
                },
                _paths = wrapper["paths"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Paths::parseEntityOpt)
                        }
                    }
                },
                _components = wrapper["components"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Components::parseEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
