/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.Parser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = Operation.Companion.Serializer::class)
@JsonDeserialize(using = Operation.Companion.Deserializer::class)
data class Operation(
    val _tags: Field<List<String?>?> = Field.unset(),
    val _summary: Field<String?> = Field.unset(),
    val _description: Field<String?> = Field.unset(),
    val _externalDocs: Field<ExternalDocumentation?> = Field.unset(),
    val _operationId: Field<String?> = Field.unset(),
    val _parameters: Field<List<ReferenceOrInstance<Parameter>?>?> = Field.unset(),
    val _requestBody: Field<ReferenceOrInstance<RequestBody>?> = Field.unset(),
    val _responses: Field<Responses?> = Field.unset(),
    val _callbacks: Field<Map<String, ReferenceOrInstance<Callback>?>?> = Field.unset(),
    val _deprecated: Field<Boolean> = Field.unset(),
    val _security: Field<List<SecurityRequirement?>?> = Field.unset(),
    val _servers: Field<List<Server?>?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
) : Entity {

    ///////////////////////
    //
    // tags
    //
    ///////////////////////

    // hint:3A7F9B2E
    val tags: List<String?>?
        get() = _tags.orNull

    // hint:F0C48D71
    fun setTagsField(tags: Field<List<String?>?>): Operation {
        return copy(_tags = tags)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateTagsField(updater: (Field<List<String?>?>) -> Field<List<String?>?>): Operation {
        return setTagsField(updater(_tags))
    }

    // hint:B1D730FC
    fun updateTags(updater: (List<String?>?) -> List<String?>?): Operation {
        return updateTagsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeTagsField(tagsFieldToMerge: Field<List<String?>?>): Operation {
        return mergeTags(tagsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeTags(tagsToMerge: List<String?>?): Operation {
        return if (tagsToMerge == null) {
            this
        } else {
            val oldTags = _tags.orNull
            if (oldTags == null) {
                setTagsField(Field(tagsToMerge))
            } else {
                // hint:19DE5C87
                setTags((oldTags + tagsToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setTags(tags: List<String?>?): Operation {
        return setTagsField(Field(tags))
    }

    // hint:D465F782
    fun unsetTags(): Operation {
        return setTagsField(Field.unset())
    }

    // hint:3E9A8C01
    fun addTags(tags: List<String?>?): Operation {
        return setTags((this.tags ?: emptyList()) + (tags ?: emptyList()))
    }

    // hint:F7420EB5
    fun addTags(vararg tags: String): Operation {
        return addTags(tags.toList())
    }

    ///////////////////////
    //
    // summary
    //
    ///////////////////////

    // hint:3A7F9B2E
    val summary: String?
        get() = _summary.orNull

    // hint:F0C48D71
    fun setSummaryField(summary: Field<String?>): Operation {
        return copy(_summary = summary)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSummaryField(updater: (Field<String?>) -> Field<String?>): Operation {
        return setSummaryField(updater(_summary))
    }

    // hint:B1D730FC
    fun updateSummary(updater: (String?) -> String?): Operation {
        return updateSummaryField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSummaryField(summaryFieldToMerge: Field<String?>): Operation {
        return mergeSummary(summaryFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSummary(summaryToMerge: String?): Operation {
        return if (summaryToMerge == null) {
            this
        } else {
            val oldSummary = _summary.orNull
            if (oldSummary == null) {
                setSummaryField(Field(summaryToMerge))
            } else {
                // hint:2F684DAC
                setSummary(summaryToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setSummary(summary: String?): Operation {
        return setSummaryField(Field(summary))
    }

    // hint:D465F782
    fun unsetSummary(): Operation {
        return setSummaryField(Field.unset())
    }

    // hint:47C9A0F6
    fun addSummary(summary: String): Operation {
        if (this.summary != null) {
            throw IllegalStateException("Field summary of Entity Operation is already set to '${this.summary}', refused to add new value '$summary'")
        }
        return setSummary(summary)
    }

    ///////////////////////
    //
    // description
    //
    ///////////////////////

    // hint:3A7F9B2E
    val description: String?
        get() = _description.orNull

    // hint:F0C48D71
    fun setDescriptionField(description: Field<String?>): Operation {
        return copy(_description = description)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDescriptionField(updater: (Field<String?>) -> Field<String?>): Operation {
        return setDescriptionField(updater(_description))
    }

    // hint:B1D730FC
    fun updateDescription(updater: (String?) -> String?): Operation {
        return updateDescriptionField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDescriptionField(descriptionFieldToMerge: Field<String?>): Operation {
        return mergeDescription(descriptionFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDescription(descriptionToMerge: String?): Operation {
        return if (descriptionToMerge == null) {
            this
        } else {
            val oldDescription = _description.orNull
            if (oldDescription == null) {
                setDescriptionField(Field(descriptionToMerge))
            } else {
                // hint:2F684DAC
                setDescription(descriptionToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDescription(description: String?): Operation {
        return setDescriptionField(Field(description))
    }

    // hint:D465F782
    fun unsetDescription(): Operation {
        return setDescriptionField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDescription(description: String): Operation {
        if (this.description != null) {
            throw IllegalStateException("Field description of Entity Operation is already set to '${this.description}', refused to add new value '$description'")
        }
        return setDescription(description)
    }

    ///////////////////////
    //
    // externalDocs
    //
    ///////////////////////

    // hint:3A7F9B2E
    val externalDocs: ExternalDocumentation?
        get() = _externalDocs.orNull

    // hint:F0C48D71
    fun setExternalDocsField(externalDocs: Field<ExternalDocumentation?>): Operation {
        return copy(_externalDocs = externalDocs)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExternalDocsField(updater: (Field<ExternalDocumentation?>) -> Field<ExternalDocumentation?>): Operation {
        return setExternalDocsField(updater(_externalDocs))
    }

    // hint:B1D730FC
    fun updateExternalDocs(updater: (ExternalDocumentation?) -> ExternalDocumentation?): Operation {
        return updateExternalDocsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExternalDocsField(externalDocsFieldToMerge: Field<ExternalDocumentation?>): Operation {
        return mergeExternalDocs(externalDocsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExternalDocs(externalDocsToMerge: ExternalDocumentation?): Operation {
        return if (externalDocsToMerge == null) {
            this
        } else {
            val oldExternalDocs = _externalDocs.orNull
            if (oldExternalDocs == null) {
                setExternalDocsField(Field(externalDocsToMerge))
            } else {
                // hint:E91B4F65
                setExternalDocs(oldExternalDocs.mergeEntity(externalDocsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExternalDocs(externalDocs: ExternalDocumentation?): Operation {
        return setExternalDocsField(Field(externalDocs))
    }

    // hint:D465F782
    fun unsetExternalDocs(): Operation {
        return setExternalDocsField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExternalDocs(externalDocs: ExternalDocumentation): Operation {
        if (this.externalDocs != null) {
            throw IllegalStateException("Field externalDocs of Entity Operation is already set to '${this.externalDocs}', refused to add new value '$externalDocs'")
        }
        return setExternalDocs(externalDocs)
    }

    ///////////////////////
    //
    // operationId
    //
    ///////////////////////

    // hint:3A7F9B2E
    val operationId: String?
        get() = _operationId.orNull

    // hint:F0C48D71
    fun setOperationIdField(operationId: Field<String?>): Operation {
        return copy(_operationId = operationId)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateOperationIdField(updater: (Field<String?>) -> Field<String?>): Operation {
        return setOperationIdField(updater(_operationId))
    }

    // hint:B1D730FC
    fun updateOperationId(updater: (String?) -> String?): Operation {
        return updateOperationIdField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeOperationIdField(operationIdFieldToMerge: Field<String?>): Operation {
        return mergeOperationId(operationIdFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeOperationId(operationIdToMerge: String?): Operation {
        return if (operationIdToMerge == null) {
            this
        } else {
            val oldOperationId = _operationId.orNull
            if (oldOperationId == null) {
                setOperationIdField(Field(operationIdToMerge))
            } else {
                // hint:2F684DAC
                setOperationId(operationIdToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setOperationId(operationId: String?): Operation {
        return setOperationIdField(Field(operationId))
    }

    // hint:D465F782
    fun unsetOperationId(): Operation {
        return setOperationIdField(Field.unset())
    }

    // hint:47C9A0F6
    fun addOperationId(operationId: String): Operation {
        if (this.operationId != null) {
            throw IllegalStateException("Field operationId of Entity Operation is already set to '${this.operationId}', refused to add new value '$operationId'")
        }
        return setOperationId(operationId)
    }

    ///////////////////////
    //
    // parameters
    //
    ///////////////////////

    // hint:3A7F9B2E
    val parameters: List<ReferenceOrInstance<Parameter>?>?
        get() = _parameters.orNull

    // hint:F0C48D71
    fun setParametersField(parameters: Field<List<ReferenceOrInstance<Parameter>?>?>): Operation {
        return copy(_parameters = parameters)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateParametersField(updater: (Field<List<ReferenceOrInstance<Parameter>?>?>) -> Field<List<ReferenceOrInstance<Parameter>?>?>): Operation {
        return setParametersField(updater(_parameters))
    }

    // hint:B1D730FC
    fun updateParameters(updater: (List<ReferenceOrInstance<Parameter>?>?) -> List<ReferenceOrInstance<Parameter>?>?): Operation {
        return updateParametersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeParametersField(parametersFieldToMerge: Field<List<ReferenceOrInstance<Parameter>?>?>): Operation {
        return mergeParameters(parametersFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeParameters(parametersToMerge: List<ReferenceOrInstance<Parameter>?>?): Operation {
        return if (parametersToMerge == null) {
            this
        } else {
            val oldParameters = _parameters.orNull
            if (oldParameters == null) {
                setParametersField(Field(parametersToMerge))
            } else {
                // hint:19DE5C87
                setParameters((oldParameters + parametersToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setParameters(parameters: List<ReferenceOrInstance<Parameter>?>?): Operation {
        return setParametersField(Field(parameters))
    }

    // hint:D465F782
    fun unsetParameters(): Operation {
        return setParametersField(Field.unset())
    }

    // hint:85F37E6D
    @JvmName("addParametersList")
    fun addParameters(parameters: List<Parameter>): Operation {
        return addParameters(parameters.map(::Instance).toList())
    }

    // hint:47D2AFC8
    fun addParameters(vararg parameters: Parameter): Operation {
        return addParameters(parameters.toList())
    }

    // hint:12B6C4A3
    @JvmName("addParametersArray")
    fun addParameters(parameters: Array<out Parameter>): Operation {
        return addParameters(parameters.toList())
    }

    // hint:3E9A8C01
    fun addParameters(parameters: List<ReferenceOrInstance<Parameter>?>?): Operation {
        return setParameters((this.parameters ?: emptyList()) + (parameters ?: emptyList()))
    }

    // hint:F7420EB5
    fun addParameters(vararg parameters: ReferenceOrInstance<Parameter>): Operation {
        return addParameters(parameters.toList())
    }

    ///////////////////////
    //
    // requestBody
    //
    ///////////////////////

    // hint:3A7F9B2E
    val requestBody: ReferenceOrInstance<RequestBody>?
        get() = _requestBody.orNull

    // hint:F0C48D71
    fun setRequestBodyField(requestBody: Field<ReferenceOrInstance<RequestBody>?>): Operation {
        return copy(_requestBody = requestBody)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateRequestBodyField(updater: (Field<ReferenceOrInstance<RequestBody>?>) -> Field<ReferenceOrInstance<RequestBody>?>): Operation {
        return setRequestBodyField(updater(_requestBody))
    }

    // hint:B1D730FC
    fun updateRequestBody(updater: (ReferenceOrInstance<RequestBody>?) -> ReferenceOrInstance<RequestBody>?): Operation {
        return updateRequestBodyField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeRequestBodyField(requestBodyFieldToMerge: Field<ReferenceOrInstance<RequestBody>?>): Operation {
        return mergeRequestBody(requestBodyFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeRequestBody(requestBodyToMerge: ReferenceOrInstance<RequestBody>?): Operation {
        return if (requestBodyToMerge == null) {
            this
        } else {
            val oldRequestBody = _requestBody.orNull
            if (oldRequestBody == null) {
                setRequestBodyField(Field(requestBodyToMerge))
            } else {
                // hint:2F684DAC
                setRequestBody(requestBodyToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setRequestBody(requestBody: ReferenceOrInstance<RequestBody>?): Operation {
        return setRequestBodyField(Field(requestBody))
    }

    // hint:D465F782
    fun unsetRequestBody(): Operation {
        return setRequestBodyField(Field.unset())
    }

    // hint:F8E61D9B
    fun addRequestBody(requestBody: RequestBody): Operation {
        return addRequestBody(Instance(requestBody))
    }

    // hint:47C9A0F6
    fun addRequestBody(requestBody: ReferenceOrInstance<RequestBody>): Operation {
        if (this.requestBody != null) {
            throw IllegalStateException("Field requestBody of Entity Operation is already set to '${this.requestBody}', refused to add new value '$requestBody'")
        }
        return setRequestBody(requestBody)
    }

    ///////////////////////
    //
    // responses
    //
    ///////////////////////

    // hint:3A7F9B2E
    val responses: Responses?
        get() = _responses.orNull

    // hint:F0C48D71
    fun setResponsesField(responses: Field<Responses?>): Operation {
        return copy(_responses = responses)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateResponsesField(updater: (Field<Responses?>) -> Field<Responses?>): Operation {
        return setResponsesField(updater(_responses))
    }

    // hint:B1D730FC
    fun updateResponses(updater: (Responses?) -> Responses?): Operation {
        return updateResponsesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeResponsesField(responsesFieldToMerge: Field<Responses?>): Operation {
        return mergeResponses(responsesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeResponses(responsesToMerge: Responses?): Operation {
        return if (responsesToMerge == null) {
            this
        } else {
            val oldResponses = _responses.orNull
            if (oldResponses == null) {
                setResponsesField(Field(responsesToMerge))
            } else {
                // hint:E91B4F65
                setResponses(oldResponses.mergeEntity(responsesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setResponses(responses: Responses?): Operation {
        return setResponsesField(Field(responses))
    }

    // hint:D465F782
    fun unsetResponses(): Operation {
        return setResponsesField(Field.unset())
    }

    // hint:47C9A0F6
    fun addResponses(responses: Responses): Operation {
        if (this.responses != null) {
            throw IllegalStateException("Field responses of Entity Operation is already set to '${this.responses}', refused to add new value '$responses'")
        }
        return setResponses(responses)
    }

    ///////////////////////
    //
    // callbacks
    //
    ///////////////////////

    // hint:3A7F9B2E
    val callbacks: Map<String, ReferenceOrInstance<Callback>?>?
        get() = _callbacks.orNull

    // hint:F0C48D71
    fun setCallbacksField(callbacks: Field<Map<String, ReferenceOrInstance<Callback>?>?>): Operation {
        return copy(_callbacks = callbacks)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateCallbacksField(updater: (Field<Map<String, ReferenceOrInstance<Callback>?>?>) -> Field<Map<String, ReferenceOrInstance<Callback>?>?>): Operation {
        return setCallbacksField(updater(_callbacks))
    }

    // hint:B1D730FC
    fun updateCallbacks(updater: (Map<String, ReferenceOrInstance<Callback>?>?) -> Map<String, ReferenceOrInstance<Callback>?>?): Operation {
        return updateCallbacksField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeCallbacksField(callbacksFieldToMerge: Field<Map<String, ReferenceOrInstance<Callback>?>?>): Operation {
        return mergeCallbacks(callbacksFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeCallbacks(callbacksToMerge: Map<String, ReferenceOrInstance<Callback>?>?): Operation {
        return if (callbacksToMerge == null) {
            this
        } else {
            val oldCallbacks = _callbacks.orNull
            if (oldCallbacks == null) {
                setCallbacksField(Field(callbacksToMerge))
            } else {
                // hint:70A3D8B6
                setCallbacks(de.lancom.openapi.parser.util.mergeMap(oldCallbacks, callbacksToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setCallbacks(callbacks: Map<String, ReferenceOrInstance<Callback>?>?): Operation {
        return setCallbacksField(Field(callbacks))
    }

    // hint:D465F782
    fun unsetCallbacks(): Operation {
        return setCallbacksField(Field.unset())
    }

    // hint:5C81D396
    fun addCallbacks(callbacks: Map<String, ReferenceOrInstance<Callback>?>?): Operation {
        return mergeCallbacks(callbacks)
    }

    // hint:1A6B37F8
    fun addCallbacks(vararg callbacks: Pair<String, ReferenceOrInstance<Callback>?>): Operation {
        return addCallbacks(callbacks.toMap())
    }

    // hint:9D0E4CA5
    fun addCallback(key: String, value: ReferenceOrInstance<Callback>?): Operation {
        return addCallbacks(key to value)
    }

    // hint:B8F25E73
    fun addCallback(pair: Pair<String, ReferenceOrInstance<Callback>?>): Operation {
        return addCallbacks(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addCallback(key: String, value: Callback): Operation {
        return addCallbacks(key to Instance(value))
    }

    ///////////////////////
    //
    // deprecated
    //
    ///////////////////////

    // hint:3A7F9B2E
    val deprecated: Boolean
        get() = _deprecated.orNull ?: false

    // hint:F0C48D71
    fun setDeprecatedField(deprecated: Field<Boolean>): Operation {
        return copy(_deprecated = deprecated)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDeprecatedField(updater: (Field<Boolean>) -> Field<Boolean>): Operation {
        return setDeprecatedField(updater(_deprecated))
    }

    // hint:B1D730FC
    fun updateDeprecated(updater: (Boolean) -> Boolean): Operation {
        return updateDeprecatedField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDeprecatedField(deprecatedFieldToMerge: Field<Boolean>): Operation {
        return mergeDeprecated(deprecatedFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDeprecated(deprecatedToMerge: Boolean?): Operation {
        return if (deprecatedToMerge == null) {
            this
        } else {
            val oldDeprecated = _deprecated.orNull
            if (oldDeprecated == null) {
                setDeprecatedField(Field(deprecatedToMerge))
            } else {
                // hint:2F684DAC
                setDeprecated(deprecatedToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDeprecated(deprecated: Boolean): Operation {
        return setDeprecatedField(Field(deprecated))
    }

    // hint:D465F782
    fun unsetDeprecated(): Operation {
        return setDeprecatedField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDeprecated(deprecated: Boolean = true): Operation {
        return setDeprecated(deprecated)
    }

    ///////////////////////
    //
    // security
    //
    ///////////////////////

    // hint:3A7F9B2E
    val security: List<SecurityRequirement?>?
        get() = _security.orNull

    // hint:F0C48D71
    fun setSecurityField(security: Field<List<SecurityRequirement?>?>): Operation {
        return copy(_security = security)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSecurityField(updater: (Field<List<SecurityRequirement?>?>) -> Field<List<SecurityRequirement?>?>): Operation {
        return setSecurityField(updater(_security))
    }

    // hint:B1D730FC
    fun updateSecurity(updater: (List<SecurityRequirement?>?) -> List<SecurityRequirement?>?): Operation {
        return updateSecurityField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSecurityField(securityFieldToMerge: Field<List<SecurityRequirement?>?>): Operation {
        return mergeSecurity(securityFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSecurity(securityToMerge: List<SecurityRequirement?>?): Operation {
        return if (securityToMerge == null) {
            this
        } else {
            val oldSecurity = _security.orNull
            if (oldSecurity == null) {
                setSecurityField(Field(securityToMerge))
            } else {
                // hint:19DE5C87
                setSecurity((oldSecurity + securityToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setSecurity(security: List<SecurityRequirement?>?): Operation {
        return setSecurityField(Field(security))
    }

    // hint:D465F782
    fun unsetSecurity(): Operation {
        return setSecurityField(Field.unset())
    }

    // hint:3E9A8C01
    fun addSecurity(security: List<SecurityRequirement?>?): Operation {
        return setSecurity((this.security ?: emptyList()) + (security ?: emptyList()))
    }

    // hint:F7420EB5
    fun addSecurity(vararg security: SecurityRequirement): Operation {
        return addSecurity(security.toList())
    }

    ///////////////////////
    //
    // servers
    //
    ///////////////////////

    // hint:3A7F9B2E
    val servers: List<Server?>?
        get() = _servers.orNull

    // hint:F0C48D71
    fun setServersField(servers: Field<List<Server?>?>): Operation {
        return copy(_servers = servers)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateServersField(updater: (Field<List<Server?>?>) -> Field<List<Server?>?>): Operation {
        return setServersField(updater(_servers))
    }

    // hint:B1D730FC
    fun updateServers(updater: (List<Server?>?) -> List<Server?>?): Operation {
        return updateServersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeServersField(serversFieldToMerge: Field<List<Server?>?>): Operation {
        return mergeServers(serversFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeServers(serversToMerge: List<Server?>?): Operation {
        return if (serversToMerge == null) {
            this
        } else {
            val oldServers = _servers.orNull
            if (oldServers == null) {
                setServersField(Field(serversToMerge))
            } else {
                // hint:19DE5C87
                setServers((oldServers + serversToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setServers(servers: List<Server?>?): Operation {
        return setServersField(Field(servers))
    }

    // hint:D465F782
    fun unsetServers(): Operation {
        return setServersField(Field.unset())
    }

    // hint:3E9A8C01
    fun addServers(servers: List<Server?>?): Operation {
        return setServers((this.servers ?: emptyList()) + (servers ?: emptyList()))
    }

    // hint:F7420EB5
    fun addServers(vararg servers: Server): Operation {
        return addServers(servers.toList())
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): Operation {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): Operation {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): Operation {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): Operation {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): Operation {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): Operation {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): Operation {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): Operation {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): Operation {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): Operation {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): Operation {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "tags" to _tags,
                "summary" to _summary,
                "description" to _description,
                "externalDocs" to _externalDocs,
                "operationId" to _operationId,
                "parameters" to _parameters,
                "requestBody" to _requestBody,
                "responses" to _responses,
                "callbacks" to _callbacks,
                "deprecated" to _deprecated,
                "security" to _security,
                "servers" to _servers,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_tags.isDefined) Fields.tags else null,
                if (_summary.isDefined) Fields.summary else null,
                if (_description.isDefined) Fields.description else null,
                if (_externalDocs.isDefined) Fields.externalDocs else null,
                if (_operationId.isDefined) Fields.operationId else null,
                if (_parameters.isDefined) Fields.parameters else null,
                if (_requestBody.isDefined) Fields.requestBody else null,
                if (_responses.isDefined) Fields.responses else null,
                if (_callbacks.isDefined) Fields.callbacks else null,
                if (_deprecated.isDefined) Fields.deprecated else null,
                if (_security.isDefined) Fields.security else null,
                if (_servers.isDefined) Fields.servers else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): Operation {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): Operation {
        return when (other) {
            null ->
                this

            is Operation ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: Operation): Operation {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: Operation?): Operation {
        if (other == null) return this
        return this
            .mergeTagsField(other._tags)
            .mergeSummaryField(other._summary)
            .mergeDescriptionField(other._description)
            .mergeExternalDocsField(other._externalDocs)
            .mergeOperationIdField(other._operationId)
            .mergeParametersField(other._parameters)
            .mergeRequestBodyField(other._requestBody)
            .mergeResponsesField(other._responses)
            .mergeCallbacksField(other._callbacks)
            .mergeDeprecatedField(other._deprecated)
            .mergeSecurityField(other._security)
            .mergeServersField(other._servers)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    companion object : Parser<Operation> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val tags = Fields("tags")
                val summary = Fields("summary")
                val description = Fields("description")
                val externalDocs = Fields("externalDocs")
                val operationId = Fields("operationId")
                val parameters = Fields("parameters")
                val requestBody = Fields("requestBody")
                val responses = Fields("responses")
                val callbacks = Fields("callbacks")
                val deprecated = Fields("deprecated")
                val security = Fields("security")
                val servers = Fields("servers")
                val all: Set<Fields> = setOf(
                    tags,
                    summary,
                    description,
                    externalDocs,
                    operationId,
                    parameters,
                    requestBody,
                    responses,
                    callbacks,
                    deprecated,
                    security,
                    servers,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<Operation>(Operation::class.java, Operation)
        class Deserializer : EntityDeserializer<Operation>(Operation::class.java, Operation)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): Operation {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): Operation {
            return Operation(
                _tags = wrapper["tags"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getString()
                        }
                    }
                },
                _summary = wrapper["summary"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _description = wrapper["description"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _externalDocs = wrapper["externalDocs"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(ExternalDocumentation::parseEntityOpt)
                        }
                    }
                },
                _operationId = wrapper["operationId"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _parameters = wrapper["parameters"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(Parameter::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _requestBody = wrapper["requestBody"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(RequestBody::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _responses = wrapper["responses"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Responses::parseEntityOpt)
                        }
                    }
                },
                _callbacks = wrapper["callbacks"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Callback::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _deprecated = wrapper["deprecated"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _security = wrapper["security"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(SecurityRequirement::parseEntityOpt)
                        }
                    }
                },
                _servers = wrapper["servers"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(Server::parseEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
