/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.ReferenceParser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance
import de.lancom.openapi.parser.ref.Referenceable

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = Parameter.Companion.Serializer::class)
@JsonDeserialize(using = Parameter.Companion.Deserializer::class)
data class Parameter(
    val _name: Field<String?> = Field.unset(),
    val _in: Field<In?> = Field.unset(),
    val _description: Field<String?> = Field.unset(),
    val _required: Field<Boolean> = Field.unset(),
    val _deprecated: Field<Boolean> = Field.unset(),
    val _allowEmptyValue: Field<Boolean> = Field.unset(),
    val _style: Field<String?> = Field.unset(),
    val _explode: Field<Boolean?> = Field.unset(),
    val _allowReserved: Field<Boolean> = Field.unset(),
    val _schema: Field<ReferenceOrInstance<Schema>?> = Field.unset(),
    val _content: Field<Map<String, MediaType?>?> = Field.unset(),
    val _example: Field<ExampleJson?> = Field.unset(),
    val _examples: Field<Map<String, ReferenceOrInstance<Example>?>?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
    override val __referenceName: String? = null,
) : Referenceable {

    ///////////////////////
    //
    // name
    //
    ///////////////////////

    // hint:3A7F9B2E
    val name: String?
        get() = _name.orNull

    // hint:F0C48D71
    fun setNameField(name: Field<String?>): Parameter {
        return copy(_name = name)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateNameField(updater: (Field<String?>) -> Field<String?>): Parameter {
        return setNameField(updater(_name))
    }

    // hint:B1D730FC
    fun updateName(updater: (String?) -> String?): Parameter {
        return updateNameField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeNameField(nameFieldToMerge: Field<String?>): Parameter {
        return mergeName(nameFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeName(nameToMerge: String?): Parameter {
        return if (nameToMerge == null) {
            this
        } else {
            val oldName = _name.orNull
            if (oldName == null) {
                setNameField(Field(nameToMerge))
            } else {
                // hint:2F684DAC
                setName(nameToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setName(name: String?): Parameter {
        return setNameField(Field(name))
    }

    // hint:D465F782
    fun unsetName(): Parameter {
        return setNameField(Field.unset())
    }

    // hint:47C9A0F6
    fun addName(name: String): Parameter {
        if (this.name != null) {
            throw IllegalStateException("Field name of Entity Parameter is already set to '${this.name}', refused to add new value '$name'")
        }
        return setName(name)
    }

    ///////////////////////
    //
    // in
    //
    ///////////////////////

    // hint:3A7F9B2E
    val `in`: In?
        get() = _in.orNull

    // hint:F0C48D71
    fun setInField(`in`: Field<In?>): Parameter {
        return copy(_in = `in`)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateInField(updater: (Field<In?>) -> Field<In?>): Parameter {
        return setInField(updater(_in))
    }

    // hint:B1D730FC
    fun updateIn(updater: (In?) -> In?): Parameter {
        return updateInField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeInField(inFieldToMerge: Field<In?>): Parameter {
        return mergeIn(inFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeIn(inToMerge: In?): Parameter {
        return if (inToMerge == null) {
            this
        } else {
            val oldIn = _in.orNull
            if (oldIn == null) {
                setInField(Field(inToMerge))
            } else {
                // hint:2F684DAC
                setIn(inToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setIn(`in`: In?): Parameter {
        return setInField(Field(`in`))
    }

    // hint:D465F782
    fun unsetIn(): Parameter {
        return setInField(Field.unset())
    }

    // hint:47C9A0F6
    fun addIn(`in`: In): Parameter {
        if (this.`in` != null) {
            throw IllegalStateException("Field in of Entity Parameter is already set to '${this.`in`}', refused to add new value '$`in`'")
        }
        return setIn(`in`)
    }

    // hint:E3AF607D
    fun setInPath(): Parameter {
        return setIn(In.Path)
    }

    // hint:3D98E6A5
    fun addInPath(): Parameter {
        return addIn(In.Path)
    }

    // hint:E3AF607D
    fun setInQuery(): Parameter {
        return setIn(In.Query)
    }

    // hint:3D98E6A5
    fun addInQuery(): Parameter {
        return addIn(In.Query)
    }

    // hint:E3AF607D
    fun setInHeader(): Parameter {
        return setIn(In.Header)
    }

    // hint:3D98E6A5
    fun addInHeader(): Parameter {
        return addIn(In.Header)
    }

    // hint:E3AF607D
    fun setInCookie(): Parameter {
        return setIn(In.Cookie)
    }

    // hint:3D98E6A5
    fun addInCookie(): Parameter {
        return addIn(In.Cookie)
    }

    ///////////////////////
    //
    // description
    //
    ///////////////////////

    // hint:3A7F9B2E
    val description: String?
        get() = _description.orNull

    // hint:F0C48D71
    fun setDescriptionField(description: Field<String?>): Parameter {
        return copy(_description = description)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDescriptionField(updater: (Field<String?>) -> Field<String?>): Parameter {
        return setDescriptionField(updater(_description))
    }

    // hint:B1D730FC
    fun updateDescription(updater: (String?) -> String?): Parameter {
        return updateDescriptionField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDescriptionField(descriptionFieldToMerge: Field<String?>): Parameter {
        return mergeDescription(descriptionFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDescription(descriptionToMerge: String?): Parameter {
        return if (descriptionToMerge == null) {
            this
        } else {
            val oldDescription = _description.orNull
            if (oldDescription == null) {
                setDescriptionField(Field(descriptionToMerge))
            } else {
                // hint:2F684DAC
                setDescription(descriptionToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDescription(description: String?): Parameter {
        return setDescriptionField(Field(description))
    }

    // hint:D465F782
    fun unsetDescription(): Parameter {
        return setDescriptionField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDescription(description: String): Parameter {
        if (this.description != null) {
            throw IllegalStateException("Field description of Entity Parameter is already set to '${this.description}', refused to add new value '$description'")
        }
        return setDescription(description)
    }

    ///////////////////////
    //
    // required
    //
    ///////////////////////

    // hint:3A7F9B2E
    val required: Boolean
        get() = _required.orNull ?: false

    // hint:F0C48D71
    fun setRequiredField(required: Field<Boolean>): Parameter {
        return copy(_required = required)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateRequiredField(updater: (Field<Boolean>) -> Field<Boolean>): Parameter {
        return setRequiredField(updater(_required))
    }

    // hint:B1D730FC
    fun updateRequired(updater: (Boolean) -> Boolean): Parameter {
        return updateRequiredField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeRequiredField(requiredFieldToMerge: Field<Boolean>): Parameter {
        return mergeRequired(requiredFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeRequired(requiredToMerge: Boolean?): Parameter {
        return if (requiredToMerge == null) {
            this
        } else {
            val oldRequired = _required.orNull
            if (oldRequired == null) {
                setRequiredField(Field(requiredToMerge))
            } else {
                // hint:2F684DAC
                setRequired(requiredToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setRequired(required: Boolean): Parameter {
        return setRequiredField(Field(required))
    }

    // hint:D465F782
    fun unsetRequired(): Parameter {
        return setRequiredField(Field.unset())
    }

    // hint:47C9A0F6
    fun addRequired(required: Boolean = true): Parameter {
        return setRequired(required)
    }

    ///////////////////////
    //
    // deprecated
    //
    ///////////////////////

    // hint:3A7F9B2E
    val deprecated: Boolean
        get() = _deprecated.orNull ?: false

    // hint:F0C48D71
    fun setDeprecatedField(deprecated: Field<Boolean>): Parameter {
        return copy(_deprecated = deprecated)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDeprecatedField(updater: (Field<Boolean>) -> Field<Boolean>): Parameter {
        return setDeprecatedField(updater(_deprecated))
    }

    // hint:B1D730FC
    fun updateDeprecated(updater: (Boolean) -> Boolean): Parameter {
        return updateDeprecatedField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDeprecatedField(deprecatedFieldToMerge: Field<Boolean>): Parameter {
        return mergeDeprecated(deprecatedFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDeprecated(deprecatedToMerge: Boolean?): Parameter {
        return if (deprecatedToMerge == null) {
            this
        } else {
            val oldDeprecated = _deprecated.orNull
            if (oldDeprecated == null) {
                setDeprecatedField(Field(deprecatedToMerge))
            } else {
                // hint:2F684DAC
                setDeprecated(deprecatedToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDeprecated(deprecated: Boolean): Parameter {
        return setDeprecatedField(Field(deprecated))
    }

    // hint:D465F782
    fun unsetDeprecated(): Parameter {
        return setDeprecatedField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDeprecated(deprecated: Boolean = true): Parameter {
        return setDeprecated(deprecated)
    }

    ///////////////////////
    //
    // allowEmptyValue
    //
    ///////////////////////

    // hint:3A7F9B2E
    val allowEmptyValue: Boolean
        get() = _allowEmptyValue.orNull ?: false

    // hint:F0C48D71
    fun setAllowEmptyValueField(allowEmptyValue: Field<Boolean>): Parameter {
        return copy(_allowEmptyValue = allowEmptyValue)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateAllowEmptyValueField(updater: (Field<Boolean>) -> Field<Boolean>): Parameter {
        return setAllowEmptyValueField(updater(_allowEmptyValue))
    }

    // hint:B1D730FC
    fun updateAllowEmptyValue(updater: (Boolean) -> Boolean): Parameter {
        return updateAllowEmptyValueField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeAllowEmptyValueField(allowEmptyValueFieldToMerge: Field<Boolean>): Parameter {
        return mergeAllowEmptyValue(allowEmptyValueFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeAllowEmptyValue(allowEmptyValueToMerge: Boolean?): Parameter {
        return if (allowEmptyValueToMerge == null) {
            this
        } else {
            val oldAllowEmptyValue = _allowEmptyValue.orNull
            if (oldAllowEmptyValue == null) {
                setAllowEmptyValueField(Field(allowEmptyValueToMerge))
            } else {
                // hint:2F684DAC
                setAllowEmptyValue(allowEmptyValueToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setAllowEmptyValue(allowEmptyValue: Boolean): Parameter {
        return setAllowEmptyValueField(Field(allowEmptyValue))
    }

    // hint:D465F782
    fun unsetAllowEmptyValue(): Parameter {
        return setAllowEmptyValueField(Field.unset())
    }

    // hint:47C9A0F6
    fun addAllowEmptyValue(allowEmptyValue: Boolean = true): Parameter {
        return setAllowEmptyValue(allowEmptyValue)
    }

    ///////////////////////
    //
    // style
    //
    ///////////////////////

    // hint:3A7F9B2E
    val style: String?
        get() = _style.orNull

    // hint:F0C48D71
    fun setStyleField(style: Field<String?>): Parameter {
        return copy(_style = style)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateStyleField(updater: (Field<String?>) -> Field<String?>): Parameter {
        return setStyleField(updater(_style))
    }

    // hint:B1D730FC
    fun updateStyle(updater: (String?) -> String?): Parameter {
        return updateStyleField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeStyleField(styleFieldToMerge: Field<String?>): Parameter {
        return mergeStyle(styleFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeStyle(styleToMerge: String?): Parameter {
        return if (styleToMerge == null) {
            this
        } else {
            val oldStyle = _style.orNull
            if (oldStyle == null) {
                setStyleField(Field(styleToMerge))
            } else {
                // hint:2F684DAC
                setStyle(styleToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setStyle(style: String?): Parameter {
        return setStyleField(Field(style))
    }

    // hint:D465F782
    fun unsetStyle(): Parameter {
        return setStyleField(Field.unset())
    }

    // hint:47C9A0F6
    fun addStyle(style: String): Parameter {
        if (this.style != null) {
            throw IllegalStateException("Field style of Entity Parameter is already set to '${this.style}', refused to add new value '$style'")
        }
        return setStyle(style)
    }

    // hint:F1547C23
    fun setStyleMatrix(): Parameter {
        return setStyle("matrix")
    }

    // hint:8B64D9F0
    fun addStyleMatrix(): Parameter {
        return addStyle("matrix")
    }

    // hint:F1547C23
    fun setStyleLabel(): Parameter {
        return setStyle("label")
    }

    // hint:8B64D9F0
    fun addStyleLabel(): Parameter {
        return addStyle("label")
    }

    // hint:F1547C23
    fun setStyleForm(): Parameter {
        return setStyle("form")
    }

    // hint:8B64D9F0
    fun addStyleForm(): Parameter {
        return addStyle("form")
    }

    // hint:F1547C23
    fun setStyleSimple(): Parameter {
        return setStyle("simple")
    }

    // hint:8B64D9F0
    fun addStyleSimple(): Parameter {
        return addStyle("simple")
    }

    // hint:F1547C23
    fun setStyleSpaceDelimited(): Parameter {
        return setStyle("spaceDelimited")
    }

    // hint:8B64D9F0
    fun addStyleSpaceDelimited(): Parameter {
        return addStyle("spaceDelimited")
    }

    // hint:F1547C23
    fun setStylePipeDelimited(): Parameter {
        return setStyle("pipeDelimited")
    }

    // hint:8B64D9F0
    fun addStylePipeDelimited(): Parameter {
        return addStyle("pipeDelimited")
    }

    // hint:F1547C23
    fun setStyleDeepObject(): Parameter {
        return setStyle("deepObject")
    }

    // hint:8B64D9F0
    fun addStyleDeepObject(): Parameter {
        return addStyle("deepObject")
    }

    ///////////////////////
    //
    // explode
    //
    ///////////////////////

    // hint:3A7F9B2E
    val explode: Boolean?
        get() = _explode.orNull

    // hint:F0C48D71
    fun setExplodeField(explode: Field<Boolean?>): Parameter {
        return copy(_explode = explode)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExplodeField(updater: (Field<Boolean?>) -> Field<Boolean?>): Parameter {
        return setExplodeField(updater(_explode))
    }

    // hint:B1D730FC
    fun updateExplode(updater: (Boolean?) -> Boolean?): Parameter {
        return updateExplodeField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExplodeField(explodeFieldToMerge: Field<Boolean?>): Parameter {
        return mergeExplode(explodeFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExplode(explodeToMerge: Boolean?): Parameter {
        return if (explodeToMerge == null) {
            this
        } else {
            val oldExplode = _explode.orNull
            if (oldExplode == null) {
                setExplodeField(Field(explodeToMerge))
            } else {
                // hint:2F684DAC
                setExplode(explodeToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setExplode(explode: Boolean?): Parameter {
        return setExplodeField(Field(explode))
    }

    // hint:D465F782
    fun unsetExplode(): Parameter {
        return setExplodeField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExplode(explode: Boolean): Parameter {
        if (this.explode != null) {
            throw IllegalStateException("Field explode of Entity Parameter is already set to '${this.explode}', refused to add new value '$explode'")
        }
        return setExplode(explode)
    }

    ///////////////////////
    //
    // allowReserved
    //
    ///////////////////////

    // hint:3A7F9B2E
    val allowReserved: Boolean
        get() = _allowReserved.orNull ?: false

    // hint:F0C48D71
    fun setAllowReservedField(allowReserved: Field<Boolean>): Parameter {
        return copy(_allowReserved = allowReserved)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateAllowReservedField(updater: (Field<Boolean>) -> Field<Boolean>): Parameter {
        return setAllowReservedField(updater(_allowReserved))
    }

    // hint:B1D730FC
    fun updateAllowReserved(updater: (Boolean) -> Boolean): Parameter {
        return updateAllowReservedField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeAllowReservedField(allowReservedFieldToMerge: Field<Boolean>): Parameter {
        return mergeAllowReserved(allowReservedFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeAllowReserved(allowReservedToMerge: Boolean?): Parameter {
        return if (allowReservedToMerge == null) {
            this
        } else {
            val oldAllowReserved = _allowReserved.orNull
            if (oldAllowReserved == null) {
                setAllowReservedField(Field(allowReservedToMerge))
            } else {
                // hint:2F684DAC
                setAllowReserved(allowReservedToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setAllowReserved(allowReserved: Boolean): Parameter {
        return setAllowReservedField(Field(allowReserved))
    }

    // hint:D465F782
    fun unsetAllowReserved(): Parameter {
        return setAllowReservedField(Field.unset())
    }

    // hint:47C9A0F6
    fun addAllowReserved(allowReserved: Boolean = true): Parameter {
        return setAllowReserved(allowReserved)
    }

    ///////////////////////
    //
    // schema
    //
    ///////////////////////

    // hint:3A7F9B2E
    val schema: ReferenceOrInstance<Schema>?
        get() = _schema.orNull

    // hint:F0C48D71
    fun setSchemaField(schema: Field<ReferenceOrInstance<Schema>?>): Parameter {
        return copy(_schema = schema)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSchemaField(updater: (Field<ReferenceOrInstance<Schema>?>) -> Field<ReferenceOrInstance<Schema>?>): Parameter {
        return setSchemaField(updater(_schema))
    }

    // hint:B1D730FC
    fun updateSchema(updater: (ReferenceOrInstance<Schema>?) -> ReferenceOrInstance<Schema>?): Parameter {
        return updateSchemaField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSchemaField(schemaFieldToMerge: Field<ReferenceOrInstance<Schema>?>): Parameter {
        return mergeSchema(schemaFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSchema(schemaToMerge: ReferenceOrInstance<Schema>?): Parameter {
        return if (schemaToMerge == null) {
            this
        } else {
            val oldSchema = _schema.orNull
            if (oldSchema == null) {
                setSchemaField(Field(schemaToMerge))
            } else {
                // hint:2F684DAC
                setSchema(schemaToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setSchema(schema: ReferenceOrInstance<Schema>?): Parameter {
        return setSchemaField(Field(schema))
    }

    // hint:D465F782
    fun unsetSchema(): Parameter {
        return setSchemaField(Field.unset())
    }

    // hint:F8E61D9B
    fun addSchema(schema: Schema): Parameter {
        return addSchema(Instance(schema))
    }

    // hint:47C9A0F6
    fun addSchema(schema: ReferenceOrInstance<Schema>): Parameter {
        if (this.schema != null) {
            throw IllegalStateException("Field schema of Entity Parameter is already set to '${this.schema}', refused to add new value '$schema'")
        }
        return setSchema(schema)
    }

    ///////////////////////
    //
    // content
    //
    ///////////////////////

    // hint:3A7F9B2E
    val content: Map<String, MediaType?>?
        get() = _content.orNull

    // hint:F0C48D71
    fun setContentField(content: Field<Map<String, MediaType?>?>): Parameter {
        return copy(_content = content)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateContentField(updater: (Field<Map<String, MediaType?>?>) -> Field<Map<String, MediaType?>?>): Parameter {
        return setContentField(updater(_content))
    }

    // hint:B1D730FC
    fun updateContent(updater: (Map<String, MediaType?>?) -> Map<String, MediaType?>?): Parameter {
        return updateContentField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeContentField(contentFieldToMerge: Field<Map<String, MediaType?>?>): Parameter {
        return mergeContent(contentFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeContent(contentToMerge: Map<String, MediaType?>?): Parameter {
        return if (contentToMerge == null) {
            this
        } else {
            val oldContent = _content.orNull
            if (oldContent == null) {
                setContentField(Field(contentToMerge))
            } else {
                // hint:70A3D8B6
                setContent(de.lancom.openapi.parser.util.mergeMap(oldContent, contentToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setContent(content: Map<String, MediaType?>?): Parameter {
        return setContentField(Field(content))
    }

    // hint:D465F782
    fun unsetContent(): Parameter {
        return setContentField(Field.unset())
    }

    // hint:5C81D396
    fun addContent(content: Map<String, MediaType?>?): Parameter {
        return mergeContent(content)
    }

    // hint:1A6B37F8
    fun addContent(vararg content: Pair<String, MediaType?>): Parameter {
        return addContent(content.toMap())
    }

    // hint:9D0E4CA5
    fun addContent(key: String, value: MediaType?): Parameter {
        return addContent(key to value)
    }

    // hint:B8F25E73
    fun addContent(pair: Pair<String, MediaType?>): Parameter {
        return addContent(mapOf(pair))
    }

    ///////////////////////
    //
    // example
    //
    ///////////////////////

    // hint:3A7F9B2E
    val example: ExampleJson?
        get() = _example.orNull

    // hint:F0C48D71
    fun setExampleField(example: Field<ExampleJson?>): Parameter {
        return copy(_example = example)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExampleField(updater: (Field<ExampleJson?>) -> Field<ExampleJson?>): Parameter {
        return setExampleField(updater(_example))
    }

    // hint:B1D730FC
    fun updateExample(updater: (ExampleJson?) -> ExampleJson?): Parameter {
        return updateExampleField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExampleField(exampleFieldToMerge: Field<ExampleJson?>): Parameter {
        return mergeExample(exampleFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExample(exampleToMerge: ExampleJson?): Parameter {
        return if (exampleToMerge == null) {
            this
        } else {
            val oldExample = _example.orNull
            if (oldExample == null) {
                setExampleField(Field(exampleToMerge))
            } else {
                // hint:E91B4F65
                setExample(oldExample.mergeEntity(exampleToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExample(example: ExampleJson?): Parameter {
        return setExampleField(Field(example))
    }

    // hint:D465F782
    fun unsetExample(): Parameter {
        return setExampleField(Field.unset())
    }

    // hint:47C9A0F6
    fun addExample(example: ExampleJson): Parameter {
        if (this.example != null) {
            throw IllegalStateException("Field example of Entity Parameter is already set to '${this.example}', refused to add new value '$example'")
        }
        return setExample(example)
    }

    ///////////////////////
    //
    // examples
    //
    ///////////////////////

    // hint:3A7F9B2E
    val examples: Map<String, ReferenceOrInstance<Example>?>?
        get() = _examples.orNull

    // hint:F0C48D71
    fun setExamplesField(examples: Field<Map<String, ReferenceOrInstance<Example>?>?>): Parameter {
        return copy(_examples = examples)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExamplesField(updater: (Field<Map<String, ReferenceOrInstance<Example>?>?>) -> Field<Map<String, ReferenceOrInstance<Example>?>?>): Parameter {
        return setExamplesField(updater(_examples))
    }

    // hint:B1D730FC
    fun updateExamples(updater: (Map<String, ReferenceOrInstance<Example>?>?) -> Map<String, ReferenceOrInstance<Example>?>?): Parameter {
        return updateExamplesField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExamplesField(examplesFieldToMerge: Field<Map<String, ReferenceOrInstance<Example>?>?>): Parameter {
        return mergeExamples(examplesFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExamples(examplesToMerge: Map<String, ReferenceOrInstance<Example>?>?): Parameter {
        return if (examplesToMerge == null) {
            this
        } else {
            val oldExamples = _examples.orNull
            if (oldExamples == null) {
                setExamplesField(Field(examplesToMerge))
            } else {
                // hint:70A3D8B6
                setExamples(de.lancom.openapi.parser.util.mergeMap(oldExamples, examplesToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): Parameter {
        return setExamplesField(Field(examples))
    }

    // hint:D465F782
    fun unsetExamples(): Parameter {
        return setExamplesField(Field.unset())
    }

    // hint:5C81D396
    fun addExamples(examples: Map<String, ReferenceOrInstance<Example>?>?): Parameter {
        return mergeExamples(examples)
    }

    // hint:1A6B37F8
    fun addExamples(vararg examples: Pair<String, ReferenceOrInstance<Example>?>): Parameter {
        return addExamples(examples.toMap())
    }

    // hint:9D0E4CA5
    fun addExample(key: String, value: ReferenceOrInstance<Example>?): Parameter {
        return addExamples(key to value)
    }

    // hint:B8F25E73
    fun addExample(pair: Pair<String, ReferenceOrInstance<Example>?>): Parameter {
        return addExamples(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addExample(key: String, value: Example): Parameter {
        return addExamples(key to Instance(value))
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): Parameter {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): Parameter {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): Parameter {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): Parameter {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): Parameter {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): Parameter {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): Parameter {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): Parameter {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): Parameter {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): Parameter {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): Parameter {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "name" to _name,
                "in" to _in,
                "description" to _description,
                "required" to _required,
                "deprecated" to _deprecated,
                "allowEmptyValue" to _allowEmptyValue,
                "style" to _style,
                "explode" to _explode,
                "allowReserved" to _allowReserved,
                "schema" to _schema,
                "content" to _content,
                "example" to _example,
                "examples" to _examples,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_name.isDefined) Fields.name else null,
                if (_in.isDefined) Fields.`in` else null,
                if (_description.isDefined) Fields.description else null,
                if (_required.isDefined) Fields.required else null,
                if (_deprecated.isDefined) Fields.deprecated else null,
                if (_allowEmptyValue.isDefined) Fields.allowEmptyValue else null,
                if (_style.isDefined) Fields.style else null,
                if (_explode.isDefined) Fields.explode else null,
                if (_allowReserved.isDefined) Fields.allowReserved else null,
                if (_schema.isDefined) Fields.schema else null,
                if (_content.isDefined) Fields.content else null,
                if (_example.isDefined) Fields.example else null,
                if (_examples.isDefined) Fields.examples else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): Parameter {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): Parameter {
        return when (other) {
            null ->
                this

            is Parameter ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: Parameter): Parameter {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: Parameter?): Parameter {
        if (other == null) return this
        return this
            .mergeNameField(other._name)
            .mergeInField(other._in)
            .mergeDescriptionField(other._description)
            .mergeRequiredField(other._required)
            .mergeDeprecatedField(other._deprecated)
            .mergeAllowEmptyValueField(other._allowEmptyValue)
            .mergeStyleField(other._style)
            .mergeExplodeField(other._explode)
            .mergeAllowReservedField(other._allowReserved)
            .mergeSchemaField(other._schema)
            .mergeContentField(other._content)
            .mergeExampleField(other._example)
            .mergeExamplesField(other._examples)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    // hint:21B416A6
    override fun getReferencePath(): String? {
        return if (__referenceName == null) {
            null
        } else {
            "#/components/parameters/$__referenceName"
        }
    }

    fun setReferenceName(name: String): Parameter {
        return copy(__referenceName = name)
    }

    companion object : ReferenceParser<Parameter> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val name = Fields("name")
                val `in` = Fields("in")
                val description = Fields("description")
                val required = Fields("required")
                val deprecated = Fields("deprecated")
                val allowEmptyValue = Fields("allowEmptyValue")
                val style = Fields("style")
                val explode = Fields("explode")
                val allowReserved = Fields("allowReserved")
                val schema = Fields("schema")
                val content = Fields("content")
                val example = Fields("example")
                val examples = Fields("examples")
                val all: Set<Fields> = setOf(
                    name,
                    `in`,
                    description,
                    required,
                    deprecated,
                    allowEmptyValue,
                    style,
                    explode,
                    allowReserved,
                    schema,
                    content,
                    example,
                    examples,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<Parameter>(Parameter::class.java, Parameter)
        class Deserializer : EntityDeserializer<Parameter>(Parameter::class.java, Parameter)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): Parameter {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): Parameter {
            return Parameter(
                _name = wrapper["name"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _in = wrapper["in"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getEnum(In::fromString)
                        }
                    }
                },
                _description = wrapper["description"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _required = wrapper["required"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _deprecated = wrapper["deprecated"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _allowEmptyValue = wrapper["allowEmptyValue"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _style = wrapper["style"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _explode = wrapper["explode"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _allowReserved = wrapper["allowReserved"].getSingle {
                    getSingle {
                        getSingle {
                            getBoolean()
                        }
                    }
                },
                _schema = wrapper["schema"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Schema::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _content = wrapper["content"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(MediaType::parseEntityOpt)
                        }
                    }
                },
                _example = wrapper["example"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(ExampleJson::parseEntityOpt)
                        }
                    }
                },
                _examples = wrapper["examples"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Example::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
