/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.Parser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = PathItem.Companion.Serializer::class)
@JsonDeserialize(using = PathItem.Companion.Deserializer::class)
data class PathItem(
    val _summary: Field<String?> = Field.unset(),
    val _description: Field<String?> = Field.unset(),
    val _servers: Field<List<Server?>?> = Field.unset(),
    val _parameters: Field<List<ReferenceOrInstance<Parameter>?>?> = Field.unset(),
    val _get: Field<Operation?> = Field.unset(),
    val _put: Field<Operation?> = Field.unset(),
    val _post: Field<Operation?> = Field.unset(),
    val _delete: Field<Operation?> = Field.unset(),
    val _options: Field<Operation?> = Field.unset(),
    val _head: Field<Operation?> = Field.unset(),
    val _patch: Field<Operation?> = Field.unset(),
    val _trace: Field<Operation?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
) : Entity {

    ///////////////////////
    //
    // summary
    //
    ///////////////////////

    // hint:3A7F9B2E
    val summary: String?
        get() = _summary.orNull

    // hint:F0C48D71
    fun setSummaryField(summary: Field<String?>): PathItem {
        return copy(_summary = summary)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateSummaryField(updater: (Field<String?>) -> Field<String?>): PathItem {
        return setSummaryField(updater(_summary))
    }

    // hint:B1D730FC
    fun updateSummary(updater: (String?) -> String?): PathItem {
        return updateSummaryField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeSummaryField(summaryFieldToMerge: Field<String?>): PathItem {
        return mergeSummary(summaryFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeSummary(summaryToMerge: String?): PathItem {
        return if (summaryToMerge == null) {
            this
        } else {
            val oldSummary = _summary.orNull
            if (oldSummary == null) {
                setSummaryField(Field(summaryToMerge))
            } else {
                // hint:2F684DAC
                setSummary(summaryToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setSummary(summary: String?): PathItem {
        return setSummaryField(Field(summary))
    }

    // hint:D465F782
    fun unsetSummary(): PathItem {
        return setSummaryField(Field.unset())
    }

    // hint:47C9A0F6
    fun addSummary(summary: String): PathItem {
        if (this.summary != null) {
            throw IllegalStateException("Field summary of Entity PathItem is already set to '${this.summary}', refused to add new value '$summary'")
        }
        return setSummary(summary)
    }

    ///////////////////////
    //
    // description
    //
    ///////////////////////

    // hint:3A7F9B2E
    val description: String?
        get() = _description.orNull

    // hint:F0C48D71
    fun setDescriptionField(description: Field<String?>): PathItem {
        return copy(_description = description)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDescriptionField(updater: (Field<String?>) -> Field<String?>): PathItem {
        return setDescriptionField(updater(_description))
    }

    // hint:B1D730FC
    fun updateDescription(updater: (String?) -> String?): PathItem {
        return updateDescriptionField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDescriptionField(descriptionFieldToMerge: Field<String?>): PathItem {
        return mergeDescription(descriptionFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDescription(descriptionToMerge: String?): PathItem {
        return if (descriptionToMerge == null) {
            this
        } else {
            val oldDescription = _description.orNull
            if (oldDescription == null) {
                setDescriptionField(Field(descriptionToMerge))
            } else {
                // hint:2F684DAC
                setDescription(descriptionToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDescription(description: String?): PathItem {
        return setDescriptionField(Field(description))
    }

    // hint:D465F782
    fun unsetDescription(): PathItem {
        return setDescriptionField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDescription(description: String): PathItem {
        if (this.description != null) {
            throw IllegalStateException("Field description of Entity PathItem is already set to '${this.description}', refused to add new value '$description'")
        }
        return setDescription(description)
    }

    ///////////////////////
    //
    // servers
    //
    ///////////////////////

    // hint:3A7F9B2E
    val servers: List<Server?>?
        get() = _servers.orNull

    // hint:F0C48D71
    fun setServersField(servers: Field<List<Server?>?>): PathItem {
        return copy(_servers = servers)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateServersField(updater: (Field<List<Server?>?>) -> Field<List<Server?>?>): PathItem {
        return setServersField(updater(_servers))
    }

    // hint:B1D730FC
    fun updateServers(updater: (List<Server?>?) -> List<Server?>?): PathItem {
        return updateServersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeServersField(serversFieldToMerge: Field<List<Server?>?>): PathItem {
        return mergeServers(serversFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeServers(serversToMerge: List<Server?>?): PathItem {
        return if (serversToMerge == null) {
            this
        } else {
            val oldServers = _servers.orNull
            if (oldServers == null) {
                setServersField(Field(serversToMerge))
            } else {
                // hint:19DE5C87
                setServers((oldServers + serversToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setServers(servers: List<Server?>?): PathItem {
        return setServersField(Field(servers))
    }

    // hint:D465F782
    fun unsetServers(): PathItem {
        return setServersField(Field.unset())
    }

    // hint:3E9A8C01
    fun addServers(servers: List<Server?>?): PathItem {
        return setServers((this.servers ?: emptyList()) + (servers ?: emptyList()))
    }

    // hint:F7420EB5
    fun addServers(vararg servers: Server): PathItem {
        return addServers(servers.toList())
    }

    ///////////////////////
    //
    // parameters
    //
    ///////////////////////

    // hint:3A7F9B2E
    val parameters: List<ReferenceOrInstance<Parameter>?>?
        get() = _parameters.orNull

    // hint:F0C48D71
    fun setParametersField(parameters: Field<List<ReferenceOrInstance<Parameter>?>?>): PathItem {
        return copy(_parameters = parameters)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateParametersField(updater: (Field<List<ReferenceOrInstance<Parameter>?>?>) -> Field<List<ReferenceOrInstance<Parameter>?>?>): PathItem {
        return setParametersField(updater(_parameters))
    }

    // hint:B1D730FC
    fun updateParameters(updater: (List<ReferenceOrInstance<Parameter>?>?) -> List<ReferenceOrInstance<Parameter>?>?): PathItem {
        return updateParametersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeParametersField(parametersFieldToMerge: Field<List<ReferenceOrInstance<Parameter>?>?>): PathItem {
        return mergeParameters(parametersFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeParameters(parametersToMerge: List<ReferenceOrInstance<Parameter>?>?): PathItem {
        return if (parametersToMerge == null) {
            this
        } else {
            val oldParameters = _parameters.orNull
            if (oldParameters == null) {
                setParametersField(Field(parametersToMerge))
            } else {
                // hint:19DE5C87
                setParameters((oldParameters + parametersToMerge).distinct())
            }
        }
    }

    // hint:87B3E19C
    fun setParameters(parameters: List<ReferenceOrInstance<Parameter>?>?): PathItem {
        return setParametersField(Field(parameters))
    }

    // hint:D465F782
    fun unsetParameters(): PathItem {
        return setParametersField(Field.unset())
    }

    // hint:85F37E6D
    @JvmName("addParametersList")
    fun addParameters(parameters: List<Parameter>): PathItem {
        return addParameters(parameters.map(::Instance).toList())
    }

    // hint:47D2AFC8
    fun addParameters(vararg parameters: Parameter): PathItem {
        return addParameters(parameters.toList())
    }

    // hint:12B6C4A3
    @JvmName("addParametersArray")
    fun addParameters(parameters: Array<out Parameter>): PathItem {
        return addParameters(parameters.toList())
    }

    // hint:3E9A8C01
    fun addParameters(parameters: List<ReferenceOrInstance<Parameter>?>?): PathItem {
        return setParameters((this.parameters ?: emptyList()) + (parameters ?: emptyList()))
    }

    // hint:F7420EB5
    fun addParameters(vararg parameters: ReferenceOrInstance<Parameter>): PathItem {
        return addParameters(parameters.toList())
    }

    ///////////////////////
    //
    // get
    //
    ///////////////////////

    // hint:3A7F9B2E
    val get: Operation?
        get() = _get.orNull

    // hint:F0C48D71
    fun setGetField(get: Field<Operation?>): PathItem {
        return copy(_get = get)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateGetField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setGetField(updater(_get))
    }

    // hint:B1D730FC
    fun updateGet(updater: (Operation?) -> Operation?): PathItem {
        return updateGetField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeGetField(getFieldToMerge: Field<Operation?>): PathItem {
        return mergeGet(getFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeGet(getToMerge: Operation?): PathItem {
        return if (getToMerge == null) {
            this
        } else {
            val oldGet = _get.orNull
            if (oldGet == null) {
                setGetField(Field(getToMerge))
            } else {
                // hint:E91B4F65
                setGet(oldGet.mergeEntity(getToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setGet(get: Operation?): PathItem {
        return setGetField(Field(get))
    }

    // hint:D465F782
    fun unsetGet(): PathItem {
        return setGetField(Field.unset())
    }

    // hint:47C9A0F6
    fun addGet(get: Operation): PathItem {
        if (this.get != null) {
            throw IllegalStateException("Field get of Entity PathItem is already set to '${this.get}', refused to add new value '$get'")
        }
        return setGet(get)
    }

    ///////////////////////
    //
    // put
    //
    ///////////////////////

    // hint:3A7F9B2E
    val put: Operation?
        get() = _put.orNull

    // hint:F0C48D71
    fun setPutField(put: Field<Operation?>): PathItem {
        return copy(_put = put)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updatePutField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setPutField(updater(_put))
    }

    // hint:B1D730FC
    fun updatePut(updater: (Operation?) -> Operation?): PathItem {
        return updatePutField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergePutField(putFieldToMerge: Field<Operation?>): PathItem {
        return mergePut(putFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergePut(putToMerge: Operation?): PathItem {
        return if (putToMerge == null) {
            this
        } else {
            val oldPut = _put.orNull
            if (oldPut == null) {
                setPutField(Field(putToMerge))
            } else {
                // hint:E91B4F65
                setPut(oldPut.mergeEntity(putToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setPut(put: Operation?): PathItem {
        return setPutField(Field(put))
    }

    // hint:D465F782
    fun unsetPut(): PathItem {
        return setPutField(Field.unset())
    }

    // hint:47C9A0F6
    fun addPut(put: Operation): PathItem {
        if (this.put != null) {
            throw IllegalStateException("Field put of Entity PathItem is already set to '${this.put}', refused to add new value '$put'")
        }
        return setPut(put)
    }

    ///////////////////////
    //
    // post
    //
    ///////////////////////

    // hint:3A7F9B2E
    val post: Operation?
        get() = _post.orNull

    // hint:F0C48D71
    fun setPostField(post: Field<Operation?>): PathItem {
        return copy(_post = post)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updatePostField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setPostField(updater(_post))
    }

    // hint:B1D730FC
    fun updatePost(updater: (Operation?) -> Operation?): PathItem {
        return updatePostField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergePostField(postFieldToMerge: Field<Operation?>): PathItem {
        return mergePost(postFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergePost(postToMerge: Operation?): PathItem {
        return if (postToMerge == null) {
            this
        } else {
            val oldPost = _post.orNull
            if (oldPost == null) {
                setPostField(Field(postToMerge))
            } else {
                // hint:E91B4F65
                setPost(oldPost.mergeEntity(postToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setPost(post: Operation?): PathItem {
        return setPostField(Field(post))
    }

    // hint:D465F782
    fun unsetPost(): PathItem {
        return setPostField(Field.unset())
    }

    // hint:47C9A0F6
    fun addPost(post: Operation): PathItem {
        if (this.post != null) {
            throw IllegalStateException("Field post of Entity PathItem is already set to '${this.post}', refused to add new value '$post'")
        }
        return setPost(post)
    }

    ///////////////////////
    //
    // delete
    //
    ///////////////////////

    // hint:3A7F9B2E
    val delete: Operation?
        get() = _delete.orNull

    // hint:F0C48D71
    fun setDeleteField(delete: Field<Operation?>): PathItem {
        return copy(_delete = delete)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDeleteField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setDeleteField(updater(_delete))
    }

    // hint:B1D730FC
    fun updateDelete(updater: (Operation?) -> Operation?): PathItem {
        return updateDeleteField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDeleteField(deleteFieldToMerge: Field<Operation?>): PathItem {
        return mergeDelete(deleteFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDelete(deleteToMerge: Operation?): PathItem {
        return if (deleteToMerge == null) {
            this
        } else {
            val oldDelete = _delete.orNull
            if (oldDelete == null) {
                setDeleteField(Field(deleteToMerge))
            } else {
                // hint:E91B4F65
                setDelete(oldDelete.mergeEntity(deleteToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setDelete(delete: Operation?): PathItem {
        return setDeleteField(Field(delete))
    }

    // hint:D465F782
    fun unsetDelete(): PathItem {
        return setDeleteField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDelete(delete: Operation): PathItem {
        if (this.delete != null) {
            throw IllegalStateException("Field delete of Entity PathItem is already set to '${this.delete}', refused to add new value '$delete'")
        }
        return setDelete(delete)
    }

    ///////////////////////
    //
    // options
    //
    ///////////////////////

    // hint:3A7F9B2E
    val options: Operation?
        get() = _options.orNull

    // hint:F0C48D71
    fun setOptionsField(options: Field<Operation?>): PathItem {
        return copy(_options = options)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateOptionsField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setOptionsField(updater(_options))
    }

    // hint:B1D730FC
    fun updateOptions(updater: (Operation?) -> Operation?): PathItem {
        return updateOptionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeOptionsField(optionsFieldToMerge: Field<Operation?>): PathItem {
        return mergeOptions(optionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeOptions(optionsToMerge: Operation?): PathItem {
        return if (optionsToMerge == null) {
            this
        } else {
            val oldOptions = _options.orNull
            if (oldOptions == null) {
                setOptionsField(Field(optionsToMerge))
            } else {
                // hint:E91B4F65
                setOptions(oldOptions.mergeEntity(optionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setOptions(options: Operation?): PathItem {
        return setOptionsField(Field(options))
    }

    // hint:D465F782
    fun unsetOptions(): PathItem {
        return setOptionsField(Field.unset())
    }

    // hint:47C9A0F6
    fun addOptions(options: Operation): PathItem {
        if (this.options != null) {
            throw IllegalStateException("Field options of Entity PathItem is already set to '${this.options}', refused to add new value '$options'")
        }
        return setOptions(options)
    }

    ///////////////////////
    //
    // head
    //
    ///////////////////////

    // hint:3A7F9B2E
    val head: Operation?
        get() = _head.orNull

    // hint:F0C48D71
    fun setHeadField(head: Field<Operation?>): PathItem {
        return copy(_head = head)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateHeadField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setHeadField(updater(_head))
    }

    // hint:B1D730FC
    fun updateHead(updater: (Operation?) -> Operation?): PathItem {
        return updateHeadField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeHeadField(headFieldToMerge: Field<Operation?>): PathItem {
        return mergeHead(headFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeHead(headToMerge: Operation?): PathItem {
        return if (headToMerge == null) {
            this
        } else {
            val oldHead = _head.orNull
            if (oldHead == null) {
                setHeadField(Field(headToMerge))
            } else {
                // hint:E91B4F65
                setHead(oldHead.mergeEntity(headToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setHead(head: Operation?): PathItem {
        return setHeadField(Field(head))
    }

    // hint:D465F782
    fun unsetHead(): PathItem {
        return setHeadField(Field.unset())
    }

    // hint:47C9A0F6
    fun addHead(head: Operation): PathItem {
        if (this.head != null) {
            throw IllegalStateException("Field head of Entity PathItem is already set to '${this.head}', refused to add new value '$head'")
        }
        return setHead(head)
    }

    ///////////////////////
    //
    // patch
    //
    ///////////////////////

    // hint:3A7F9B2E
    val patch: Operation?
        get() = _patch.orNull

    // hint:F0C48D71
    fun setPatchField(patch: Field<Operation?>): PathItem {
        return copy(_patch = patch)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updatePatchField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setPatchField(updater(_patch))
    }

    // hint:B1D730FC
    fun updatePatch(updater: (Operation?) -> Operation?): PathItem {
        return updatePatchField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergePatchField(patchFieldToMerge: Field<Operation?>): PathItem {
        return mergePatch(patchFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergePatch(patchToMerge: Operation?): PathItem {
        return if (patchToMerge == null) {
            this
        } else {
            val oldPatch = _patch.orNull
            if (oldPatch == null) {
                setPatchField(Field(patchToMerge))
            } else {
                // hint:E91B4F65
                setPatch(oldPatch.mergeEntity(patchToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setPatch(patch: Operation?): PathItem {
        return setPatchField(Field(patch))
    }

    // hint:D465F782
    fun unsetPatch(): PathItem {
        return setPatchField(Field.unset())
    }

    // hint:47C9A0F6
    fun addPatch(patch: Operation): PathItem {
        if (this.patch != null) {
            throw IllegalStateException("Field patch of Entity PathItem is already set to '${this.patch}', refused to add new value '$patch'")
        }
        return setPatch(patch)
    }

    ///////////////////////
    //
    // trace
    //
    ///////////////////////

    // hint:3A7F9B2E
    val trace: Operation?
        get() = _trace.orNull

    // hint:F0C48D71
    fun setTraceField(trace: Field<Operation?>): PathItem {
        return copy(_trace = trace)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateTraceField(updater: (Field<Operation?>) -> Field<Operation?>): PathItem {
        return setTraceField(updater(_trace))
    }

    // hint:B1D730FC
    fun updateTrace(updater: (Operation?) -> Operation?): PathItem {
        return updateTraceField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeTraceField(traceFieldToMerge: Field<Operation?>): PathItem {
        return mergeTrace(traceFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeTrace(traceToMerge: Operation?): PathItem {
        return if (traceToMerge == null) {
            this
        } else {
            val oldTrace = _trace.orNull
            if (oldTrace == null) {
                setTraceField(Field(traceToMerge))
            } else {
                // hint:E91B4F65
                setTrace(oldTrace.mergeEntity(traceToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setTrace(trace: Operation?): PathItem {
        return setTraceField(Field(trace))
    }

    // hint:D465F782
    fun unsetTrace(): PathItem {
        return setTraceField(Field.unset())
    }

    // hint:47C9A0F6
    fun addTrace(trace: Operation): PathItem {
        if (this.trace != null) {
            throw IllegalStateException("Field trace of Entity PathItem is already set to '${this.trace}', refused to add new value '$trace'")
        }
        return setTrace(trace)
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): PathItem {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): PathItem {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): PathItem {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): PathItem {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): PathItem {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): PathItem {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): PathItem {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): PathItem {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): PathItem {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): PathItem {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): PathItem {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "summary" to _summary,
                "description" to _description,
                "servers" to _servers,
                "parameters" to _parameters,
                "get" to _get,
                "put" to _put,
                "post" to _post,
                "delete" to _delete,
                "options" to _options,
                "head" to _head,
                "patch" to _patch,
                "trace" to _trace,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_summary.isDefined) Fields.summary else null,
                if (_description.isDefined) Fields.description else null,
                if (_servers.isDefined) Fields.servers else null,
                if (_parameters.isDefined) Fields.parameters else null,
                if (_get.isDefined) Fields.get else null,
                if (_put.isDefined) Fields.put else null,
                if (_post.isDefined) Fields.post else null,
                if (_delete.isDefined) Fields.delete else null,
                if (_options.isDefined) Fields.options else null,
                if (_head.isDefined) Fields.head else null,
                if (_patch.isDefined) Fields.patch else null,
                if (_trace.isDefined) Fields.trace else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): PathItem {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): PathItem {
        return when (other) {
            null ->
                this

            is PathItem ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: PathItem): PathItem {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: PathItem?): PathItem {
        if (other == null) return this
        return this
            .mergeSummaryField(other._summary)
            .mergeDescriptionField(other._description)
            .mergeServersField(other._servers)
            .mergeParametersField(other._parameters)
            .mergeGetField(other._get)
            .mergePutField(other._put)
            .mergePostField(other._post)
            .mergeDeleteField(other._delete)
            .mergeOptionsField(other._options)
            .mergeHeadField(other._head)
            .mergePatchField(other._patch)
            .mergeTraceField(other._trace)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    companion object : Parser<PathItem> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val summary = Fields("summary")
                val description = Fields("description")
                val servers = Fields("servers")
                val parameters = Fields("parameters")
                val get = Fields("get")
                val put = Fields("put")
                val post = Fields("post")
                val delete = Fields("delete")
                val options = Fields("options")
                val head = Fields("head")
                val patch = Fields("patch")
                val trace = Fields("trace")
                val all: Set<Fields> = setOf(
                    summary,
                    description,
                    servers,
                    parameters,
                    get,
                    put,
                    post,
                    delete,
                    options,
                    head,
                    patch,
                    trace,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<PathItem>(PathItem::class.java, PathItem)
        class Deserializer : EntityDeserializer<PathItem>(PathItem::class.java, PathItem)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): PathItem {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): PathItem {
            return PathItem(
                _summary = wrapper["summary"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _description = wrapper["description"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _servers = wrapper["servers"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(Server::parseEntityOpt)
                        }
                    }
                },
                _parameters = wrapper["parameters"].getNullOrElse {
                    getList {
                        getNullOrElse {
                            getSingle(Parameter::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _get = wrapper["get"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _put = wrapper["put"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _post = wrapper["post"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _delete = wrapper["delete"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _options = wrapper["options"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _head = wrapper["head"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _patch = wrapper["patch"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _trace = wrapper["trace"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getSingle(Operation::parseEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
