/*****************************************************************************
**   C A U T I O N                                                          **
**   This file is auto-generated!                                           **
**   If you want to make changes, please see the README.md file.            **
**   Please do not edit this file directly!                                 **
*****************************************************************************/
package de.lancom.openapi.parser.entity

import com.fasterxml.jackson.databind.annotation.JsonDeserialize
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import de.lancom.openapi.common.types.*
import de.lancom.openapi.common.util.*
import de.lancom.openapi.parser.field.Field
import de.lancom.openapi.parser.jackson.EntityDeserializer
import de.lancom.openapi.parser.jackson.EntitySerializer
import de.lancom.openapi.parser.jackson.ReferenceParser
import de.lancom.openapi.parser.jackson.Wrapper
import de.lancom.openapi.parser.ref.Instance
import de.lancom.openapi.parser.ref.ReferenceOrInstance
import de.lancom.openapi.parser.ref.Referenceable

// hint:9A1BF04C
@Suppress("PropertyName")
@JsonSerialize(using = Response.Companion.Serializer::class)
@JsonDeserialize(using = Response.Companion.Deserializer::class)
data class Response(
    val _description: Field<String?> = Field.unset(),
    val _headers: Field<Map<String, Header?>?> = Field.unset(),
    val _content: Field<Map<String, MediaType?>?> = Field.unset(),
    val _links: Field<Map<String, ReferenceOrInstance<Link>?>?> = Field.unset(),
    val _extensions: Field<Map<String, Extension?>> = Field.unset(),
    val __field_order: Set<Fields> = Fields.all,
    override val __referenceName: String? = null,
) : Referenceable {

    ///////////////////////
    //
    // description
    //
    ///////////////////////

    // hint:3A7F9B2E
    val description: String?
        get() = _description.orNull

    // hint:F0C48D71
    fun setDescriptionField(description: Field<String?>): Response {
        return copy(_description = description)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateDescriptionField(updater: (Field<String?>) -> Field<String?>): Response {
        return setDescriptionField(updater(_description))
    }

    // hint:B1D730FC
    fun updateDescription(updater: (String?) -> String?): Response {
        return updateDescriptionField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeDescriptionField(descriptionFieldToMerge: Field<String?>): Response {
        return mergeDescription(descriptionFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeDescription(descriptionToMerge: String?): Response {
        return if (descriptionToMerge == null) {
            this
        } else {
            val oldDescription = _description.orNull
            if (oldDescription == null) {
                setDescriptionField(Field(descriptionToMerge))
            } else {
                // hint:2F684DAC
                setDescription(descriptionToMerge)
            }
        }
    }

    // hint:87B3E19C
    fun setDescription(description: String?): Response {
        return setDescriptionField(Field(description))
    }

    // hint:D465F782
    fun unsetDescription(): Response {
        return setDescriptionField(Field.unset())
    }

    // hint:47C9A0F6
    fun addDescription(description: String): Response {
        if (this.description != null) {
            throw IllegalStateException("Field description of Entity Response is already set to '${this.description}', refused to add new value '$description'")
        }
        return setDescription(description)
    }

    ///////////////////////
    //
    // headers
    //
    ///////////////////////

    // hint:3A7F9B2E
    val headers: Map<String, Header?>?
        get() = _headers.orNull

    // hint:F0C48D71
    fun setHeadersField(headers: Field<Map<String, Header?>?>): Response {
        return copy(_headers = headers)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateHeadersField(updater: (Field<Map<String, Header?>?>) -> Field<Map<String, Header?>?>): Response {
        return setHeadersField(updater(_headers))
    }

    // hint:B1D730FC
    fun updateHeaders(updater: (Map<String, Header?>?) -> Map<String, Header?>?): Response {
        return updateHeadersField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeHeadersField(headersFieldToMerge: Field<Map<String, Header?>?>): Response {
        return mergeHeaders(headersFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeHeaders(headersToMerge: Map<String, Header?>?): Response {
        return if (headersToMerge == null) {
            this
        } else {
            val oldHeaders = _headers.orNull
            if (oldHeaders == null) {
                setHeadersField(Field(headersToMerge))
            } else {
                // hint:70A3D8B6
                setHeaders(de.lancom.openapi.parser.util.mergeMap(oldHeaders, headersToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setHeaders(headers: Map<String, Header?>?): Response {
        return setHeadersField(Field(headers))
    }

    // hint:D465F782
    fun unsetHeaders(): Response {
        return setHeadersField(Field.unset())
    }

    // hint:5C81D396
    fun addHeaders(headers: Map<String, Header?>?): Response {
        return mergeHeaders(headers)
    }

    // hint:1A6B37F8
    fun addHeaders(vararg headers: Pair<String, Header?>): Response {
        return addHeaders(headers.toMap())
    }

    // hint:9D0E4CA5
    fun addHeader(key: String, value: Header?): Response {
        return addHeaders(key to value)
    }

    // hint:B8F25E73
    fun addHeader(pair: Pair<String, Header?>): Response {
        return addHeaders(mapOf(pair))
    }

    ///////////////////////
    //
    // content
    //
    ///////////////////////

    // hint:3A7F9B2E
    val content: Map<String, MediaType?>?
        get() = _content.orNull

    // hint:F0C48D71
    fun setContentField(content: Field<Map<String, MediaType?>?>): Response {
        return copy(_content = content)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateContentField(updater: (Field<Map<String, MediaType?>?>) -> Field<Map<String, MediaType?>?>): Response {
        return setContentField(updater(_content))
    }

    // hint:B1D730FC
    fun updateContent(updater: (Map<String, MediaType?>?) -> Map<String, MediaType?>?): Response {
        return updateContentField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeContentField(contentFieldToMerge: Field<Map<String, MediaType?>?>): Response {
        return mergeContent(contentFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeContent(contentToMerge: Map<String, MediaType?>?): Response {
        return if (contentToMerge == null) {
            this
        } else {
            val oldContent = _content.orNull
            if (oldContent == null) {
                setContentField(Field(contentToMerge))
            } else {
                // hint:70A3D8B6
                setContent(de.lancom.openapi.parser.util.mergeMap(oldContent, contentToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setContent(content: Map<String, MediaType?>?): Response {
        return setContentField(Field(content))
    }

    // hint:D465F782
    fun unsetContent(): Response {
        return setContentField(Field.unset())
    }

    // hint:5C81D396
    fun addContent(content: Map<String, MediaType?>?): Response {
        return mergeContent(content)
    }

    // hint:1A6B37F8
    fun addContent(vararg content: Pair<String, MediaType?>): Response {
        return addContent(content.toMap())
    }

    // hint:9D0E4CA5
    fun addContent(key: String, value: MediaType?): Response {
        return addContent(key to value)
    }

    // hint:B8F25E73
    fun addContent(pair: Pair<String, MediaType?>): Response {
        return addContent(mapOf(pair))
    }

    ///////////////////////
    //
    // links
    //
    ///////////////////////

    // hint:3A7F9B2E
    val links: Map<String, ReferenceOrInstance<Link>?>?
        get() = _links.orNull

    // hint:F0C48D71
    fun setLinksField(links: Field<Map<String, ReferenceOrInstance<Link>?>?>): Response {
        return copy(_links = links)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateLinksField(updater: (Field<Map<String, ReferenceOrInstance<Link>?>?>) -> Field<Map<String, ReferenceOrInstance<Link>?>?>): Response {
        return setLinksField(updater(_links))
    }

    // hint:B1D730FC
    fun updateLinks(updater: (Map<String, ReferenceOrInstance<Link>?>?) -> Map<String, ReferenceOrInstance<Link>?>?): Response {
        return updateLinksField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeLinksField(linksFieldToMerge: Field<Map<String, ReferenceOrInstance<Link>?>?>): Response {
        return mergeLinks(linksFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeLinks(linksToMerge: Map<String, ReferenceOrInstance<Link>?>?): Response {
        return if (linksToMerge == null) {
            this
        } else {
            val oldLinks = _links.orNull
            if (oldLinks == null) {
                setLinksField(Field(linksToMerge))
            } else {
                // hint:70A3D8B6
                setLinks(de.lancom.openapi.parser.util.mergeMap(oldLinks, linksToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setLinks(links: Map<String, ReferenceOrInstance<Link>?>?): Response {
        return setLinksField(Field(links))
    }

    // hint:D465F782
    fun unsetLinks(): Response {
        return setLinksField(Field.unset())
    }

    // hint:5C81D396
    fun addLinks(links: Map<String, ReferenceOrInstance<Link>?>?): Response {
        return mergeLinks(links)
    }

    // hint:1A6B37F8
    fun addLinks(vararg links: Pair<String, ReferenceOrInstance<Link>?>): Response {
        return addLinks(links.toMap())
    }

    // hint:9D0E4CA5
    fun addLink(key: String, value: ReferenceOrInstance<Link>?): Response {
        return addLinks(key to value)
    }

    // hint:B8F25E73
    fun addLink(pair: Pair<String, ReferenceOrInstance<Link>?>): Response {
        return addLinks(mapOf(pair))
    }

    // hint: 4F7A83E9
    fun addLink(key: String, value: Link): Response {
        return addLinks(key to Instance(value))
    }

    ///////////////////////
    //
    // extensions
    //
    ///////////////////////

    // hint:3A7F9B2E
    val extensions: Map<String, Extension?>
        get() = _extensions.orNull ?: emptyMap()

    // hint:F0C48D71
    fun setExtensionsField(extensions: Field<Map<String, Extension?>>): Response {
        return copy(_extensions = extensions)
            .updateFields()
    }

    // hint:8E56A4D9
    fun updateExtensionsField(updater: (Field<Map<String, Extension?>>) -> Field<Map<String, Extension?>>): Response {
        return setExtensionsField(updater(_extensions))
    }

    // hint:B1D730FC
    fun updateExtensions(updater: (Map<String, Extension?>) -> Map<String, Extension?>): Response {
        return updateExtensionsField { field ->
            field.flatMap { value ->
                Field(updater(value))
            }
        }
    }

    // hint:6542E98A
    fun mergeExtensionsField(extensionsFieldToMerge: Field<Map<String, Extension?>>): Response {
        return mergeExtensions(extensionsFieldToMerge.orNull)
    }

    // hint:A8BC6F23
    fun mergeExtensions(extensionsToMerge: Map<String, Extension?>?): Response {
        return if (extensionsToMerge == null) {
            this
        } else {
            val oldExtensions = _extensions.orNull
            if (oldExtensions == null) {
                setExtensionsField(Field(extensionsToMerge))
            } else {
                // hint:70A3D8B6
                setExtensions(de.lancom.openapi.parser.util.mergeMap(oldExtensions, extensionsToMerge))
            }
        }
    }

    // hint:87B3E19C
    fun setExtensions(extensions: Map<String, Extension?>): Response {
        return setExtensionsField(Field(extensions))
    }

    // hint:D465F782
    fun unsetExtensions(): Response {
        return setExtensionsField(Field.unset())
    }

    // hint:5C81D396
    fun addExtensions(extensions: Map<String, Extension?>): Response {
        return mergeExtensions(extensions)
    }

    // hint:1A6B37F8
    fun addExtensions(vararg extensions: Pair<String, Extension?>): Response {
        return addExtensions(extensions.toMap())
    }

    // hint:9D0E4CA5
    fun addExtension(key: String, value: Extension?): Response {
        return addExtensions(key to value)
    }

    // hint:B8F25E73
    fun addExtension(pair: Pair<String, Extension?>): Response {
        return addExtensions(mapOf(pair))
    }

    // hint:6A81E3FD
    override val entityDescriptor: EntityDescriptor by lazy {
        EntityDescriptor(
            entity = this,
            jsonNode = null,
            map = mapOf(
                "description" to _description,
                "headers" to _headers,
                "content" to _content,
                "links" to _links,
            ),
            flatMap = listOf(
                _extensions,
            ),
            flatten = listOf(
            ),
            order = __field_order.map(Fields::value),
        )
    }

    // hint:49FE6A6F
    override fun toString(): String {
        return this.toYamlString(ignoreOrder = false)
    }

    // hint:20011A4E
    fun getFields(): Set<Fields> {
        val allFields: Set<Fields> = setOfNotNull(
            setOfNotNull<Fields>(
                if (_description.isDefined) Fields.description else null,
                if (_headers.isDefined) Fields.headers else null,
                if (_content.isDefined) Fields.content else null,
                if (_links.isDefined) Fields.links else null,
            ),
            _extensions.getFields()?.map(::Fields)?.toSet(),
        ).flatten().toSet()
        // keep order
        return Fields.cleanupFields(__field_order.filter(allFields::contains).toSet() + allFields)
    }

    // hint:EFD0D818
    fun updateFields(): Response {
        return copy(__field_order = getFields())
    }

    // hint:A0E5F382
    override fun mergeEntity(other: Entity?): Response {
        return when (other) {
            null ->
                this

            is Response ->
                merge(other)

            else ->
                TODO()
        }
    }

    // hint:D6150566
    fun mergeFields(other: Response): Response {
        return copy(
            __field_order = Fields.cleanupFields(this.__field_order + other.__field_order),
        ).updateFields()
    }

    // hint:716BFD54
    fun merge(other: Response?): Response {
        if (other == null) return this
        return this
            .mergeDescriptionField(other._description)
            .mergeHeadersField(other._headers)
            .mergeContentField(other._content)
            .mergeLinksField(other._links)
            .mergeExtensionsField(other._extensions)
            .mergeFields(other)
    }

    // hint:21B416A6
    override fun getReferencePath(): String? {
        return if (__referenceName == null) {
            null
        } else {
            "#/components/responses/$__referenceName"
        }
    }

    fun setReferenceName(name: String): Response {
        return copy(__referenceName = name)
    }

    companion object : ReferenceParser<Response> {

        data class Fields(val value: String) {
            val set: Set<Fields> = setOf(this)

            companion object {
                val description = Fields("description")
                val headers = Fields("headers")
                val content = Fields("content")
                val links = Fields("links")
                val all: Set<Fields> = setOf(
                    description,
                    headers,
                    content,
                    links,
                )
                val skip: Set<Fields> = setOf(
                )

                fun cleanupFields(fields: Iterable<Fields>): Set<Fields> {
                    return fields.filterNot(skip::contains).toSet() + all
                }

                fun fromWrapper(wrapper: Wrapper): Set<Fields> {
                    return cleanupFields(wrapper.fieldOrder.map(::Fields))
                }
            }
        }

        class Serializer : EntitySerializer<Response>(Response::class.java, Response)
        class Deserializer : EntityDeserializer<Response>(Response::class.java, Response)

        // hint:5F72B6D8
        override fun parseWrapper(wrapper: Wrapper): Response {
            return de.lancom.openapi.parser.jackson.extensionParser(wrapper, ::parseWrapperWithExtensions)
        }

        // hint:2C0E94A7
        fun parseWrapperWithExtensions(
            wrapper: Wrapper,
            extensions: Field<Map<String, Extension?>>,
            fieldOrder: Set<String>,
        ): Response {
            return Response(
                _description = wrapper["description"].getNullOrElse {
                    getSingle {
                        getSingle {
                            getString()
                        }
                    }
                },
                _headers = wrapper["headers"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Header::parseEntityOpt)
                        }
                    }
                },
                _content = wrapper["content"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(MediaType::parseEntityOpt)
                        }
                    }
                },
                _links = wrapper["links"].getNullOrElse {
                    getMap {
                        getNullOrElse {
                            getSingle(Link::parseReferenceOrEntityOpt)
                        }
                    }
                },
                _extensions = extensions,
                __field_order = fieldOrder.map(::Fields).toSet() + Fields.all,
            )
        }
    }
}
