/*
 * Decompiled with CFR 0.152.
 */
package de.lancom.openapi.common.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a\u0019\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\f*\u00020\r*\u0002H\f\u00a2\u0006\u0002\u0010\u000e\u001a#\u0010\u000f\u001a\u00020\u0010\"\b\b\u0000\u0010\f*\u00020\r*\u0002H\f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0012\u001a\u0011\u0010\u0019\u001a\u0004\u0018\u00010\u0012*\u00020\u000b\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010\u001b\u001a\u00020\u0012*\u00020\u000b\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u000b\u001a\n\u0010\u001e\u001a\u00020\u0010*\u00020\u000b\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u0010*\u00020\u000b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0004\u001a\n \u0005*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0006\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\u00a8\u0006 "}, d2={"jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJsonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "jsonPrettyPrintMapper", "kotlin.jvm.PlatformType", "getJsonPrettyPrintMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "yamlMapper", "getYamlMapper", "toJsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "T", "", "(Ljava/lang/Object;)Lcom/fasterxml/jackson/databind/JsonNode;", "toYamlString", "", "ignoreOrder", "", "(Ljava/lang/Object;Z)Ljava/lang/String;", "deepSortJsonNode", "node", "objectMapper", "createObjectMapper", "yaml", "booleanValueOrErrorOpt", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Boolean;", "booleanValueOrError", "numberValueOrError", "", "textValueOrError", "textValueOrErrorOpt", "openapi-parser"})
@SourceDebugExtension(value={"SMAP\nJackson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jackson.kt\nde/lancom/openapi/common/util/JacksonKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1797#2,3:106\n1797#2,3:109\n*S KotlinDebug\n*F\n+ 1 Jackson.kt\nde/lancom/openapi/common/util/JacksonKt\n*L\n39#1:106,3\n47#1:109,3\n*E\n"})
public final class JacksonKt {
    @NotNull
    private static final ObjectMapper jsonMapper = JacksonKt.createObjectMapper(false);
    private static final ObjectMapper jsonPrettyPrintMapper = JacksonKt.createObjectMapper(false).enable(SerializationFeature.INDENT_OUTPUT);
    @NotNull
    private static final ObjectMapper yamlMapper = JacksonKt.createObjectMapper(true);

    @NotNull
    public static final ObjectMapper getJsonMapper() {
        return jsonMapper;
    }

    public static final ObjectMapper getJsonPrettyPrintMapper() {
        return jsonPrettyPrintMapper;
    }

    @NotNull
    public static final ObjectMapper getYamlMapper() {
        return yamlMapper;
    }

    @NotNull
    public static final <T> JsonNode toJsonNode(@NotNull T $this$toJsonNode) {
        Intrinsics.checkNotNullParameter($this$toJsonNode, (String)"<this>");
        JsonNode jsonNode = yamlMapper.valueToTree($this$toJsonNode);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"valueToTree(...)");
        return jsonNode;
    }

    @NotNull
    public static final <T> String toYamlString(@NotNull T $this$toYamlString, boolean ignoreOrder) {
        Intrinsics.checkNotNullParameter($this$toYamlString, (String)"<this>");
        return JacksonKt.toYamlString(JacksonKt.toJsonNode($this$toYamlString), ignoreOrder);
    }

    public static /* synthetic */ String toYamlString$default(Object object, boolean bl, int n, Object object2) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return JacksonKt.toYamlString(object, bl);
    }

    @NotNull
    public static final String toYamlString(@NotNull JsonNode $this$toYamlString, boolean ignoreOrder) {
        Intrinsics.checkNotNullParameter((Object)$this$toYamlString, (String)"<this>");
        JsonNode node = ignoreOrder ? JacksonKt.deepSortJsonNode($this$toYamlString, jsonMapper) : $this$toYamlString;
        String string = yamlMapper.writeValueAsString((Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    public static /* synthetic */ String toYamlString$default(JsonNode jsonNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return JacksonKt.toYamlString(jsonNode, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonNode deepSortJsonNode(@NotNull JsonNode node, @NotNull ObjectMapper objectMapper) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        if (node.isObject()) {
            void $this$fold$iv;
            Iterator iterator = node.fieldNames();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fieldNames(...)");
            Iterable iterable = CollectionsKt.sorted((Iterable)SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator)));
            ObjectNode initial$iv = objectMapper.createObjectNode();
            boolean $i$f$fold = false;
            ObjectNode accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void key;
                String string = (String)element$iv;
                ObjectNode sorted = accumulator$iv;
                boolean bl = false;
                JsonNode jsonNode2 = node.get((String)key);
                Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"get(...)");
                accumulator$iv = (ObjectNode)sorted.set((String)key, JacksonKt.deepSortJsonNode(jsonNode2, objectMapper));
            }
            ObjectNode objectNode = accumulator$iv;
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"fold(...)");
            jsonNode = (JsonNode)objectNode;
        } else if (node.isArray()) {
            Iterator iterator = node.elements();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
            Iterable $this$fold$iv = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
            ArrayNode initial$iv = objectMapper.createArrayNode();
            boolean $i$f$fold = false;
            ArrayNode accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void entry;
                JsonNode key = (JsonNode)element$iv;
                ArrayNode sorted = accumulator$iv;
                boolean bl = false;
                accumulator$iv = sorted.add(JacksonKt.deepSortJsonNode((JsonNode)entry, objectMapper));
            }
            ArrayNode arrayNode = accumulator$iv;
            Intrinsics.checkNotNullExpressionValue((Object)arrayNode, (String)"fold(...)");
            jsonNode = (JsonNode)arrayNode;
        } else {
            jsonNode = node;
        }
        return jsonNode;
    }

    @NotNull
    public static final ObjectMapper createObjectMapper(boolean yaml) {
        MapperBuilder mapperBuilder;
        if (yaml) {
            YAMLGenerator.Feature[] featureArray = new YAMLGenerator.Feature[]{YAMLGenerator.Feature.WRITE_DOC_START_MARKER};
            YAMLMapper.Builder builder = YAMLMapper.builder().disable(featureArray);
            featureArray = new YAMLGenerator.Feature[]{YAMLGenerator.Feature.MINIMIZE_QUOTES};
            YAMLMapper.Builder builder2 = builder.enable(featureArray);
            featureArray = new YAMLGenerator.Feature[]{YAMLGenerator.Feature.SPLIT_LINES};
            YAMLMapper.Builder builder3 = builder2.enable(featureArray);
            featureArray = new YAMLGenerator.Feature[]{YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS};
            mapperBuilder = (MapperBuilder)builder3.enable(featureArray);
        } else {
            mapperBuilder = (MapperBuilder)JsonMapper.builder();
        }
        MapperBuilder mapperBuilder2 = mapperBuilder;
        MapperFeature[] mapperFeatureArray = new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS};
        ObjectMapper objectMapper = mapperBuilder2.enable(mapperFeatureArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        return objectMapper;
    }

    @Nullable
    public static final Boolean booleanValueOrErrorOpt(@NotNull JsonNode $this$booleanValueOrErrorOpt) {
        Intrinsics.checkNotNullParameter((Object)$this$booleanValueOrErrorOpt, (String)"<this>");
        if ($this$booleanValueOrErrorOpt.isNull()) {
            return null;
        }
        return JacksonKt.booleanValueOrError($this$booleanValueOrErrorOpt);
    }

    public static final boolean booleanValueOrError(@NotNull JsonNode $this$booleanValueOrError) {
        Intrinsics.checkNotNullParameter((Object)$this$booleanValueOrError, (String)"<this>");
        if (!$this$booleanValueOrError.isBoolean()) {
            boolean bl = false;
            String string = "a boolean node is required";
            throw new IllegalArgumentException(string.toString());
        }
        return $this$booleanValueOrError.booleanValue();
    }

    @NotNull
    public static final Number numberValueOrError(@NotNull JsonNode $this$numberValueOrError) {
        Intrinsics.checkNotNullParameter((Object)$this$numberValueOrError, (String)"<this>");
        if (!$this$numberValueOrError.isNumber()) {
            boolean bl = false;
            String string = "a number node is required";
            throw new IllegalArgumentException(string.toString());
        }
        Number number = $this$numberValueOrError.numberValue();
        Intrinsics.checkNotNullExpressionValue((Object)number, (String)"numberValue(...)");
        return number;
    }

    @NotNull
    public static final String textValueOrError(@NotNull JsonNode $this$textValueOrError) {
        Intrinsics.checkNotNullParameter((Object)$this$textValueOrError, (String)"<this>");
        if (!$this$textValueOrError.isTextual()) {
            boolean bl = false;
            String string = "a textural node is required";
            throw new IllegalArgumentException(string.toString());
        }
        String string = $this$textValueOrError.textValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
        return string;
    }

    @Nullable
    public static final String textValueOrErrorOpt(@NotNull JsonNode $this$textValueOrErrorOpt) {
        Intrinsics.checkNotNullParameter((Object)$this$textValueOrErrorOpt, (String)"<this>");
        if ($this$textValueOrErrorOpt.isNull()) {
            return null;
        }
        return JacksonKt.textValueOrError($this$textValueOrErrorOpt);
    }
}

