/*
 * Decompiled with CFR 0.152.
 */
package de.lancom.openapi.parser.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.lancom.openapi.parser.entity.Entity;
import de.lancom.openapi.parser.jackson.Parser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\f\u001a\u00028\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lde/lancom/openapi/parser/jackson/EntityDeserializer;", "E", "Lde/lancom/openapi/parser/entity/Entity;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "clazz", "Ljava/lang/Class;", "parser", "Lde/lancom/openapi/parser/jackson/Parser;", "<init>", "(Ljava/lang/Class;Lde/lancom/openapi/parser/jackson/Parser;)V", "getParser", "()Lde/lancom/openapi/parser/jackson/Parser;", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/fasterxml/jackson/databind/DeserializationContext;)Lde/lancom/openapi/parser/entity/Entity;", "openapi-parser"})
public abstract class EntityDeserializer<E extends Entity>
extends StdDeserializer<E> {
    @NotNull
    private final Parser<E> parser;

    public EntityDeserializer(@NotNull Class<E> clazz, @NotNull Parser<E> parser) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        super(clazz);
        this.parser = parser;
    }

    @NotNull
    public final Parser<E> getParser() {
        return this.parser;
    }

    @NotNull
    public E deserialize(@Nullable JsonParser p, @Nullable DeserializationContext ctxt) {
        JsonParser jsonParser = p;
        Intrinsics.checkNotNull((Object)jsonParser);
        ObjectCodec objectCodec = jsonParser.getCodec();
        Intrinsics.checkNotNull((Object)objectCodec);
        TreeNode treeNode = objectCodec.readTree(p);
        Intrinsics.checkNotNull((Object)treeNode);
        JsonNode node = (JsonNode)treeNode;
        return this.parser.parseJsonNode(node);
    }
}

