/*
 * Decompiled with CFR 0.152.
 */
package de.lancom.openapi.parser.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.lancom.openapi.common.util.CollectionsKt;
import de.lancom.openapi.common.util.JacksonKt;
import de.lancom.openapi.parser.entity.Entity;
import de.lancom.openapi.parser.entity.Extension;
import de.lancom.openapi.parser.entity.RawExtension;
import de.lancom.openapi.parser.entity.TagGroupsExtension;
import de.lancom.openapi.parser.field.Field;
import de.lancom.openapi.parser.field.FieldSetKt;
import de.lancom.openapi.parser.jackson.Wrapper;
import de.lancom.openapi.parser.ref.Instance;
import de.lancom.openapi.parser.ref.Reference;
import de.lancom.openapi.parser.ref.ReferenceOrInstance;
import de.lancom.openapi.parser.ref.Referenceable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 P2\u00020\u0001:\u0001PB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000bH\u0086\u0002J=\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H!0\u00140\u0003\"\u0004\b\u0000\u0010!2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00030#\u00a2\u0006\u0002\b$JW\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H!0\u00140\u0003\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010!2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H%0#2\u001d\u0010'\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00030#\u00a2\u0006\u0002\b$J7\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00180\u0003\"\u0004\b\u0000\u0010!2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00030#\u00a2\u0006\u0002\b$J1\u0010)\u001a\b\u0012\u0004\u0012\u0002H!0\u0003\"\u0004\b\u0000\u0010!2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00030#\u00a2\u0006\u0002\b$JO\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H!0\u00140\u0003\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010!2)\u0010\"\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H!0\u00140\u00030#\u00a2\u0006\u0002\b$J7\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\n0\u0003\"\u0004\b\u0000\u0010!2\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0\u00030#\u00a2\u0006\u0002\b$J\u0016\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H-0\u0003\"\u0004\b\u0000\u0010-H\u0002J=\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H-0\u0003\"\u000e\b\u0000\u0010-*\b\u0012\u0004\u0012\u0002H-0/2\u001d\u00100\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0\u00030#\u00a2\u0006\u0002\b$JQ\u00101\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H!\u0018\u00010\u00140\u0003\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010!2)\u00100\u001a%\u0012\u0004\u0012\u00020\u0000\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H!0\u00140\u00030#\u00a2\u0006\u0002\b$J3\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H-0\u0003\"\u0004\b\u0000\u0010-2\u001d\u00100\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0\u00030#\u00a2\u0006\u0002\b$J1\u00103\u001a\b\u0012\u0004\u0012\u0002H-0\u0003\"\u0004\b\u0000\u0010-2\u001d\u00100\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-0\u00030#\u00a2\u0006\u0002\b$J/\u00104\u001a\b\u0012\u0004\u0012\u0002H-0\u0003\"\b\b\u0000\u0010-*\u0002052\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H-0#\u00a2\u0006\u0002\b$J\u001c\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H9080\u0003\"\b\b\u0000\u00109*\u00020:J5\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H90<0\u0003\"\b\b\u0000\u00109*\u00020:2\u0017\u00106\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H90#\u00a2\u0006\u0002\b$J\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u0003J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003J\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u0003J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u0003J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u0003J:\u0010F\u001a\b\u0012\u0004\u0012\u0002H-0\u0003\"\u0010\b\u0000\u0010-\u0018\u0001*\b\u0012\u0004\u0012\u0002H-0G2\u0014\b\b\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H-0#H\u0086\b\u00f8\u0001\u0000J\u001a\u0010H\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010I0\u00140\u0003J\u000f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010K\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010L\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010N\u001a\u00020CH\u00d6\u0001J\t\u0010O\u001a\u00020\u000bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\bR-\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00000\u00140\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0015\u0010\bR'\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u00180\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0019\u0010\bR!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000f\u001a\u0004\b\u001c\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006Q"}, d2={"Lde/lancom/openapi/parser/jackson/Wrapper;", "", "jsonNodeField", "Lde/lancom/openapi/parser/field/Field;", "Lcom/fasterxml/jackson/databind/JsonNode;", "<init>", "(Lde/lancom/openapi/parser/field/Field;)V", "getJsonNodeField", "()Lde/lancom/openapi/parser/field/Field;", "fieldOrder", "", "", "getFieldOrder", "()Ljava/util/Set;", "fieldOrder$delegate", "Lkotlin/Lazy;", "field", "getField", "field$delegate", "mapField", "", "getMapField", "mapField$delegate", "listField", "", "getListField", "listField$delegate", "jsonNodeFieldOrUnsetIfEmpty", "getJsonNodeFieldOrUnsetIfEmpty", "jsonNodeFieldOrUnsetIfEmpty$delegate", "get", "fieldName", "getMap", "V", "mapper", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "K", "keyMapper", "valueMapper", "getList", "getSingle", "getUnlessEmpty", "getSet", "getNull", "E", "getNullOrElseUnsetIfEmptyCollection", "", "fallback", "getNullOrElseUnsetIfEmptyMap", "getNullOrElse", "getElse", "getEntity", "Lde/lancom/openapi/parser/entity/Entity;", "transform", "getReference", "Lde/lancom/openapi/parser/ref/Reference;", "R", "Lde/lancom/openapi/parser/ref/Referenceable;", "getReferenceOrEntity", "Lde/lancom/openapi/parser/ref/ReferenceOrInstance;", "getBoolean", "", "getString", "getNumber", "", "getInt", "", "getDouble", "", "getEnum", "", "getExtensions", "Lde/lancom/openapi/parser/entity/Extension;", "component1", "copy", "equals", "other", "hashCode", "toString", "Companion", "openapi-parser"})
@SourceDebugExtension(value={"SMAP\nWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Wrapper.kt\nde/lancom/openapi/parser/jackson/Wrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,269:1\n1557#2:270\n1628#2,3:271\n1187#2,2:274\n1261#2,4:276\n1557#2:280\n1628#2,3:281\n1557#2:288\n1628#2,3:289\n126#3:284\n153#3,3:285\n126#3:299\n153#3,3:300\n535#4:292\n520#4,6:293\n*S KotlinDebug\n*F\n+ 1 Wrapper.kt\nde/lancom/openapi/parser/jackson/Wrapper\n*L\n21#1:270\n21#1:271,3\n31#1:274,2\n31#1:276,4\n39#1:280\n39#1:281,3\n79#1:288\n79#1:289,3\n69#1:284\n69#1:285,3\n227#1:299\n227#1:300,3\n225#1:292\n225#1:293,6\n*E\n"})
public final class Wrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Field<JsonNode> jsonNodeField;
    @NotNull
    private final Lazy fieldOrder$delegate;
    @NotNull
    private final Lazy field$delegate;
    @NotNull
    private final Lazy mapField$delegate;
    @NotNull
    private final Lazy listField$delegate;
    @NotNull
    private final Lazy jsonNodeFieldOrUnsetIfEmpty$delegate;
    @NotNull
    private static final Wrapper UNSET = new Wrapper(Field.Companion.unset());

    public Wrapper(@NotNull Field<JsonNode> jsonNodeField) {
        Intrinsics.checkNotNullParameter(jsonNodeField, (String)"jsonNodeField");
        this.jsonNodeField = jsonNodeField;
        this.fieldOrder$delegate = LazyKt.lazy(() -> Wrapper.fieldOrder_delegate$lambda$1(this));
        this.field$delegate = LazyKt.lazy(() -> Wrapper.field_delegate$lambda$2(this));
        this.mapField$delegate = LazyKt.lazy(() -> Wrapper.mapField_delegate$lambda$5(this));
        this.listField$delegate = LazyKt.lazy(() -> Wrapper.listField_delegate$lambda$8(this));
        this.jsonNodeFieldOrUnsetIfEmpty$delegate = LazyKt.lazy(() -> Wrapper.jsonNodeFieldOrUnsetIfEmpty_delegate$lambda$10(this));
    }

    @NotNull
    public final Field<JsonNode> getJsonNodeField() {
        return this.jsonNodeField;
    }

    @NotNull
    public final Set<String> getFieldOrder() {
        Lazy lazy = this.fieldOrder$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final Field<Wrapper> getField() {
        Lazy lazy = this.field$delegate;
        return (Field)lazy.getValue();
    }

    @NotNull
    public final Field<Map<String, Wrapper>> getMapField() {
        Lazy lazy = this.mapField$delegate;
        return (Field)lazy.getValue();
    }

    @NotNull
    public final Field<List<Wrapper>> getListField() {
        Lazy lazy = this.listField$delegate;
        return (Field)lazy.getValue();
    }

    @NotNull
    public final Field<JsonNode> getJsonNodeFieldOrUnsetIfEmpty() {
        Lazy lazy = this.jsonNodeFieldOrUnsetIfEmpty$delegate;
        return (Field)lazy.getValue();
    }

    @NotNull
    public final Wrapper get(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Field wrapperField = this.getMapField().flatMap(arg_0 -> Wrapper.get$lambda$11(fieldName, arg_0));
        return (Wrapper)wrapperField.getOrElse(Wrapper::get$lambda$12);
    }

    @NotNull
    public final <V> Field<Map<String, V>> getMap(@NotNull Function1<? super Wrapper, ? extends Field<V>> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return this.getMap(Wrapper::getMap$lambda$13, mapper);
    }

    @NotNull
    public final <K, V> Field<Map<K, V>> getMap(@NotNull Function1<? super String, ? extends K> keyMapper, @NotNull Function1<? super Wrapper, ? extends Field<V>> valueMapper) {
        Intrinsics.checkNotNullParameter(keyMapper, (String)"keyMapper");
        Intrinsics.checkNotNullParameter(valueMapper, (String)"valueMapper");
        return this.getMapField().map(arg_0 -> Wrapper.getMap$lambda$15(keyMapper, valueMapper, arg_0));
    }

    @NotNull
    public final <V> Field<List<V>> getList(@NotNull Function1<? super Wrapper, ? extends Field<V>> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return this.getListField().map(arg_0 -> Wrapper.getList$lambda$17(mapper, arg_0));
    }

    @NotNull
    public final <V> Field<V> getSingle(@NotNull Function1<? super Wrapper, ? extends Field<V>> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return this.getMapField().flatMap(arg_0 -> Wrapper.getSingle$lambda$18(mapper, this, arg_0));
    }

    @NotNull
    public final <K, V> Field<Map<K, V>> getUnlessEmpty(@NotNull Function1<? super Wrapper, ? extends Field<Map<K, V>>> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return this.getMapField().flatMap(arg_0 -> Wrapper.getUnlessEmpty$lambda$20(mapper, this, arg_0));
    }

    @NotNull
    public final <V> Field<Set<V>> getSet(@NotNull Function1<? super Wrapper, ? extends Field<V>> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return this.getList(mapper).map(getSet.1.INSTANCE);
    }

    private final <E> Field<E> getNull() {
        return this.jsonNodeField.flatMap(Wrapper::getNull$lambda$21);
    }

    @NotNull
    public final <E extends Collection<? extends E>> Field<E> getNullOrElseUnsetIfEmptyCollection(@NotNull Function1<? super Wrapper, ? extends Field<E>> fallback) {
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        return this.getNullOrElse(arg_0 -> Wrapper.getNullOrElseUnsetIfEmptyCollection$lambda$23(fallback, arg_0));
    }

    @NotNull
    public final <K, V> Field<Map<K, V>> getNullOrElseUnsetIfEmptyMap(@NotNull Function1<? super Wrapper, ? extends Field<Map<K, V>>> fallback) {
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        return this.getNullOrElse(arg_0 -> Wrapper.getNullOrElseUnsetIfEmptyMap$lambda$25(fallback, arg_0));
    }

    @NotNull
    public final <E> Field<E> getNullOrElse(@NotNull Function1<? super Wrapper, ? extends Field<E>> fallback) {
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        return this.getNull().orElse(() -> Wrapper.getNullOrElse$lambda$26(this, fallback));
    }

    @NotNull
    public final <E> Field<E> getElse(@NotNull Function1<? super Wrapper, ? extends Field<E>> fallback) {
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        return this.jsonNodeField.flatMap(arg_0 -> Wrapper.getElse$lambda$27(fallback, this, arg_0));
    }

    @NotNull
    public final <E extends Entity> Field<E> getEntity(@NotNull Function1<? super Wrapper, ? extends E> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return this.getMapField().map(arg_0 -> Wrapper.getEntity$lambda$28(transform, this, arg_0));
    }

    @NotNull
    public final <R extends Referenceable> Field<Reference<R>> getReference() {
        return this.getMapField().flatMap(arg_0 -> Wrapper.getReference$lambda$30(this, arg_0));
    }

    @NotNull
    public final <R extends Referenceable> Field<ReferenceOrInstance<R>> getReferenceOrEntity(@NotNull Function1<? super Wrapper, ? extends R> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return this.getReference().map(Wrapper::getReferenceOrEntity$lambda$31).orElse(() -> Wrapper.getReferenceOrEntity$lambda$33(this, transform));
    }

    @NotNull
    public final Field<Boolean> getBoolean() {
        return this.jsonNodeField.map(getBoolean.1.INSTANCE);
    }

    @NotNull
    public final Field<String> getString() {
        return this.jsonNodeField.map(Wrapper::getString$lambda$34);
    }

    @NotNull
    public final Field<Number> getNumber() {
        return this.jsonNodeField.map(getNumber.1.INSTANCE);
    }

    @NotNull
    public final Field<Integer> getInt() {
        return this.getNumber().map(Wrapper::getInt$lambda$35);
    }

    @NotNull
    public final Field<Double> getDouble() {
        return this.getNumber().map(Wrapper::getDouble$lambda$36);
    }

    public final /* synthetic */ <E extends Enum<E>> Field<E> getEnum(Function1<? super String, ? extends E> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$getEnum = false;
        return this.getString().map(transform);
    }

    @NotNull
    public final Field<Map<String, Extension>> getExtensions() {
        return this.getMapField().flatMap(Wrapper::getExtensions$lambda$40);
    }

    @NotNull
    public final Field<JsonNode> component1() {
        return this.jsonNodeField;
    }

    @NotNull
    public final Wrapper copy(@NotNull Field<JsonNode> jsonNodeField) {
        Intrinsics.checkNotNullParameter(jsonNodeField, (String)"jsonNodeField");
        return new Wrapper(jsonNodeField);
    }

    public static /* synthetic */ Wrapper copy$default(Wrapper wrapper, Field field2, int n, Object object) {
        if ((n & 1) != 0) {
            field2 = wrapper.jsonNodeField;
        }
        return wrapper.copy(field2);
    }

    @NotNull
    public String toString() {
        return "Wrapper(jsonNodeField=" + this.jsonNodeField + ")";
    }

    public int hashCode() {
        return this.jsonNodeField.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Wrapper)) {
            return false;
        }
        Wrapper wrapper = (Wrapper)other;
        return Intrinsics.areEqual(this.jsonNodeField, wrapper.jsonNodeField);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set fieldOrder_delegate$lambda$1(Wrapper this$0) {
        Object object;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                object = this$0.jsonNodeField.getOrNull();
                if (object == null || (object = object.fields()) == null || (object = SequencesKt.asSequence((Iterator)object)) == null || (object = SequencesKt.toList((Sequence)object)) == null) break block3;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry);
                    String key = (String)entry.getKey();
                    collection.add(key);
                }
                object = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                if (object != null) break block4;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    private static final Field field_delegate$lambda$2(Wrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.jsonNodeField.mapField(field.2.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map mapField_delegate$lambda$5$lambda$4(JsonNode jsonNode) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        Iterator iterator = jsonNode.fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
        Iterable $this$associate$iv = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            String k = (String)entry.getKey();
            JsonNode v = (JsonNode)entry.getValue();
            Intrinsics.checkNotNull((Object)v);
            entry = TuplesKt.to((Object)k, (Object)Companion.invoke(v));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Field mapField_delegate$lambda$5(Wrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.jsonNodeField.map(Wrapper::mapField_delegate$lambda$5$lambda$4);
    }

    /*
     * WARNING - void declaration
     */
    private static final List listField_delegate$lambda$8$lambda$7(JsonNode jsonNode) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        Iterator iterator = jsonNode.elements();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"elements(...)");
        Iterable iterable = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator));
        Field.Companion companion = Field.Companion;
        boolean $i$f$map22 = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.invoke(p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Object item$iv$iv2;
            item$iv$iv2 = (Field)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new Wrapper((Field<JsonNode>)p0));
        }
        return (List)destination$iv$iv2;
    }

    private static final Field listField_delegate$lambda$8(Wrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.jsonNodeField.map(Wrapper::listField_delegate$lambda$8$lambda$7);
    }

    private static final boolean jsonNodeFieldOrUnsetIfEmpty_delegate$lambda$10$lambda$9(JsonNode jsonNode) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        return jsonNode instanceof ObjectNode && ((ObjectNode)jsonNode).isEmpty();
    }

    private static final Field jsonNodeFieldOrUnsetIfEmpty_delegate$lambda$10(Wrapper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.jsonNodeField.takeUnlessField((Function1<JsonNode, Boolean>)((Function1)Wrapper::jsonNodeFieldOrUnsetIfEmpty_delegate$lambda$10$lambda$9));
    }

    private static final Field get$lambda$11(String $fieldName, Map map) {
        Intrinsics.checkNotNullParameter((Object)$fieldName, (String)"$fieldName");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        return Field.Companion.unsetIfNull(map.get($fieldName));
    }

    private static final Wrapper get$lambda$12() {
        return UNSET;
    }

    private static final String getMap$lambda$13(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getMap$lambda$15(Function1 $keyMapper, Function1 $valueMapper, Map map) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$keyMapper, (String)"$keyMapper");
        Intrinsics.checkNotNullParameter((Object)$valueMapper, (String)"$valueMapper");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Map $this$map$iv = map;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Wrapper wrapper = (Wrapper)entry.getValue();
            collection.add(TuplesKt.to((Object)$keyMapper.invoke((Object)key), (Object)$valueMapper.invoke((Object)wrapper)));
        }
        return FieldSetKt.getFields(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List getList$lambda$17(Function1 $mapper, List list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$mapper, (String)"$mapper");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void wrapper;
            Wrapper wrapper2 = (Wrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Field)$mapper.invoke((Object)wrapper));
        }
        return FieldSetKt.getFields((List)destination$iv$iv);
    }

    private static final Field getSingle$lambda$18(Function1 $mapper, Wrapper this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)$mapper, (String)"$mapper");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Field)$mapper.invoke((Object)this$0);
    }

    private static final Field getUnlessEmpty$lambda$20$lambda$19(Map map) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        return Field.Companion.takeUnlessEmpty(map);
    }

    private static final Field getUnlessEmpty$lambda$20(Function1 $mapper, Wrapper this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)$mapper, (String)"$mapper");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Field)$mapper.invoke((Object)this$0)).flatMap(Wrapper::getUnlessEmpty$lambda$20$lambda$19);
    }

    private static final Field getNull$lambda$21(JsonNode jsonNode) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        return jsonNode.isNull() ? Field.Companion.invoke(null) : Field.Companion.unset();
    }

    private static final Field getNullOrElseUnsetIfEmptyCollection$lambda$23$lambda$22(Collection collection) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        return Field.Companion.unsetIfNull(CollectionsKt.takeUnlessEmpty(collection));
    }

    private static final Field getNullOrElseUnsetIfEmptyCollection$lambda$23(Function1 $fallback, Wrapper $this$getNullOrElse) {
        Intrinsics.checkNotNullParameter((Object)$fallback, (String)"$fallback");
        Intrinsics.checkNotNullParameter((Object)$this$getNullOrElse, (String)"$this$getNullOrElse");
        return ((Field)$fallback.invoke((Object)$this$getNullOrElse)).flatMap(Wrapper::getNullOrElseUnsetIfEmptyCollection$lambda$23$lambda$22);
    }

    private static final Field getNullOrElseUnsetIfEmptyMap$lambda$25$lambda$24(Map collection) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        return Field.Companion.unsetIfNull(CollectionsKt.takeUnlessEmpty(collection));
    }

    private static final Field getNullOrElseUnsetIfEmptyMap$lambda$25(Function1 $fallback, Wrapper $this$getNullOrElse) {
        Intrinsics.checkNotNullParameter((Object)$fallback, (String)"$fallback");
        Intrinsics.checkNotNullParameter((Object)$this$getNullOrElse, (String)"$this$getNullOrElse");
        return ((Field)$fallback.invoke((Object)$this$getNullOrElse)).flatMap(Wrapper::getNullOrElseUnsetIfEmptyMap$lambda$25$lambda$24);
    }

    private static final Field getNullOrElse$lambda$26(Wrapper this$0, Function1 $fallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fallback, (String)"$fallback");
        Field field2 = this$0.getElse($fallback);
        Intrinsics.checkNotNull(field2, (String)"null cannot be cast to non-null type de.lancom.openapi.parser.field.Field<E of de.lancom.openapi.parser.jackson.Wrapper.getNullOrElse$lambda$26?>");
        return field2;
    }

    private static final Field getElse$lambda$27(Function1 $fallback, Wrapper this$0, JsonNode it) {
        Intrinsics.checkNotNullParameter((Object)$fallback, (String)"$fallback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Field)$fallback.invoke((Object)this$0);
    }

    private static final Entity getEntity$lambda$28(Function1 $transform, Wrapper this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)$transform, (String)"$transform");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Entity)$transform.invoke((Object)this$0);
    }

    private static final Reference getReference$lambda$30$lambda$29(String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return Reference.Companion.invoke(ref);
    }

    private static final Field getReference$lambda$30(Wrapper this$0, Map mapped) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)mapped, (String)"mapped");
        return mapped.size() == 1 ? this$0.get("$ref").getString().map(Wrapper::getReference$lambda$30$lambda$29) : Field.Companion.unset();
    }

    private static final ReferenceOrInstance getReferenceOrEntity$lambda$31(ReferenceOrInstance ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return ref;
    }

    private static final ReferenceOrInstance getReferenceOrEntity$lambda$33$lambda$32(Referenceable entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return new Instance<Referenceable>(entity);
    }

    private static final Field getReferenceOrEntity$lambda$33(Wrapper this$0, Function1 $transform) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$transform, (String)"$transform");
        return this$0.getEntity($transform).map(Wrapper::getReferenceOrEntity$lambda$33$lambda$32);
    }

    private static final String getString$lambda$34(JsonNode jsonNode) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        return jsonNode.isBoolean() ? String.valueOf(jsonNode.booleanValue()) : (jsonNode.isNumber() ? jsonNode.numberValue().toString() : JacksonKt.textValueOrError(jsonNode));
    }

    private static final int getInt$lambda$35(Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return number.intValue();
    }

    private static final double getDouble$lambda$36(Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return number.doubleValue();
    }

    private static final Pair getExtensions$lambda$40$lambda$39$lambda$38(String $name, Wrapper $wrapper, JsonNode value) {
        Extension extension;
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$wrapper, (String)"$wrapper");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)$name, (Object)"x-tagGroups")) {
            extension = TagGroupsExtension.Companion.parseWrapper($wrapper);
        } else if (value.isNull()) {
            extension = null;
        } else if (value.isNumber() || value.isTextual() || value.isBoolean() || value.isArray() || value.isObject()) {
            extension = new RawExtension(Field.Companion.invoke(value), null, 2, null);
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        Extension extension2 = extension;
        return TuplesKt.to((Object)$name, (Object)extension2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Field getExtensions$lambda$40(Map mapped) {
        void $this$mapTo$iv$iv;
        String name;
        Map.Entry entry;
        Map $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mapped, (String)"mapped");
        Map $this$filter$iv = mapped;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator.next();
            boolean bl = false;
            name = (String)entry.getKey();
            if (!StringsKt.startsWith$default((String)name, (String)"x-", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            name = (String)entry.getKey();
            Wrapper wrapper = (Wrapper)entry.getValue();
            object.add(wrapper.jsonNodeField.map(arg_0 -> Wrapper.getExtensions$lambda$40$lambda$39$lambda$38(name, wrapper, arg_0)));
        }
        List extensions = (List)destination$iv$iv;
        return Field.Companion.unsetIfNull(CollectionsKt.takeUnlessEmpty(MapsKt.toMap((Iterable)FieldSetKt.getFields(extensions))));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lde/lancom/openapi/parser/jackson/Wrapper$Companion;", "", "<init>", "()V", "invoke", "Lde/lancom/openapi/parser/jackson/Wrapper;", "jsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "UNSET", "getUNSET", "()Lde/lancom/openapi/parser/jackson/Wrapper;", "parseJsonString", "json", "", "openapi-parser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Wrapper invoke(@NotNull JsonNode jsonNode) {
            Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
            return new Wrapper(Field.Companion.invoke(jsonNode));
        }

        @NotNull
        public final Wrapper getUNSET() {
            return UNSET;
        }

        @NotNull
        public final Wrapper parseJsonString(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JsonNode tree = JacksonKt.getJsonMapper().readTree(json);
            Intrinsics.checkNotNull((Object)tree);
            return Companion.invoke(tree);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

