package com.liecoder.framework.application

import android.app.Activity
import android.app.Application
import com.liecoder.framework.global.AppHelper
import com.liecoder.framework.manager.DeviceInfoManager
import com.liecoder.framework.manager.LifecycleManager
import com.liecoder.framework.model.AppStatus
import com.liecoder.framework.service.IAppStatusService
import com.liecoder.framework.toast.TipsToast

/**
 * Author: liecoder
 * Date: 2024/8/19 周一
 * Version: 1.0
 */
class BaseApplication : Application(), IAppStatusService {

    override fun onCreate() {
        super.onCreate()
        AppHelper.init(application = this)
        LifecycleManager.register(mService = this)
        TipsToast.init(context = this)
        DeviceInfoManager.init(context = this)
    }

    override fun onAppStatusChanged(appStatus: AppStatus, activity: Activity) {

    }
}