package com.liecoder.framework.base

import android.annotation.SuppressLint
import android.content.pm.ActivityInfo
import android.graphics.Color
import android.os.Bundle
import android.view.Window
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import com.liecoder.framework.ktx.i
import com.liecoder.framework.dialog.LoadingView
import com.liecoder.framework.titlebar.ITitleBarClickListener
import com.liecoder.framework.titlebar.TitleBar
import com.liecoder.framework.utils.StatusBarUtils
import com.yinglan.keyboard.HideUtil
import net.yslibrary.android.keyboardvisibilityevent.KeyboardVisibilityEvent
import net.yslibrary.android.keyboardvisibilityevent.KeyboardVisibilityEventListener
import net.yslibrary.android.keyboardvisibilityevent.Unregistrar

/**
 * Author: liecoder
 * Date: 2024/6/20 周四
 * Version: 1.0
 */
abstract class BaseActivity : BasePermissionActivity(), IBaseService, LifecycleEventObserver,
                              ITitleBarClickListener, KeyboardVisibilityEventListener {

    private var unregistrar: Unregistrar? = null
    var keyBoardVisible: Boolean = false

    private val mLoadingView: LoadingView by lazy { LoadingView(mContext = this) }

    @SuppressLint("SourceLockedOrientationActivity")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
        setContentView()
        init()
        setupViews()
        loadData()
        setupStatusBar()
        lifecycle.addObserver(this)
        HideUtil.init(this)
        unregistrar = KeyboardVisibilityEvent.registerEventListener(
            this,
            this
        )
    }

    override fun init() {
    }

    override fun setupViews() {
    }

    override fun loadData() {
    }

    override fun setupStatusBar() = StatusBarUtils.setStatusBar(
        activity = this,
        darkContent = statusBarDarkContent(),
        statusBarColor = statusBarColor(),
        translucent = statusBarTranslucent()
    )

    override fun statusBarDarkContent(): Boolean = true

    override fun statusBarColor(): Int = Color.WHITE

    override fun statusBarTranslucent(): Boolean = false

    override fun onStateChanged(
        source: LifecycleOwner,
        event: Lifecycle.Event
    ) {
        i("ActivityStateChanged: $event")
        if (event == Lifecycle.Event.ON_DESTROY) unregistrar?.unregister()
    }

    override fun onVisibilityChanged(isOpen: Boolean) {
        i("KeyboardStateChanged: isVisible = $isOpen")
        keyBoardVisible = isOpen
    }

    override fun onLeftClick(titleBar: TitleBar) {
        super.onLeftClick(titleBar)
        finish()
    }

    override fun onTitleClick(titleBar: TitleBar) {
        super.onTitleClick(titleBar)
    }

    override fun onRightClick(titleBar: TitleBar) {
        super.onRightClick(titleBar)
    }

    override fun showLoading(
        show: Boolean,
        message: String?
    ) {
        if (!show) return hideLoading()
        mLoadingView.show(message = message)
    }

    override fun hideLoading() = mLoadingView.dismiss()
}