package com.liecoder.framework.base

import android.view.LayoutInflater
import androidx.viewbinding.ViewBinding
import java.lang.reflect.ParameterizedType
import java.lang.reflect.Type

/**
 * Author: liecoder
 * Date: 2024/6/21 周五
 * Version: 1.0
 */
@Suppress("UNCHECKED_CAST")
abstract class BaseViewBindingActivity<VB : ViewBinding> : BaseActivity(), IViewBindingService {


    override lateinit var mBinding: VB

    override fun setContentView() {
        mBinding = viewBinding()
        setContentView(mBinding.root)
    }

    override fun viewBinding(): VB {
        val binding: VB
        val type: Type = javaClass.genericSuperclass!!
        val clazz: Class<VB> = ((type as ParameterizedType).actualTypeArguments[0] as Class<VB>)
        val inflateMethod = clazz.getDeclaredMethod(
            "inflate",
            LayoutInflater::class.java
        )
        binding = inflateMethod.invoke(this, layoutInflater) as VB
        return binding
    }

}