package com.liecoder.framework.base

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.animation.Animation
import androidx.viewbinding.ViewBinding
import com.liecoder.framework.ktx.saveAs
import com.liecoder.framework.ktx.saveAsUnchecked
import razerdp.basepopup.BasePopupWindow
import java.lang.reflect.ParameterizedType


abstract class BaseWindow<VB : ViewBinding>(context: Context) : BasePopupWindow(context),
                                                                IBaseWindowService {

    protected var mBinding: VB

    init {
        val type = javaClass.genericSuperclass
        val vbClass: Class<VB> =
            type!!.saveAs<ParameterizedType>().actualTypeArguments[0].saveAsUnchecked()
        val method = vbClass.getDeclaredMethod(
            "inflate",
            LayoutInflater::class.java
        )
        method.isAccessible = true
        mBinding = method.invoke(null, LayoutInflater.from(context))!!.saveAsUnchecked()
        setOverlayNavigationBar(true)
        popupGravity = gravity()
        initView()
        contentView = mBinding.root
    }

    override fun show(anchorView: View?) {
        updateView()
        showPopupWindow(anchorView)
    }

    override fun onCreateShowAnimation(): Animation? = showAnimation()

    override fun onCreateDismissAnimation(): Animation? = dismissAnimation()

}