package com.liecoder.framework.base

import android.view.Gravity
import android.view.View
import android.view.animation.Animation
import razerdp.util.animation.AnimationHelper
import razerdp.util.animation.TranslationConfig

/**
 * Author: liecoder
 * Date: 2024/7/3 周三
 * Version: 1.0
 */
interface IBaseWindowService {

    fun initView()

    fun updateView()

    fun show(anchorView: View? = null)

    fun gravity(): Int = Gravity.BOTTOM

    fun showAnimation(): Animation? =
        AnimationHelper.asAnimation().withTranslation(TranslationConfig.FROM_BOTTOM).toShow()

    fun dismissAnimation(): Animation? =
        AnimationHelper.asAnimation().withTranslation(TranslationConfig.TO_BOTTOM).toDismiss()

}