package com.liecoder.framework.base

import androidx.activity.result.ActivityResultLauncher
import com.liecoder.framework.model.Permission

/**
 * Author: liecoder
 * Date: 2024/6/21 周五
 * Version: 1.0
 */
interface IPermissionService {

    /**
     * 注册一个 ActivityResultLauncher 用于请求运行时权限
     */
    fun registerPermissionLauncher(): ActivityResultLauncher<String>

    /**
     * 处理权限请求逻辑，包括权限已授予、需要显示权限说明对话框或请求权限
     */
    fun withPermission(
        permission: Permission,
        onPermissionGranted: () -> Unit,
        onPermissionDenied: (() -> Unit)? = null
    )

    /**
     * 显示权限请求的说明对话框（用户已拒绝过该权限）
     */
    fun showRequestPermissionRationaleDialog(permission: Permission)

    /**
     * 引导用户前往应用的权限设置页面
     */
    fun grantingPermissions()

    /**
     * 获取为什么需要特定权限的解释说明
     */
    fun getExplanationForSensitiveInformation(permission: Permission): String?

    /**
     * 解释对敏感信息的访问权限
     */
    fun explainAccessToMoreSensitiveInformation(permission: Permission)

}