package com.liecoder.framework.dialog

import android.app.Activity
import android.content.Context

class LoadingView(private val mContext: Context) {

    private var loadingView: LoadingDialog? = null

    fun show(message: String? = null) {
        if (mContext is Activity && mContext.isFinishing) return
        if (loadingView == null) {
            loadingView = LoadingDialog(mContext)
        }
        loadingView?.setLoadingMessage(message)
        if (loadingView?.isShowing != true) {
            loadingView?.show()
        }
    }

    fun dismiss() {
        if (mContext is Activity && mContext.isFinishing) return
        loadingView?.let {
            if (it.isShowing) it.dismiss()
        }
    }

}
