package com.liecoder.framework.ktx

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.core.app.ActivityCompat


/**
 * 启动一个 Activity，并确保其兼容性。
 *
 * 此函数使用 ActivityCompat 的 startActivity 方法来启动 Activity，这可以确保在不同版本的 Android 上均能正常工作。
 * 在启动前，会检查是否存在能够处理 Intent 的 Activity，如果不存在，则抛出异常。
 *
 * @param intent 用于启动 Activity 的 Intent 对象。
 * @param options 一个 Bundle 对象，包含启动 Activity 时的动画效果等附加选项。默认为 null。
 */
fun Context.startActivityCompat(intent: Intent, options: Bundle? = null) =
    if (intent.resolveActivity(packageManager) != null) {
        ActivityCompat.startActivity(this, intent, options)
    } else {
        throw IllegalStateException("No activity found to handle this intent.")
    }