package com.liecoder.framework.manager

import android.app.Activity
import android.app.Application
import android.os.Bundle
import com.liecoder.framework.model.AppStatus
import com.liecoder.framework.service.IAppStatusService

object LifecycleManager {

    private var activityStartCount = 0

    fun register(mService: IAppStatusService) {
        (mService as Application).registerActivityLifecycleCallbacks(object : Application
            .ActivityLifecycleCallbacks {
            override fun onActivityPaused(activity: Activity) {
            }

            override fun onActivityResumed(activity: Activity) {
            }

            override fun onActivityDestroyed(activity: Activity) {
                ActivityManager.pop(activity)
            }

            override fun onActivitySaveInstanceState(
                activity: Activity,
                outState: Bundle
            ) {
            }

            override fun onActivityCreated(
                activity: Activity,
                savedInstanceState: Bundle?
            ) {
                ActivityManager.push(activity)
            }

            override fun onActivityStarted(activity: Activity) {
                activityStartCount++
                if (activityStartCount == 1) {
                    mService.onAppStatusChanged(AppStatus.Foreground, activity)
                }
            }

            override fun onActivityStopped(activity: Activity) {
                activityStartCount--
                if (activityStartCount == 0) {
                    mService.onAppStatusChanged(AppStatus.Background, activity)
                }
            }

        })
    }
}