package com.liecoder.framework.model


/**
 * 应用程序状态枚举，用于表示应用程序的当前运行状态。
 *
 * 此枚举类定义了两个状态，分别表示应用程序在后台运行和在前台运行。
 */
enum class AppStatus {


    /**
     * 后台状态。
     *
     * 此状态表示应用程序不在当前活动的栈顶，用户不与之交互。在 Android 中，当应用程序的所有 Activity 都被覆盖或关闭时，该应用程序即处于后台状态。
     */
    Background,


    /**
     * 前台状态。
     *
     * 此状态表示应用程序当前在用户的设备屏幕上可见，并且是用户正在交互的应用程序。在 Android 中，当应用程序的 Activity 处于活动状态并且用户可以与之交互时，该应用程序即处于前台状态。
     */
    Foreground,
}