package com.liecoder.framework.toast

import android.annotation.SuppressLint
import android.app.Application
import android.content.Context
import android.graphics.drawable.Drawable
import android.view.Gravity
import android.widget.Toast
import kotlinx.coroutines.DelicateCoroutinesApi

/**
 * Author: liecoder
 * Date: 2024/8/13 周二
 * Version: 1.0
 */
@SuppressLint("StaticFieldLeak")
object TipsToast {

    private lateinit var mContext: Context

    val Success by lazy { SuccessImpl(mContext) }

    val Errors by lazy { ErrorImpl(mContext) }

    val Warnings by lazy { WarningImpl(mContext) }

    val Infos by lazy { InfoImpl(mContext) }

    var mCurrentToast: ITipsToastService? = null

    fun init(context: Application) {
        this.mContext = context
    }

    @JvmStatic
    fun success(message: CharSequence?) = Success.show(message)

    @JvmStatic
    fun error(message: CharSequence?) = Errors.show(message)

    @JvmStatic
    fun warning(message: CharSequence?) = Warnings.show(message)

    @JvmStatic
    fun info(message: CharSequence?) = Infos.show(message)

    @JvmStatic
    fun custom(
        message: CharSequence?,
        successIcon: Drawable? = null,
        errorIcon: Drawable? = null,
        warningIcon: Drawable? = null,
        gravity: Int = Gravity.CENTER,
        xOffset: Int = 0,
        yOffset: Int = 0,
        duration: Int = Toast.LENGTH_LONG,
        style: ToastStyle? = null
    ) = TipsToastImpl(
        context = mContext,
        mSuccessIcon = successIcon,
        mErrorIcon = errorIcon,
        mWarningIcon = warningIcon,
        mGravity = gravity,
        mXOffset = xOffset,
        mYOffset = yOffset,
        mDuration = duration
    ).show(message = message, style = style)

}