package com.liecoder.framework.ktx

import android.graphics.Outline
import android.view.View
import android.view.ViewOutlineProvider

/**
 * 设置视图的圆角。
 *
 * 此扩展函数为任意视图提供了设置圆角的功能。如果指定的圆角大小为0，则不应用圆角效果；否则，将视图的轮廓设置为圆角矩形。
 *
 * @param radius 圆角的尺寸，以像素为单位。如果该值为0，则视图不会有圆角效果。
 * @return 返回自身，允许链式调用。
 */
fun <T : View> T.radius(radius: Int): T {
    if (radius == 0) {
        clipToOutline = false
    } else {
        clipToOutline = true
        outlineProvider = object : ViewOutlineProvider() {
            override fun getOutline(
                view: View?, outLine: Outline?
            ) {
                outLine?.setRoundRect(0, 0, view?.width ?: 0, view?.height ?: 0, radius.dpFloat)
            }
        }
    }
    return this
}


/**
 * 设置视图顶部圆角。
 *
 * 此扩展函数为任意视图提供了设置顶部圆角的功能。如果指定的圆角大小为0，则不应用圆角效果；否则，将视图顶部的轮廓设置为圆角。
 *
 * @param radius 圆角的尺寸，以像素为单位。如果该值为0，则视图顶部不会有圆角效果。
 * @return 返回自身，允许链式调用。
 */
fun <T : View> T.topRadius(radius: Int): T {
    if (radius == 0) {
        clipToOutline = false
    } else {
        clipToOutline = true
        outlineProvider = object : ViewOutlineProvider() {
            override fun getOutline(
                view: View?, outline: Outline?
            ) {
                outline?.setRoundRect(
                    0, 0, view?.width ?: 0, (view?.height ?: 0) + radius.dpInt, radius.dpFloat
                )
            }
        }
    }
    return this
}

/**
 * 设置视图底部圆角。
 *
 * 此扩展函数为任意视图提供了设置底部圆角的功能。如果指定的圆角大小为0，则不应用圆角效果；否则，将视图底部的轮廓设置为圆角。
 *
 * @param radius 圆角的尺寸，以像素为单位。如果该值为0，则视图底部不会有圆角效果。
 * @return 返回自身，允许链式调用。
 */
fun <T : View> T.bottomRadius(radius: Int): T {
    if (radius == 0) {
        clipToOutline = false
    } else {
        clipToOutline = true
        outlineProvider = object : ViewOutlineProvider() {
            override fun getOutline(
                view: View?, outLine: Outline?
            ) {
                outLine?.setRoundRect(
                    0, -radius.dpInt, view?.width ?: 0, view?.height ?: 0, radius.dpFloat
                )
            }
        }
    }
    return this
}