package com.liecoder.framework.ktx

import android.content.SharedPreferences
import com.liecoder.framework.global.AppHelper


/**
 * 向 SharedPreferences 写入数据。
 * 使用 lambda 表达式简化 SharedPreferences.Editor 的操作。
 *
 * @param put 一个 lambda 表达式，定义了对 SharedPreferences.Editor 的修改操作。
 */
fun writeSharedPreferences(put: SharedPreferences.Editor.() -> Unit) {
    val sharedPreferences = AppHelper.createSharedPreferences()
    val editor = sharedPreferences.edit()
    put.invoke(editor)
    editor.apply()
}


/**
 * 从 SharedPreferences 读取数据。
 * 根据提供的键和期望的类型，尝试读取并转换 SharedPreferences 中的数据。
 *
 * @param key SharedPreferences 中的数据键。
 * @return 返回转换后的泛型类型 T 的数据，如果键不存在或转换失败，则返回 null。
 */
inline fun <reified T> readSharedPreferences(key: String): T? {
    val sharedPreferences = AppHelper.createSharedPreferences()
    return if (sharedPreferences.contains(key)) sharedPreferences.all[key]?.saveAs() else null
}
