package com.liecoder.framework.model


/**
 * 构建类型枚举，用于标识应用程序的不同构建环境。
 *
 * 此枚举类定义了应用程序可能用于的不同构建环境，每种环境都有其特定的配置和行为。
 */
enum class BuildType {

    /**
     * 开发环境。
     *
     * 用于开发过程中的构建，通常包含额外的日志记录、调试工具和开发特定的功能。
     */
    DEVELOPMENT,

    /**
     * 测试环境。
     *
     * 用于质量保证和测试目的的构建，可能包括额外的测试覆盖率工具或测试钩子。
     */
    TESTING,

    /**
     * 生产环境。
     *
     * 用于生产环境的构建，这些构建通常是优化过的，移除了所有调试代码，确保性能和安全性。
     */
    PRODUCTION
}