package com.liecoder.framework.dialog

import android.view.LayoutInflater
import android.view.View.GONE
import android.view.View.VISIBLE
import androidx.annotation.StringRes
import androidx.fragment.app.FragmentActivity
import com.liecoder.framework.databinding.LayoutCommonDialogBinding
import com.liecoder.framework.dialog.BaseDialog.AnimStyle.TOAST
import com.liecoder.framework.ktx.radius
import com.liecoder.framework.ktx.setGone
import com.liecoder.framework.ktx.setVisible

/**
 * Author: liecoder
 * Date: 2024/6/21 周五
 * Version: 1.0
 */
class CommonDialog {

    class Builder(activity: FragmentActivity) : BaseDialogFragment.Builder<Builder>(activity) {

        private val mBinding: LayoutCommonDialogBinding
        private var onPositive: (() -> Unit)? = null
        private var onNegative: (() -> Unit)? = null

        init {
            mBinding = LayoutCommonDialogBinding.inflate(LayoutInflater.from(activity))
            setContentView(mBinding.root.radius(12))
            setAnimStyle(TOAST)
            mBinding.ivCloseDialog.setOnClickListener { dismiss() }
            mBinding.tvPositiveButton.setOnClickListener {
                onPositive?.invoke()
                dismiss()
            }
            mBinding.tvNegativeButton.setOnClickListener {
                onNegative?.invoke()
                dismiss()
            }
        }

        fun showClosingIcon(show: Boolean): Builder {
            mBinding.ivCloseDialog.visibility = if (show) VISIBLE else GONE
            return this
        }

        fun setTitle(title: String?): Builder {
            mBinding.tvTitle.setGone(title.isNullOrEmpty()).text = title
            return this
        }

        fun setTitle(@StringRes title: Int): Builder {
            mBinding.tvTitle.setText(title)
            return this
        }

        fun setTitleColor(color: Int): Builder {
            mBinding.tvTitle.setTextColor(color)
            return this
        }

        fun setTitleSize(size: Float): Builder {
            mBinding.tvTitle.textSize = size
            return this
        }

        fun setTitleGravity(gravity: Int): Builder {
            mBinding.tvTitle.gravity = gravity
            return this
        }

        fun setTitleVisible(visible: Boolean = true): Builder {
            mBinding.tvTitle.visibility = if (visible) VISIBLE else GONE
            return this
        }

        fun setMessage(message: String): Builder {
            mBinding.tvMessage.text = message
            return this
        }

        fun setMessage(@StringRes message: Int): Builder {
            mBinding.tvMessage.setText(message)
            return this
        }

        fun setMessageColor(color: Int): Builder {
            mBinding.tvMessage.setTextColor(color)
            return this
        }

        fun setMessageSize(size: Float): Builder {
            mBinding.tvMessage.textSize = size
            return this
        }

        fun setMessageGravity(gravity: Int): Builder {
            mBinding.tvMessage.gravity = gravity
            return this
        }

        fun setMessageVisible(visible: Boolean = true): Builder {
            mBinding.tvMessage.visibility = if (visible) VISIBLE else GONE
            return this
        }

        fun setPositiveButton(text: String): Builder {
            mBinding.tvPositiveButton.text = text
            return this
        }

        fun setPositiveButton(@StringRes text: Int): Builder {
            mBinding.tvPositiveButton.setText(text)
            return this
        }

        fun setPositiveButtonColor(color: Int): Builder {
            mBinding.tvPositiveButton.setTextColor(color)
            return this
        }

        fun setPositiveButtonSize(size: Float): Builder {
            mBinding.tvPositiveButton.textSize = size
            return this
        }

        fun setNegativeButton(text: String): Builder {
            mBinding.tvNegativeButton.text = text
            return this
        }

        fun setNegativeButton(@StringRes text: Int): Builder {
            mBinding.tvNegativeButton.setText(text)
            return this
        }

        fun setNegativeButtonColor(color: Int): Builder {
            mBinding.tvNegativeButton.setTextColor(color)
            return this
        }

        fun setNegativeButtonSize(size: Float): Builder {
            mBinding.tvNegativeButton.textSize = size
            return this
        }

        fun setPositiveListener(onPositive: () -> Unit): Builder {
            this.onPositive = onPositive
            return this
        }

        fun setNegativeListener(onNegative: () -> Unit): Builder {
            this.onNegative = onNegative
            return this
        }

        fun setSingleButton(singleButton: Boolean = true): Builder {
            mBinding.tvNegativeButton.visibility = if (singleButton) GONE else VISIBLE
            mBinding.verticalLine.visibility = if (singleButton) GONE else VISIBLE
            return this
        }

    }

}