package com.liecoder.framework.dialog

import android.animation.ValueAnimator.INFINITE
import android.app.Dialog
import android.content.Context
import android.view.LayoutInflater
import android.view.Window
import android.view.animation.Animation
import android.view.animation.LinearInterpolator
import android.view.animation.RotateAnimation
import androidx.annotation.StringRes
import com.liecoder.framework.R
import com.liecoder.framework.databinding.LayoutToastDialogBinding
import com.liecoder.framework.ktx.getResourcesString
import com.liecoder.framework.ktx.onClick
import com.liecoder.framework.ktx.radius
import com.liecoder.framework.ktx.setVisible

/**
 * Author: liecoder
 * Date: 2024/9/3 周二
 * Version: 1.0
 */
class ToastDialog(context: Context) : Dialog(context, R.style.toast_dialog) {

    private var mBinding: LayoutToastDialogBinding
    private var animation: Animation? = null
    private var mOperation: (() -> Unit)? = null

    init {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setCanceledOnTouchOutside(false)
        setCancelable(false)
        mBinding = LayoutToastDialogBinding.inflate(LayoutInflater.from(context))
        mBinding.root.radius(8)
        mBinding.tvOperation.onClick {
            mOperation?.invoke()
            dismiss()
        }
        setContentView(mBinding.root)
        initAnimation()
    }

    private fun initAnimation() {
        animation = RotateAnimation(
            0f, 360f, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f
        ).apply {
            duration = 1_440
            interpolator = LinearInterpolator()
            repeatCount = INFINITE
            fillAfter = false
        }
    }

    fun setShowLoading(show: Boolean): ToastDialog {
        mBinding.ivLoading.setVisible(show)
        return this
    }

    fun setMessage(message: CharSequence?): ToastDialog {
        mBinding.tvMessage.text = message ?: getResourcesString(R.string.loadingMessage)
        return this
    }

    fun setMessage(@StringRes messageRes: Int): ToastDialog =
        setMessage(getResourcesString(messageRes))

    fun setOperation(operation: (() -> Unit)?): ToastDialog {
        mOperation = operation
        return this
    }

    fun setShowOperation(show: Boolean): ToastDialog {
        mBinding.tvOperation.setVisible(show)
        return this
    }

    fun setOperationText(text: CharSequence?): ToastDialog {
        mBinding.tvOperation.text = text ?: getResourcesString(R.string.loading_cancel)
        return this
    }

    fun setOperationText(@StringRes textRes: Int): ToastDialog =
        setOperationText(getResourcesString(textRes))

    override fun show() {
        super.show()
        mBinding.ivLoading.startAnimation(animation)
    }

    override fun dismiss() {
        super.dismiss()
        mBinding.ivLoading.clearAnimation()
    }

}