package com.liecoder.framework.ktx

import android.view.View

/**
 * 设置视图的可见性。如果条件为 true，则视图为可见（View.VISIBLE）；否则，视图为隐藏（View.GONE）。
 *
 * @param visible 决定视图是否可见的条件。默认值为 `true`。
 * @return 返回同一个视图实例以支持链式调用。
 */
fun <V : View> V.setVisible(visible: Boolean = true): V {
    visibility = if (visible) View.VISIBLE else View.GONE
    return this
}

/**
 * 设置视图的可见性。如果条件为 true，则视图为不在（View.GONE）；否则，视图为可见（View.VISIBLE）。
 *
 * @param gone 决定视图是否不在的条件。默认值为 `true`。
 * @return 返回同一个视图实例以支持链式调用。
 */
fun <V : View> V.setGone(gone: Boolean = true): V {
    visibility = if (gone) View.GONE else View.VISIBLE
    return this
}

/**
 * 设置视图的可见性。如果条件为 true，则视图为不可见但保留布局空间（View.INVISIBLE）；否则，视图为可见（View.VISIBLE）。
 *
 * @param invisible 决定视图是否不可见的条件。默认值为 `true`。
 * @return 返回同一个视图实例以支持链式调用。
 */
fun <V : View> V.setInvisible(invisible: Boolean = true): V {
    visibility = if (invisible) View.INVISIBLE else View.VISIBLE
    return this
}
