package com.liecoder.framework.service

import android.content.Context.MODE_PRIVATE


/**
 * SharedPreferences 服务接口，定义了获取 SharedPreferences 相关配置的方法。
 *
 * 此接口规定了如何获取 SharedPreferences 文件的名称和访问模式，使得在应用程序中使用 SharedPreferences 时可以保持一致性和可配置性。
 */
interface ISharedPreferencesService {

    /**
     * 定义了默认的 SharedPreferences 文件名称。
     *
     * 这个常量用于当没有提供特定的 SharedPreferences 文件名时，提供一个默认的文件名。
     */
    companion object {
        private const val DEFAULT_SHARED_PREF_NAME = "app_preferences"
    }

    /**
     * 获取 SharedPreferences 的文件名。
     *
     * 此方法提供了一个默认实现，返回 [DEFAULT_SHARED_PREF_NAME] 作为 SharedPreferences 文件的名称。
     * 实现此接口的类可以重写此方法以提供不同的文件名，但默认情况下使用 "app_preferences"。
     *
     * @return 返回一个字符串，表示 SharedPreferences 文件的名称。
     */
    fun getSharedPreferencesFileName(): String = DEFAULT_SHARED_PREF_NAME



    /**
     * 获取 SharedPreferences 的访问模式。
     *
     * 此方法提供了一个默认实现，返回 [Context.MODE_PRIVATE] 作为 SharedPreferences 的访问模式，表示只有当前应用程序可以访问这些偏好设置。
     * 实现此接口的类可以重写此方法以提供不同的访问模式，例如，如果需要跨应用程序共享偏好设置，可以返回 [Context.MODE_MULTI_PROCESS]。
     *
     * @return 返回一个整数，表示 SharedPreferences 的访问模式。
     */
    fun getSharedPreferencesMode(): Int = MODE_PRIVATE
}