package com.liecoder.framework.ktx

import java.util.regex.Pattern

/**
 * 检查是否为有效的邮箱地址
 */
fun CharSequence.isValidEmail(): Boolean {
    if (isContainChineseCharacters()) {
        return false
    }
    if (isNullOrEmpty()) {
        return false
    }
    return Pattern
            .compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*")
            .matcher(this)
            .matches()
}

/**
 * 判断是否为有效的手机号码
 */
fun CharSequence.isValidPhoneNumber(): Boolean {
    return Pattern
            .compile("^(?:(?:\\+|00)86)?1[3-9]\\d{9}$")
            .matcher(this)
            .matches()
}

/**
 * 检查是否为有效的统一社会信任代码（税号）
 */
fun CharSequence.isValidSocialCreditCode(): Boolean {
    return Pattern
            .compile("^[0-9A-Z]{15}|^[0-9A-Z]{18}|^[0-9A-Z]{20}$")
            .matcher(this)
            .matches()
}

/**
 * 判断是否包含汉字
 */
fun CharSequence.isContainChineseCharacters(): Boolean {
    val pattern = Pattern.compile("[\u4e00-\u9fa5]")
    return pattern
            .matcher(this)
            .find()
}

/**
 * 过滤表情符
 */
fun CharSequence.filterEmoji(): CharSequence {
    return this@filterEmoji.filterNot { it.isEmoji() }
}

/**
 * 返回字符串在parent中的range
 */
fun String.range(parent: String): IntRange {
    val start = parent.indexOf(this)
    val end = start + this.length
    return start..end
}

/**
 * 手机号加密
 */
fun String.encryptPhoneNumber(): String {
    return if (this.length == 11) {
        this.substring(
                0,
                3
        ) + "****" + this.substring(7)
    } else {
        this
    }
}
