package com.liecoder.framework.titlebar

import android.content.Context
import android.content.res.ColorStateList
import android.graphics.drawable.ColorDrawable
import android.graphics.drawable.Drawable
import com.liecoder.framework.R
import com.liecoder.framework.ktx.getDrawableCompat


/**
 * Author: lieco(liecoder@163.com)
 * Date: 2024/8/18
 * Version: 1.0
 */
class StyleNight : ITitleBarStyleService {
    /**
     * 获取标题栏背景的 Drawable 对象。
     *
     * @param context 上下文对象。
     * @return 标题栏背景的 Drawable 对象，可能为 null。
     */
    override fun getTitleBarBackground(context: Context): Drawable = ColorDrawable(-0x1000000)

    /**
     * 获取标题栏左侧背景的 Drawable 对象。
     *
     * @param context 上下文对象。
     * @return 标题栏左侧背景的 Drawable 对象，可能为 null。
     */
    override fun getLeftTitleBackground(context: Context): Drawable = SelectorDrawable.builder()
        .setDefault(ColorDrawable(0x00000000))
        .setFocused(ColorDrawable(0x66FFFFFF))
        .setPressed(ColorDrawable(0x66FFFFFF))
        .build()

    /**
     * 获取标题栏右侧背景的 Drawable 对象。
     *
     * @param context 上下文对象。
     * @return 标题栏右侧背景的 Drawable 对象，可能为 null。
     */
    override fun getRightTitleBackground(context: Context): Drawable = SelectorDrawable.builder()
        .setDefault(ColorDrawable(0x00000000))
        .setFocused(ColorDrawable(0x66FFFFFF))
        .setPressed(ColorDrawable(0x66FFFFFF))
        .build()

    /**
     * 获取返回按钮的 Drawable 对象。
     *
     * @param context 上下文对象。
     * @return 返回按钮的 Drawable 对象，可能为 null。
     */
    override fun getBackButtonDrawable(context: Context): Drawable? =
        context.getDrawableCompat(R.drawable.ic_arrows_left_white)

    /**
     * 获取左侧标题文本颜色的状态列表。
     *
     * @param context 上下文对象。
     * @return 左侧标题文本颜色的状态列表，可能为 null。
     */
    override fun getLeftTitleColor(context: Context): ColorStateList =
        ColorStateList.valueOf(-0x33000001)

    /**
     * 获取中间标题文本颜色的状态列表。
     *
     * @param context 上下文对象。
     * @return 中间标题文本颜色的状态列表，可能为 null。
     */
    override fun getTitleColor(context: Context): ColorStateList =
        ColorStateList.valueOf(-0x11000001)

    /**
     * 获取右侧标题文本颜色的状态列表。
     *
     * @param context 上下文对象。
     * @return 右侧标题文本颜色的状态列表，可能为 null。
     */
    override fun getRightTitleColor(context: Context): ColorStateList =
        ColorStateList.valueOf(-0x33000001)

    /**
     * 获取标题栏底部的线条背景的 Drawable 对象。
     *
     * @param context 上下文对象。
     * @return 标题栏底部的线条背景的 Drawable 对象。
     */
    override fun getLineDrawable(context: Context): Drawable = ColorDrawable(-0x1)
}