package com.liecoder.framework.application

import android.app.Application
import com.liecoder.framework.global.AppHelper
import com.liecoder.framework.manager.DeviceInfoManager
import com.liecoder.framework.model.BuildType
import com.liecoder.framework.service.IBuildTypeService
import com.liecoder.framework.service.ISharedPreferencesService
import com.liecoder.framework.toast.TipsToast


/**
 * 基类应用程序，用于设置和管理应用程序的生命周期、环境和状态。
 *
 * 继承自 Android 的 Application 类，实现了 IBuildTypeService 和 ISharedPreferencesService 接口，
 * 以提供全局应用程序上下文、配置运行环境、检查当前运行状态、SharedPreferences 扩展功能和提示（Toast）工具。
 * 这个类旨在作为任何自定义应用程序类的基类，以便在整个应用程序中保持一致的配置和行为。
 */
abstract class BaseApplication : Application(), IBuildTypeService, ISharedPreferencesService {


    /**
     * 提供当前应用程序的构建类型。
     *
     * 作为 IBuildTypeService 接口的一部分，此抽象属性必须在子类中实现，
     * 以指定应用程序是运行在开发、测试还是生产环境中。
     */
    abstract override val buildType: BuildType


    override fun onCreate() {
        super.onCreate()
        AppHelper.init(application = this, buildType = buildType)
        TipsToast.init(context = this)
        DeviceInfoManager.init(context = this)
    }

}