package com.liecoder.framework.base

import androidx.viewbinding.ViewBinding

/**
 * 视图绑定服务接口，提供访问 ViewBinding 实例的标准方式。
 *
 * <p>此接口定义了访问和创建 ViewBinding 对象的方法，ViewBinding 是 Android 提供的一种用于绑定 XML 布局到代码的机制。
 * 通过实现此接口，可以确保在应用程序的不同部分中以统一和类型安全的方式使用 ViewBinding。
 *
 * @author liecoder
 * @date 2024/6/21 周五
 * @version 1.0
 */
interface IViewBindingService {


    /**
     * 访问 ViewBinding 实例的属性。
     *
     * 此属性应返回当前视图的 ViewBinding 实例。它通常是在类的初始化阶段创建的，并在整个视图的生命周期内被复用。
     */
    val mBinding: ViewBinding


    /**
     * 创建或获取 ViewBinding 实例的方法。
     *
     * 此方法应返回当前视图的 ViewBinding 实例。具体的实现可能包括使用 Java 反射或 Kotlin 反射来动态创建 ViewBinding 对象。
     * 这个方法通常在视图的 onCreate 或类似生命周期方法中被调用。
     *
     * @return 当前视图的 ViewBinding 实例。
     */
    fun viewBinding(): ViewBinding

}