package com.liecoder.framework.ktx

import android.os.Build
import android.view.Gravity
import android.view.View


/**
 * 获取与当前布局方向相关的绝对位置方向。
 *
 * 此函数根据传入的 [gravity] 参数和当前布局方向，计算出绝对位置的方向。在 Android 4.2（API 级别 17，Jelly Bean MR1）及以上版本，使用 [Gravity.getAbsoluteGravity] 方法来获取正确的值；在更低版本上，直接返回原始的 [gravity] 参数，假设布局方向为从左到右。
 *
 * @param gravity 原始的方向，可以是 [Gravity.LEFT]、[Gravity.RIGHT] 等。
 * @return 返回考虑布局方向后的绝对位置方向。
 */
fun View.getAbsoluteGravity(gravity: Int): Int =
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
        Gravity.getAbsoluteGravity(gravity, resources.configuration.layoutDirection)
    } else {
        gravity
    }