package com.liecoder.framework.toast

import android.content.Context
import android.graphics.drawable.Drawable
import android.view.Gravity
import android.view.LayoutInflater
import android.widget.Toast
import com.liecoder.framework.databinding.LayoutTipsToastBinding
import com.liecoder.framework.ktx.e
import com.liecoder.framework.ktx.glide
import com.liecoder.framework.ktx.radius
import com.liecoder.framework.ktx.setGone
import kotlinx.coroutines.CoroutineExceptionHandler
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch


/**
 * Author: lieco(liecoder@163.com)
 * Date: 2024/8/19
 * Version: 1.0
 */
@OptIn(DelicateCoroutinesApi::class)
open class TipsToastImpl(
    private val context: Context,
    private val mSuccessIcon: Drawable? = null,
    private val mErrorIcon: Drawable? = null,
    private val mWarningIcon: Drawable? = null,
    private val mGravity: Int = Gravity.CENTER,
    private val mXOffset: Int = 0,
    private val mYOffset: Int = 0,
    private val mDuration: Int = Toast.LENGTH_LONG,
) : ITipsToastService {

    private var toast: Toast? = null

    private val mBinding by lazy {
        LayoutTipsToastBinding.inflate(LayoutInflater.from(context), null, false)
    }

    override fun show(message: CharSequence?, style: ToastStyle?) {
        val handler = CoroutineExceptionHandler { _, throwable ->
            e("Show toast error: ${throwable.message}")
            toast?.cancel()
        }
        GlobalScope.launch(Dispatchers.Main + handler) {
            TipsToast.mCurrentToast?.cancel()
            TipsToast.mCurrentToast = null
            toast = Toast(context)
            toast?.view = mBinding.root.radius(12)
            toast?.setGravity(mGravity, mXOffset, mYOffset)
            toast?.duration = mDuration
            val drawable = when (style) {
                ToastStyle.SUCCESS -> mSuccessIcon
                ToastStyle.ERROR -> mErrorIcon
                ToastStyle.WARNING -> mWarningIcon
                else -> null
            }
            mBinding.ivImage.setGone(drawable == null).glide(imageResource = drawable)
            mBinding.tvMsg.text = message
            toast?.show()
            TipsToast.mCurrentToast = this@TipsToastImpl
        }
    }

    override fun cancel() {
        toast?.cancel()
    }

}