package com.liecoder.framework.dialog

import android.content.Context
import com.liecoder.framework.manager.ActivityManager

class LoadingView(private val mContext: Context) {

    private var loadingView: LoadingDialog? = null

    fun show(message: String? = null) {
        if (ActivityManager.isActivityDestroyed(mContext)) return
        if (loadingView == null) {
            loadingView = LoadingDialog(mContext)
        }
        loadingView?.setLoadingMessage(message)
        if (loadingView?.isShowing != true) {
            loadingView?.show()
        }
    }

    fun dismiss() {
        if (ActivityManager.isActivityDestroyed(mContext)) return
        loadingView?.let {
            if (it.isShowing) it.dismiss()
        }
    }

}
